package zeenea.connector.sqlserver.services.ssis;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;

/**
 * Immutable implementation of {@link IntegrationServicesConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableIntegrationServicesConfig.builder()}.
 */
@Generated(from = "IntegrationServicesConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableIntegrationServicesConfig
    implements IntegrationServicesConfig {
  @NotNull
  private final String connectionName;
  private final boolean multiCatalog;

  private ImmutableIntegrationServicesConfig(String connectionName, boolean multiCatalog) {
    this.connectionName = connectionName;
    this.multiCatalog = multiCatalog;
  }

  /**
   * @return The value of the {@code connectionName} attribute
   */
  @NotNull
  @Override
  public String connectionName() {
    return connectionName;
  }

  /**
   * @return The value of the {@code multiCatalog} attribute
   */
  @Override
  public boolean multiCatalog() {
    return multiCatalog;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IntegrationServicesConfig#connectionName() connectionName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for connectionName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIntegrationServicesConfig withConnectionName(String value) {
    String newValue = Objects.requireNonNull(value, "connectionName");
    if (this.connectionName.equals(newValue)) return this;
    return new ImmutableIntegrationServicesConfig(newValue, this.multiCatalog);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IntegrationServicesConfig#multiCatalog() multiCatalog} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for multiCatalog
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableIntegrationServicesConfig withMultiCatalog(boolean value) {
    if (this.multiCatalog == value) return this;
    return new ImmutableIntegrationServicesConfig(this.connectionName, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableIntegrationServicesConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableIntegrationServicesConfig
        && equalTo(0, (ImmutableIntegrationServicesConfig) another);
  }

  private boolean equalTo(int synthetic, ImmutableIntegrationServicesConfig another) {
    return connectionName.equals(another.connectionName)
        && multiCatalog == another.multiCatalog;
  }

  /**
   * Computes a hash code from attributes: {@code connectionName}, {@code multiCatalog}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + connectionName.hashCode();
    h += (h << 5) + Boolean.hashCode(multiCatalog);
    return h;
  }

  /**
   * Prints the immutable value {@code IntegrationServicesConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "IntegrationServicesConfig{"
        + "connectionName=" + connectionName
        + ", multiCatalog=" + multiCatalog
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link IntegrationServicesConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IntegrationServicesConfig instance
   */
  public static ImmutableIntegrationServicesConfig copyOf(IntegrationServicesConfig instance) {
    if (instance instanceof ImmutableIntegrationServicesConfig) {
      return (ImmutableIntegrationServicesConfig) instance;
    }
    return ImmutableIntegrationServicesConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableIntegrationServicesConfig ImmutableIntegrationServicesConfig}.
   * <pre>
   * ImmutableIntegrationServicesConfig.builder()
   *    .connectionName(String) // required {@link IntegrationServicesConfig#connectionName() connectionName}
   *    .multiCatalog(boolean) // required {@link IntegrationServicesConfig#multiCatalog() multiCatalog}
   *    .build();
   * </pre>
   * @return A new ImmutableIntegrationServicesConfig builder
   */
  public static ImmutableIntegrationServicesConfig.Builder builder() {
    return new ImmutableIntegrationServicesConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableIntegrationServicesConfig ImmutableIntegrationServicesConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "IntegrationServicesConfig", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CONNECTION_NAME = 0x1L;
    private static final long INIT_BIT_MULTI_CATALOG = 0x2L;
    private long initBits = 0x3L;

    private String connectionName;
    private boolean multiCatalog;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code IntegrationServicesConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IntegrationServicesConfig instance) {
      Objects.requireNonNull(instance, "instance");
      this.connectionName(instance.connectionName());
      this.multiCatalog(instance.multiCatalog());
      return this;
    }

    /**
     * Initializes the value for the {@link IntegrationServicesConfig#connectionName() connectionName} attribute.
     * @param connectionName The value for connectionName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder connectionName(String connectionName) {
      this.connectionName = Objects.requireNonNull(connectionName, "connectionName");
      initBits &= ~INIT_BIT_CONNECTION_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link IntegrationServicesConfig#multiCatalog() multiCatalog} attribute.
     * @param multiCatalog The value for multiCatalog 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder multiCatalog(boolean multiCatalog) {
      this.multiCatalog = multiCatalog;
      initBits &= ~INIT_BIT_MULTI_CATALOG;
      return this;
    }

    /**
     * Builds a new {@link ImmutableIntegrationServicesConfig ImmutableIntegrationServicesConfig}.
     * @return An immutable instance of IntegrationServicesConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableIntegrationServicesConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableIntegrationServicesConfig(connectionName, multiCatalog);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONNECTION_NAME) != 0) attributes.add("connectionName");
      if ((initBits & INIT_BIT_MULTI_CATALOG) != 0) attributes.add("multiCatalog");
      return "Cannot build IntegrationServicesConfig, some of required attributes are not set " + attributes;
    }
  }
}
