package zeenea.connector.sqlserver.services.ssas.client.model.multidimensional;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Source}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSource.builder()}.
 */
@Generated(from = "Source", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableSource
    implements Source {
  private final @Nullable String datasourceViewId;
  private final @Nullable String tableId;
  private final @Nullable String columnId;
  private final @Nullable String dataType;
  private final @Nullable String sourceType;
  private final @Nullable Source source;

  private ImmutableSource(
      @Nullable String datasourceViewId,
      @Nullable String tableId,
      @Nullable String columnId,
      @Nullable String dataType,
      @Nullable String sourceType,
      @Nullable Source source) {
    this.datasourceViewId = datasourceViewId;
    this.tableId = tableId;
    this.columnId = columnId;
    this.dataType = dataType;
    this.sourceType = sourceType;
    this.source = source;
  }

  /**
   * @return The value of the {@code datasourceViewId} attribute
   */
  @JsonProperty("datasourceViewId")
  @JacksonXmlProperty(localName = "DataSourceViewID")
  @Override
  public @Nullable String getDatasourceViewId() {
    return datasourceViewId;
  }

  /**
   * @return The value of the {@code tableId} attribute
   */
  @JsonProperty("tableId")
  @JacksonXmlProperty(localName = "TableID")
  @Override
  public @Nullable String getTableId() {
    return tableId;
  }

  /**
   * @return The value of the {@code columnId} attribute
   */
  @JsonProperty("columnId")
  @JacksonXmlProperty(localName = "ColumnID")
  @Override
  public @Nullable String getColumnId() {
    return columnId;
  }

  /**
   * @return The value of the {@code dataType} attribute
   */
  @JsonProperty("dataType")
  @JacksonXmlProperty(localName = "DataType")
  @Override
  public @Nullable String getDataType() {
    return dataType;
  }

  /**
   * @return The value of the {@code sourceType} attribute
   */
  @JsonProperty("sourceType")
  @JacksonXmlProperty(isAttribute = true, namespace = "xsi", localName = "type")
  @Override
  public @Nullable String getSourceType() {
    return sourceType;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @JsonProperty("source")
  @JacksonXmlProperty(localName = "Source")
  @Override
  public @Nullable Source getSource() {
    return source;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Source#getDatasourceViewId() datasourceViewId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for datasourceViewId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSource withDatasourceViewId(@Nullable String value) {
    if (Objects.equals(this.datasourceViewId, value)) return this;
    return new ImmutableSource(value, this.tableId, this.columnId, this.dataType, this.sourceType, this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Source#getTableId() tableId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tableId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSource withTableId(@Nullable String value) {
    if (Objects.equals(this.tableId, value)) return this;
    return new ImmutableSource(this.datasourceViewId, value, this.columnId, this.dataType, this.sourceType, this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Source#getColumnId() columnId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for columnId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSource withColumnId(@Nullable String value) {
    if (Objects.equals(this.columnId, value)) return this;
    return new ImmutableSource(this.datasourceViewId, this.tableId, value, this.dataType, this.sourceType, this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Source#getDataType() dataType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dataType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSource withDataType(@Nullable String value) {
    if (Objects.equals(this.dataType, value)) return this;
    return new ImmutableSource(this.datasourceViewId, this.tableId, this.columnId, value, this.sourceType, this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Source#getSourceType() sourceType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sourceType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSource withSourceType(@Nullable String value) {
    if (Objects.equals(this.sourceType, value)) return this;
    return new ImmutableSource(this.datasourceViewId, this.tableId, this.columnId, this.dataType, value, this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Source#getSource() source} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSource withSource(@Nullable Source value) {
    if (this.source == value) return this;
    return new ImmutableSource(this.datasourceViewId, this.tableId, this.columnId, this.dataType, this.sourceType, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSource
        && equalTo(0, (ImmutableSource) another);
  }

  private boolean equalTo(int synthetic, ImmutableSource another) {
    return Objects.equals(datasourceViewId, another.datasourceViewId)
        && Objects.equals(tableId, another.tableId)
        && Objects.equals(columnId, another.columnId)
        && Objects.equals(dataType, another.dataType)
        && Objects.equals(sourceType, another.sourceType)
        && Objects.equals(source, another.source);
  }

  /**
   * Computes a hash code from attributes: {@code datasourceViewId}, {@code tableId}, {@code columnId}, {@code dataType}, {@code sourceType}, {@code source}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(datasourceViewId);
    h += (h << 5) + Objects.hashCode(tableId);
    h += (h << 5) + Objects.hashCode(columnId);
    h += (h << 5) + Objects.hashCode(dataType);
    h += (h << 5) + Objects.hashCode(sourceType);
    h += (h << 5) + Objects.hashCode(source);
    return h;
  }

  /**
   * Prints the immutable value {@code Source} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Source{"
        + "datasourceViewId=" + datasourceViewId
        + ", tableId=" + tableId
        + ", columnId=" + columnId
        + ", dataType=" + dataType
        + ", sourceType=" + sourceType
        + ", source=" + source
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Source", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements Source {
    String datasourceViewId;
    String tableId;
    String columnId;
    String dataType;
    String sourceType;
    Source source;
    @JsonProperty("datasourceViewId")
    @JacksonXmlProperty(localName = "DataSourceViewID")
    public void setDatasourceViewId(@Nullable String datasourceViewId) {
      this.datasourceViewId = datasourceViewId;
    }
    @JsonProperty("tableId")
    @JacksonXmlProperty(localName = "TableID")
    public void setTableId(@Nullable String tableId) {
      this.tableId = tableId;
    }
    @JsonProperty("columnId")
    @JacksonXmlProperty(localName = "ColumnID")
    public void setColumnId(@Nullable String columnId) {
      this.columnId = columnId;
    }
    @JsonProperty("dataType")
    @JacksonXmlProperty(localName = "DataType")
    public void setDataType(@Nullable String dataType) {
      this.dataType = dataType;
    }
    @JsonProperty("sourceType")
    @JacksonXmlProperty(isAttribute = true, namespace = "xsi", localName = "type")
    public void setSourceType(@Nullable String sourceType) {
      this.sourceType = sourceType;
    }
    @JsonProperty("source")
    @JacksonXmlProperty(localName = "Source")
    public void setSource(@Nullable Source source) {
      this.source = source;
    }
    @Override
    public String getDatasourceViewId() { throw new UnsupportedOperationException(); }
    @Override
    public String getTableId() { throw new UnsupportedOperationException(); }
    @Override
    public String getColumnId() { throw new UnsupportedOperationException(); }
    @Override
    public String getDataType() { throw new UnsupportedOperationException(); }
    @Override
    public String getSourceType() { throw new UnsupportedOperationException(); }
    @Override
    public Source getSource() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSource fromJson(Json json) {
    ImmutableSource.Builder builder = ImmutableSource.builder();
    if (json.datasourceViewId != null) {
      builder.datasourceViewId(json.datasourceViewId);
    }
    if (json.tableId != null) {
      builder.tableId(json.tableId);
    }
    if (json.columnId != null) {
      builder.columnId(json.columnId);
    }
    if (json.dataType != null) {
      builder.dataType(json.dataType);
    }
    if (json.sourceType != null) {
      builder.sourceType(json.sourceType);
    }
    if (json.source != null) {
      builder.source(json.source);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Source} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Source instance
   */
  public static ImmutableSource copyOf(Source instance) {
    if (instance instanceof ImmutableSource) {
      return (ImmutableSource) instance;
    }
    return ImmutableSource.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSource ImmutableSource}.
   * <pre>
   * ImmutableSource.builder()
   *    .datasourceViewId(String | null) // nullable {@link Source#getDatasourceViewId() datasourceViewId}
   *    .tableId(String | null) // nullable {@link Source#getTableId() tableId}
   *    .columnId(String | null) // nullable {@link Source#getColumnId() columnId}
   *    .dataType(String | null) // nullable {@link Source#getDataType() dataType}
   *    .sourceType(String | null) // nullable {@link Source#getSourceType() sourceType}
   *    .source(zeenea.connector.sqlserver.services.ssas.client.model.multidimensional.Source | null) // nullable {@link Source#getSource() source}
   *    .build();
   * </pre>
   * @return A new ImmutableSource builder
   */
  public static ImmutableSource.Builder builder() {
    return new ImmutableSource.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSource ImmutableSource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Source", generator = "Immutables")
  public static final class Builder {
    private String datasourceViewId;
    private String tableId;
    private String columnId;
    private String dataType;
    private String sourceType;
    private Source source;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Source} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Source instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String datasourceViewIdValue = instance.getDatasourceViewId();
      if (datasourceViewIdValue != null) {
        datasourceViewId(datasourceViewIdValue);
      }
      @Nullable String tableIdValue = instance.getTableId();
      if (tableIdValue != null) {
        tableId(tableIdValue);
      }
      @Nullable String columnIdValue = instance.getColumnId();
      if (columnIdValue != null) {
        columnId(columnIdValue);
      }
      @Nullable String dataTypeValue = instance.getDataType();
      if (dataTypeValue != null) {
        dataType(dataTypeValue);
      }
      @Nullable String sourceTypeValue = instance.getSourceType();
      if (sourceTypeValue != null) {
        sourceType(sourceTypeValue);
      }
      @Nullable Source sourceValue = instance.getSource();
      if (sourceValue != null) {
        source(sourceValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Source#getDatasourceViewId() datasourceViewId} attribute.
     * @param datasourceViewId The value for datasourceViewId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("datasourceViewId")
    @JacksonXmlProperty(localName = "DataSourceViewID")
    public final Builder datasourceViewId(@Nullable String datasourceViewId) {
      this.datasourceViewId = datasourceViewId;
      return this;
    }

    /**
     * Initializes the value for the {@link Source#getTableId() tableId} attribute.
     * @param tableId The value for tableId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tableId")
    @JacksonXmlProperty(localName = "TableID")
    public final Builder tableId(@Nullable String tableId) {
      this.tableId = tableId;
      return this;
    }

    /**
     * Initializes the value for the {@link Source#getColumnId() columnId} attribute.
     * @param columnId The value for columnId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("columnId")
    @JacksonXmlProperty(localName = "ColumnID")
    public final Builder columnId(@Nullable String columnId) {
      this.columnId = columnId;
      return this;
    }

    /**
     * Initializes the value for the {@link Source#getDataType() dataType} attribute.
     * @param dataType The value for dataType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dataType")
    @JacksonXmlProperty(localName = "DataType")
    public final Builder dataType(@Nullable String dataType) {
      this.dataType = dataType;
      return this;
    }

    /**
     * Initializes the value for the {@link Source#getSourceType() sourceType} attribute.
     * @param sourceType The value for sourceType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("sourceType")
    @JacksonXmlProperty(isAttribute = true, namespace = "xsi", localName = "type")
    public final Builder sourceType(@Nullable String sourceType) {
      this.sourceType = sourceType;
      return this;
    }

    /**
     * Initializes the value for the {@link Source#getSource() source} attribute.
     * @param source The value for source (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("source")
    @JacksonXmlProperty(localName = "Source")
    public final Builder source(@Nullable Source source) {
      this.source = source;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSource ImmutableSource}.
     * @return An immutable instance of Source
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSource build() {
      return new ImmutableSource(datasourceViewId, tableId, columnId, dataType, sourceType, source);
    }
  }
}
