package zeenea.connector.sqlserver.services.ssas.client.model.multidimensional;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Server}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableServer.builder()}.
 */
@Generated(from = "Server", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableServer
    implements Server {
  private final List<Database> databases;

  private ImmutableServer(
      List<Database> databases) {
    this.databases = databases;
  }

  /**
   * @return The value of the {@code databases} attribute
   */
  @JsonProperty("databases")
  @JacksonXmlElementWrapper(localName = "Databases")
  @Override
  public List<Database> getDatabases() {
    return databases;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Server#getDatabases() databases}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableServer withDatabases(Database... elements) {
    List<Database> newValue = List.of(elements);
    return new ImmutableServer(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Server#getDatabases() databases}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of databases elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableServer withDatabases(Iterable<? extends Database> elements) {
    if (this.databases == elements) return this;
    List<Database> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Database>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableServer(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableServer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableServer
        && equalTo(0, (ImmutableServer) another);
  }

  private boolean equalTo(int synthetic, ImmutableServer another) {
    return databases.equals(another.databases);
  }

  /**
   * Computes a hash code from attributes: {@code databases}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + databases.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Server} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Server{"
        + "databases=" + databases
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Server} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Server instance
   */
  public static ImmutableServer copyOf(Server instance) {
    if (instance instanceof ImmutableServer) {
      return (ImmutableServer) instance;
    }
    return ImmutableServer.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableServer ImmutableServer}.
   * <pre>
   * ImmutableServer.builder()
   *    .addDatabases|addAllDatabases(zeenea.connector.sqlserver.services.ssas.client.model.multidimensional.Database) // {@link Server#getDatabases() databases} elements
   *    .build();
   * </pre>
   * @return A new ImmutableServer builder
   */
  public static ImmutableServer.Builder builder() {
    return new ImmutableServer.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableServer ImmutableServer}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Server", generator = "Immutables")
  @JacksonXmlRootElement(localName = "Server")
  public static final class Builder {
    private List<Database> databases = new ArrayList<Database>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Server} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Server instance) {
      Objects.requireNonNull(instance, "instance");
      addAllDatabases(instance.getDatabases());
      return this;
    }

    /**
     * Adds one element to {@link Server#getDatabases() databases} list.
     * @param element A databases element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDatabases(Database element) {
      this.databases.add(Objects.requireNonNull(element, "databases element"));
      return this;
    }

    /**
     * Adds elements to {@link Server#getDatabases() databases} list.
     * @param elements An array of databases elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDatabases(Database... elements) {
      for (Database element : elements) {
        this.databases.add(Objects.requireNonNull(element, "databases element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Server#getDatabases() databases} list.
     * @param elements An iterable of databases elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("databases")
    @JacksonXmlElementWrapper(localName = "Databases")
    public final Builder databases(Iterable<? extends Database> elements) {
      this.databases.clear();
      return addAllDatabases(elements);
    }

    /**
     * Adds elements to {@link Server#getDatabases() databases} list.
     * @param elements An iterable of databases elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDatabases(Iterable<? extends Database> elements) {
      for (Database element : elements) {
        this.databases.add(Objects.requireNonNull(element, "databases element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableServer ImmutableServer}.
     * @return An immutable instance of Server
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableServer build() {
      return new ImmutableServer(List.copyOf(databases));
    }
  }
}
