package zeenea.connector.sqlserver.services.ssas.client.model.multidimensional;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MetadataRow}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMetadataRow.builder()}.
 */
@Generated(from = "MetadataRow", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableMetadataRow
    implements MetadataRow {
  private final Metadata metadata;

  private ImmutableMetadataRow(Metadata metadata) {
    this.metadata = metadata;
  }

  /**
   * @return The value of the {@code metadata} attribute
   */
  @JsonProperty("metadata")
  @JacksonXmlProperty(namespace = "xars", localName = "METADATA")
  @Override
  public Metadata getMetadata() {
    return metadata;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MetadataRow#getMetadata() metadata} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for metadata
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMetadataRow withMetadata(Metadata value) {
    if (this.metadata == value) return this;
    Metadata newValue = Objects.requireNonNull(value, "metadata");
    return new ImmutableMetadataRow(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMetadataRow} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMetadataRow
        && equalTo(0, (ImmutableMetadataRow) another);
  }

  private boolean equalTo(int synthetic, ImmutableMetadataRow another) {
    return metadata.equals(another.metadata);
  }

  /**
   * Computes a hash code from attributes: {@code metadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + metadata.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MetadataRow} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MetadataRow{"
        + "metadata=" + metadata
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link MetadataRow} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MetadataRow instance
   */
  public static ImmutableMetadataRow copyOf(MetadataRow instance) {
    if (instance instanceof ImmutableMetadataRow) {
      return (ImmutableMetadataRow) instance;
    }
    return ImmutableMetadataRow.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMetadataRow ImmutableMetadataRow}.
   * <pre>
   * ImmutableMetadataRow.builder()
   *    .metadata(zeenea.connector.sqlserver.services.ssas.client.model.multidimensional.Metadata) // required {@link MetadataRow#getMetadata() metadata}
   *    .build();
   * </pre>
   * @return A new ImmutableMetadataRow builder
   */
  public static ImmutableMetadataRow.Builder builder() {
    return new ImmutableMetadataRow.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMetadataRow ImmutableMetadataRow}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MetadataRow", generator = "Immutables")
  @JacksonXmlRootElement(localName = "row")
  public static final class Builder {
    private static final long INIT_BIT_METADATA = 0x1L;
    private long initBits = 0x1L;

    private Metadata metadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MetadataRow} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MetadataRow instance) {
      Objects.requireNonNull(instance, "instance");
      this.metadata(instance.getMetadata());
      return this;
    }

    /**
     * Initializes the value for the {@link MetadataRow#getMetadata() metadata} attribute.
     * @param metadata The value for metadata 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    @JacksonXmlProperty(namespace = "xars", localName = "METADATA")
    public final Builder metadata(Metadata metadata) {
      this.metadata = Objects.requireNonNull(metadata, "metadata");
      initBits &= ~INIT_BIT_METADATA;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMetadataRow ImmutableMetadataRow}.
     * @return An immutable instance of MetadataRow
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMetadataRow build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMetadataRow(metadata);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_METADATA) != 0) attributes.add("metadata");
      return "Cannot build MetadataRow, some of required attributes are not set " + attributes;
    }
  }
}
