package zeenea.connector.sqlserver.services.ssas.client.model.multidimensional;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Metadata}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMetadata.builder()}.
 */
@Generated(from = "Metadata", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableMetadata
    implements Metadata {
  private final Server server;

  private ImmutableMetadata(Server server) {
    this.server = server;
  }

  /**
   * @return The value of the {@code server} attribute
   */
  @JsonProperty("server")
  @JacksonXmlProperty(localName = "Server")
  @Override
  public Server getServer() {
    return server;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Metadata#getServer() server} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for server
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMetadata withServer(Server value) {
    if (this.server == value) return this;
    Server newValue = Objects.requireNonNull(value, "server");
    return new ImmutableMetadata(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMetadata} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMetadata
        && equalTo(0, (ImmutableMetadata) another);
  }

  private boolean equalTo(int synthetic, ImmutableMetadata another) {
    return server.equals(another.server);
  }

  /**
   * Computes a hash code from attributes: {@code server}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + server.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Metadata} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Metadata{"
        + "server=" + server
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Metadata} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Metadata instance
   */
  public static ImmutableMetadata copyOf(Metadata instance) {
    if (instance instanceof ImmutableMetadata) {
      return (ImmutableMetadata) instance;
    }
    return ImmutableMetadata.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMetadata ImmutableMetadata}.
   * <pre>
   * ImmutableMetadata.builder()
   *    .server(zeenea.connector.sqlserver.services.ssas.client.model.multidimensional.Server) // required {@link Metadata#getServer() server}
   *    .build();
   * </pre>
   * @return A new ImmutableMetadata builder
   */
  public static ImmutableMetadata.Builder builder() {
    return new ImmutableMetadata.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMetadata ImmutableMetadata}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Metadata", generator = "Immutables")
  @JacksonXmlRootElement(namespace = "xars", localName = "METADATA")
  public static final class Builder {
    private static final long INIT_BIT_SERVER = 0x1L;
    private long initBits = 0x1L;

    private Server server;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Metadata} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Metadata instance) {
      Objects.requireNonNull(instance, "instance");
      this.server(instance.getServer());
      return this;
    }

    /**
     * Initializes the value for the {@link Metadata#getServer() server} attribute.
     * @param server The value for server 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("server")
    @JacksonXmlProperty(localName = "Server")
    public final Builder server(Server server) {
      this.server = Objects.requireNonNull(server, "server");
      initBits &= ~INIT_BIT_SERVER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMetadata ImmutableMetadata}.
     * @return An immutable instance of Metadata
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMetadata build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMetadata(server);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SERVER) != 0) attributes.add("server");
      return "Cannot build Metadata, some of required attributes are not set " + attributes;
    }
  }
}
