package zeenea.connector.sqlserver.services.ssas.client.model.multidimensional;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Cube}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCube.builder()}.
 */
@Generated(from = "Cube", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableCube
    implements Cube {
  private final @Nullable String id;
  private final @Nullable String name;
  private final @Nullable String createdDate;
  private final @Nullable String updatedDate;
  private final @Nullable String state;
  private final @Nullable List<Dimension> dimensions;
  private final @Nullable List<MeasureGroup> measureGroups;
  private final @Nullable Source source;

  private ImmutableCube(
      @Nullable String id,
      @Nullable String name,
      @Nullable String createdDate,
      @Nullable String updatedDate,
      @Nullable String state,
      @Nullable List<Dimension> dimensions,
      @Nullable List<MeasureGroup> measureGroups,
      @Nullable Source source) {
    this.id = id;
    this.name = name;
    this.createdDate = createdDate;
    this.updatedDate = updatedDate;
    this.state = state;
    this.dimensions = dimensions;
    this.measureGroups = measureGroups;
    this.source = source;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @JacksonXmlProperty(localName = "ID")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JacksonXmlProperty(localName = "Name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code createdDate} attribute
   */
  @JsonProperty("createdDate")
  @JacksonXmlProperty(localName = "CreatedTimestamp")
  @Override
  public @Nullable String getCreatedDate() {
    return createdDate;
  }

  /**
   * @return The value of the {@code updatedDate} attribute
   */
  @JsonProperty("updatedDate")
  @JacksonXmlProperty(localName = "LastSchemaUpdate")
  @Override
  public @Nullable String getUpdatedDate() {
    return updatedDate;
  }

  /**
   * @return The value of the {@code state} attribute
   */
  @JsonProperty("state")
  @JacksonXmlProperty(localName = "State")
  @Override
  public @Nullable String getState() {
    return state;
  }

  /**
   * @return The value of the {@code dimensions} attribute
   */
  @JsonProperty("dimensions")
  @JacksonXmlElementWrapper(useWrapping = true)
  @JacksonXmlProperty(localName = "Dimensions")
  @Override
  public @Nullable List<Dimension> getDimensions() {
    return dimensions;
  }

  /**
   * @return The value of the {@code measureGroups} attribute
   */
  @JsonProperty("measureGroups")
  @JacksonXmlElementWrapper(useWrapping = true)
  @JacksonXmlProperty(localName = "MeasureGroups")
  @Override
  public @Nullable List<MeasureGroup> getMeasureGroups() {
    return measureGroups;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @JsonProperty("source")
  @JacksonXmlProperty(localName = "Source")
  @Override
  public @Nullable Source getSource() {
    return source;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Cube#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCube withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableCube(
        value,
        this.name,
        this.createdDate,
        this.updatedDate,
        this.state,
        this.dimensions,
        this.measureGroups,
        this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Cube#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCube withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableCube(
        this.id,
        value,
        this.createdDate,
        this.updatedDate,
        this.state,
        this.dimensions,
        this.measureGroups,
        this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Cube#getCreatedDate() createdDate} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdDate (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCube withCreatedDate(@Nullable String value) {
    if (Objects.equals(this.createdDate, value)) return this;
    return new ImmutableCube(
        this.id,
        this.name,
        value,
        this.updatedDate,
        this.state,
        this.dimensions,
        this.measureGroups,
        this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Cube#getUpdatedDate() updatedDate} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedDate (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCube withUpdatedDate(@Nullable String value) {
    if (Objects.equals(this.updatedDate, value)) return this;
    return new ImmutableCube(
        this.id,
        this.name,
        this.createdDate,
        value,
        this.state,
        this.dimensions,
        this.measureGroups,
        this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Cube#getState() state} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for state (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCube withState(@Nullable String value) {
    if (Objects.equals(this.state, value)) return this;
    return new ImmutableCube(
        this.id,
        this.name,
        this.createdDate,
        this.updatedDate,
        value,
        this.dimensions,
        this.measureGroups,
        this.source);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Cube#getDimensions() dimensions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCube withDimensions(@Nullable Dimension... elements) {
    if (elements == null) {
      return new ImmutableCube(
          this.id,
          this.name,
          this.createdDate,
          this.updatedDate,
          this.state,
          null,
          this.measureGroups,
          this.source);
    }
    List<Dimension> newValue = List.of(elements);
    return new ImmutableCube(
        this.id,
        this.name,
        this.createdDate,
        this.updatedDate,
        this.state,
        newValue,
        this.measureGroups,
        this.source);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Cube#getDimensions() dimensions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dimensions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCube withDimensions(@Nullable Iterable<? extends Dimension> elements) {
    if (this.dimensions == elements) return this;
    @Nullable List<Dimension> newValue = elements == null ? null : elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Dimension>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableCube(
        this.id,
        this.name,
        this.createdDate,
        this.updatedDate,
        this.state,
        newValue,
        this.measureGroups,
        this.source);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Cube#getMeasureGroups() measureGroups}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCube withMeasureGroups(@Nullable MeasureGroup... elements) {
    if (elements == null) {
      return new ImmutableCube(
          this.id,
          this.name,
          this.createdDate,
          this.updatedDate,
          this.state,
          this.dimensions,
          null,
          this.source);
    }
    List<MeasureGroup> newValue = List.of(elements);
    return new ImmutableCube(
        this.id,
        this.name,
        this.createdDate,
        this.updatedDate,
        this.state,
        this.dimensions,
        newValue,
        this.source);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Cube#getMeasureGroups() measureGroups}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of measureGroups elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCube withMeasureGroups(@Nullable Iterable<? extends MeasureGroup> elements) {
    if (this.measureGroups == elements) return this;
    @Nullable List<MeasureGroup> newValue = elements == null ? null : elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends MeasureGroup>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableCube(
        this.id,
        this.name,
        this.createdDate,
        this.updatedDate,
        this.state,
        this.dimensions,
        newValue,
        this.source);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Cube#getSource() source} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCube withSource(@Nullable Source value) {
    if (this.source == value) return this;
    return new ImmutableCube(
        this.id,
        this.name,
        this.createdDate,
        this.updatedDate,
        this.state,
        this.dimensions,
        this.measureGroups,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCube} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCube
        && equalTo(0, (ImmutableCube) another);
  }

  private boolean equalTo(int synthetic, ImmutableCube another) {
    return Objects.equals(id, another.id)
        && Objects.equals(name, another.name)
        && Objects.equals(createdDate, another.createdDate)
        && Objects.equals(updatedDate, another.updatedDate)
        && Objects.equals(state, another.state)
        && Objects.equals(dimensions, another.dimensions)
        && Objects.equals(measureGroups, another.measureGroups)
        && Objects.equals(source, another.source);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code createdDate}, {@code updatedDate}, {@code state}, {@code dimensions}, {@code measureGroups}, {@code source}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(createdDate);
    h += (h << 5) + Objects.hashCode(updatedDate);
    h += (h << 5) + Objects.hashCode(state);
    h += (h << 5) + Objects.hashCode(dimensions);
    h += (h << 5) + Objects.hashCode(measureGroups);
    h += (h << 5) + Objects.hashCode(source);
    return h;
  }

  /**
   * Prints the immutable value {@code Cube} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Cube{"
        + "id=" + id
        + ", name=" + name
        + ", createdDate=" + createdDate
        + ", updatedDate=" + updatedDate
        + ", state=" + state
        + ", dimensions=" + dimensions
        + ", measureGroups=" + measureGroups
        + ", source=" + source
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Cube", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements Cube {
    String id;
    String name;
    String createdDate;
    String updatedDate;
    String state;
    List<Dimension> dimensions = null;
    List<MeasureGroup> measureGroups = null;
    Source source;
    @JsonProperty("id")
    @JacksonXmlProperty(localName = "ID")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("name")
    @JacksonXmlProperty(localName = "Name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("createdDate")
    @JacksonXmlProperty(localName = "CreatedTimestamp")
    public void setCreatedDate(@Nullable String createdDate) {
      this.createdDate = createdDate;
    }
    @JsonProperty("updatedDate")
    @JacksonXmlProperty(localName = "LastSchemaUpdate")
    public void setUpdatedDate(@Nullable String updatedDate) {
      this.updatedDate = updatedDate;
    }
    @JsonProperty("state")
    @JacksonXmlProperty(localName = "State")
    public void setState(@Nullable String state) {
      this.state = state;
    }
    @JsonProperty("dimensions")
    @JacksonXmlElementWrapper(useWrapping = true)
    @JacksonXmlProperty(localName = "Dimensions")
    public void setDimensions(@Nullable List<Dimension> dimensions) {
      this.dimensions = dimensions;
    }
    @JsonProperty("measureGroups")
    @JacksonXmlElementWrapper(useWrapping = true)
    @JacksonXmlProperty(localName = "MeasureGroups")
    public void setMeasureGroups(@Nullable List<MeasureGroup> measureGroups) {
      this.measureGroups = measureGroups;
    }
    @JsonProperty("source")
    @JacksonXmlProperty(localName = "Source")
    public void setSource(@Nullable Source source) {
      this.source = source;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getCreatedDate() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedDate() { throw new UnsupportedOperationException(); }
    @Override
    public String getState() { throw new UnsupportedOperationException(); }
    @Override
    public List<Dimension> getDimensions() { throw new UnsupportedOperationException(); }
    @Override
    public List<MeasureGroup> getMeasureGroups() { throw new UnsupportedOperationException(); }
    @Override
    public Source getSource() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCube fromJson(Json json) {
    ImmutableCube.Builder builder = ImmutableCube.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.createdDate != null) {
      builder.createdDate(json.createdDate);
    }
    if (json.updatedDate != null) {
      builder.updatedDate(json.updatedDate);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.dimensions != null) {
      builder.addAllDimensions(json.dimensions);
    }
    if (json.measureGroups != null) {
      builder.addAllMeasureGroups(json.measureGroups);
    }
    if (json.source != null) {
      builder.source(json.source);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Cube} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Cube instance
   */
  public static ImmutableCube copyOf(Cube instance) {
    if (instance instanceof ImmutableCube) {
      return (ImmutableCube) instance;
    }
    return ImmutableCube.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCube ImmutableCube}.
   * <pre>
   * ImmutableCube.builder()
   *    .id(String | null) // nullable {@link Cube#getId() id}
   *    .name(String | null) // nullable {@link Cube#getName() name}
   *    .createdDate(String | null) // nullable {@link Cube#getCreatedDate() createdDate}
   *    .updatedDate(String | null) // nullable {@link Cube#getUpdatedDate() updatedDate}
   *    .state(String | null) // nullable {@link Cube#getState() state}
   *    .dimensions(List&amp;lt;zeenea.connector.sqlserver.services.ssas.client.model.multidimensional.Dimension&amp;gt; | null) // nullable {@link Cube#getDimensions() dimensions}
   *    .measureGroups(List&amp;lt;zeenea.connector.sqlserver.services.ssas.client.model.multidimensional.MeasureGroup&amp;gt; | null) // nullable {@link Cube#getMeasureGroups() measureGroups}
   *    .source(zeenea.connector.sqlserver.services.ssas.client.model.multidimensional.Source | null) // nullable {@link Cube#getSource() source}
   *    .build();
   * </pre>
   * @return A new ImmutableCube builder
   */
  public static ImmutableCube.Builder builder() {
    return new ImmutableCube.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCube ImmutableCube}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Cube", generator = "Immutables")
  public static final class Builder {
    private String id;
    private String name;
    private String createdDate;
    private String updatedDate;
    private String state;
    private List<Dimension> dimensions = null;
    private List<MeasureGroup> measureGroups = null;
    private Source source;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Cube} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Cube instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable String createdDateValue = instance.getCreatedDate();
      if (createdDateValue != null) {
        createdDate(createdDateValue);
      }
      @Nullable String updatedDateValue = instance.getUpdatedDate();
      if (updatedDateValue != null) {
        updatedDate(updatedDateValue);
      }
      @Nullable String stateValue = instance.getState();
      if (stateValue != null) {
        state(stateValue);
      }
      @Nullable List<Dimension> dimensionsValue = instance.getDimensions();
      if (dimensionsValue != null) {
        addAllDimensions(dimensionsValue);
      }
      @Nullable List<MeasureGroup> measureGroupsValue = instance.getMeasureGroups();
      if (measureGroupsValue != null) {
        addAllMeasureGroups(measureGroupsValue);
      }
      @Nullable Source sourceValue = instance.getSource();
      if (sourceValue != null) {
        source(sourceValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Cube#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    @JacksonXmlProperty(localName = "ID")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Cube#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    @JacksonXmlProperty(localName = "Name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link Cube#getCreatedDate() createdDate} attribute.
     * @param createdDate The value for createdDate (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("createdDate")
    @JacksonXmlProperty(localName = "CreatedTimestamp")
    public final Builder createdDate(@Nullable String createdDate) {
      this.createdDate = createdDate;
      return this;
    }

    /**
     * Initializes the value for the {@link Cube#getUpdatedDate() updatedDate} attribute.
     * @param updatedDate The value for updatedDate (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updatedDate")
    @JacksonXmlProperty(localName = "LastSchemaUpdate")
    public final Builder updatedDate(@Nullable String updatedDate) {
      this.updatedDate = updatedDate;
      return this;
    }

    /**
     * Initializes the value for the {@link Cube#getState() state} attribute.
     * @param state The value for state (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("state")
    @JacksonXmlProperty(localName = "State")
    public final Builder state(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Adds one element to {@link Cube#getDimensions() dimensions} list.
     * @param element A dimensions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDimensions(Dimension element) {
      if (this.dimensions == null) {
        this.dimensions = new ArrayList<Dimension>();
      }
      this.dimensions.add(Objects.requireNonNull(element, "dimensions element"));
      return this;
    }

    /**
     * Adds elements to {@link Cube#getDimensions() dimensions} list.
     * @param elements An array of dimensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDimensions(Dimension... elements) {
      if (this.dimensions == null) {
        this.dimensions = new ArrayList<Dimension>();
      }
      for (Dimension element : elements) {
        this.dimensions.add(Objects.requireNonNull(element, "dimensions element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Cube#getDimensions() dimensions} list.
     * @param elements An iterable of dimensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dimensions")
    @JacksonXmlElementWrapper(useWrapping = true)
    @JacksonXmlProperty(localName = "Dimensions")
    public final Builder dimensions(@Nullable Iterable<? extends Dimension> elements) {
      if (elements == null) {
        this.dimensions = null;
        return this;
      }
      this.dimensions = new ArrayList<Dimension>();
      return addAllDimensions(elements);
    }

    /**
     * Adds elements to {@link Cube#getDimensions() dimensions} list.
     * @param elements An iterable of dimensions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDimensions(Iterable<? extends Dimension> elements) {
      Objects.requireNonNull(elements, "dimensions element");
      if (this.dimensions == null) {
        this.dimensions = new ArrayList<Dimension>();
      }
      for (Dimension element : elements) {
        this.dimensions.add(Objects.requireNonNull(element, "dimensions element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link Cube#getMeasureGroups() measureGroups} list.
     * @param element A measureGroups element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMeasureGroups(MeasureGroup element) {
      if (this.measureGroups == null) {
        this.measureGroups = new ArrayList<MeasureGroup>();
      }
      this.measureGroups.add(Objects.requireNonNull(element, "measureGroups element"));
      return this;
    }

    /**
     * Adds elements to {@link Cube#getMeasureGroups() measureGroups} list.
     * @param elements An array of measureGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMeasureGroups(MeasureGroup... elements) {
      if (this.measureGroups == null) {
        this.measureGroups = new ArrayList<MeasureGroup>();
      }
      for (MeasureGroup element : elements) {
        this.measureGroups.add(Objects.requireNonNull(element, "measureGroups element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Cube#getMeasureGroups() measureGroups} list.
     * @param elements An iterable of measureGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("measureGroups")
    @JacksonXmlElementWrapper(useWrapping = true)
    @JacksonXmlProperty(localName = "MeasureGroups")
    public final Builder measureGroups(@Nullable Iterable<? extends MeasureGroup> elements) {
      if (elements == null) {
        this.measureGroups = null;
        return this;
      }
      this.measureGroups = new ArrayList<MeasureGroup>();
      return addAllMeasureGroups(elements);
    }

    /**
     * Adds elements to {@link Cube#getMeasureGroups() measureGroups} list.
     * @param elements An iterable of measureGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMeasureGroups(Iterable<? extends MeasureGroup> elements) {
      Objects.requireNonNull(elements, "measureGroups element");
      if (this.measureGroups == null) {
        this.measureGroups = new ArrayList<MeasureGroup>();
      }
      for (MeasureGroup element : elements) {
        this.measureGroups.add(Objects.requireNonNull(element, "measureGroups element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Cube#getSource() source} attribute.
     * @param source The value for source (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("source")
    @JacksonXmlProperty(localName = "Source")
    public final Builder source(@Nullable Source source) {
      this.source = source;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCube ImmutableCube}.
     * @return An immutable instance of Cube
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCube build() {
      return new ImmutableCube(
          id,
          name,
          createdDate,
          updatedDate,
          state,
          dimensions == null ? null : List.copyOf(dimensions),
          measureGroups == null ? null : List.copyOf(measureGroups),
          source);
    }
  }
}
