package zeenea.connector.sqlserver.services.ssas.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SoapRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSoapRequest.builder()}.
 */
@Generated(from = "SoapRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableSoapRequest
    implements SoapRequest {
  private final RequestBody requestBody;

  private ImmutableSoapRequest(RequestBody requestBody) {
    this.requestBody = requestBody;
  }

  /**
   * @return The value of the {@code requestBody} attribute
   */
  @JsonProperty("requestBody")
  @JacksonXmlProperty(localName = "SOAP-ENV:Body")
  @Override
  public RequestBody getRequestBody() {
    return requestBody;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SoapRequest#getRequestBody() requestBody} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for requestBody
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSoapRequest withRequestBody(RequestBody value) {
    if (this.requestBody == value) return this;
    RequestBody newValue = Objects.requireNonNull(value, "requestBody");
    return new ImmutableSoapRequest(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSoapRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSoapRequest
        && equalTo(0, (ImmutableSoapRequest) another);
  }

  private boolean equalTo(int synthetic, ImmutableSoapRequest another) {
    return requestBody.equals(another.requestBody);
  }

  /**
   * Computes a hash code from attributes: {@code requestBody}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + requestBody.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SoapRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SoapRequest{"
        + "requestBody=" + requestBody
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link SoapRequest} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SoapRequest instance
   */
  public static ImmutableSoapRequest copyOf(SoapRequest instance) {
    if (instance instanceof ImmutableSoapRequest) {
      return (ImmutableSoapRequest) instance;
    }
    return ImmutableSoapRequest.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSoapRequest ImmutableSoapRequest}.
   * <pre>
   * ImmutableSoapRequest.builder()
   *    .requestBody(zeenea.connector.sqlserver.services.ssas.client.model.RequestBody) // required {@link SoapRequest#getRequestBody() requestBody}
   *    .build();
   * </pre>
   * @return A new ImmutableSoapRequest builder
   */
  public static ImmutableSoapRequest.Builder builder() {
    return new ImmutableSoapRequest.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSoapRequest ImmutableSoapRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SoapRequest", generator = "Immutables")
  @JacksonXmlRootElement(localName = "SOAP-ENV:Envelope")
  public static final class Builder {
    private static final long INIT_BIT_REQUEST_BODY = 0x1L;
    private long initBits = 0x1L;

    private RequestBody requestBody;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SoapRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SoapRequest instance) {
      Objects.requireNonNull(instance, "instance");
      this.requestBody(instance.getRequestBody());
      return this;
    }

    /**
     * Initializes the value for the {@link SoapRequest#getRequestBody() requestBody} attribute.
     * @param requestBody The value for requestBody 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("requestBody")
    @JacksonXmlProperty(localName = "SOAP-ENV:Body")
    public final Builder requestBody(RequestBody requestBody) {
      this.requestBody = Objects.requireNonNull(requestBody, "requestBody");
      initBits &= ~INIT_BIT_REQUEST_BODY;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSoapRequest ImmutableSoapRequest}.
     * @return An immutable instance of SoapRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSoapRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSoapRequest(requestBody);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REQUEST_BODY) != 0) attributes.add("requestBody");
      return "Cannot build SoapRequest, some of required attributes are not set " + attributes;
    }
  }
}
