package zeenea.connector.sqlserver.services.ssas.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link RestrictionList}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRestrictionList.builder()}.
 */
@Generated(from = "RestrictionList", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableRestrictionList
    implements RestrictionList {
  private final @Nullable String catalogName;
  private final @Nullable String databaseName;
  private final @Nullable String name;
  private final @Nullable String id;
  private final @Nullable String tableId;
  private final @Nullable String fromTableId;
  private final @Nullable Boolean active;

  private ImmutableRestrictionList(
      @Nullable String catalogName,
      @Nullable String databaseName,
      @Nullable String name,
      @Nullable String id,
      @Nullable String tableId,
      @Nullable String fromTableId,
      @Nullable Boolean active) {
    this.catalogName = catalogName;
    this.databaseName = databaseName;
    this.name = name;
    this.id = id;
    this.tableId = tableId;
    this.fromTableId = fromTableId;
    this.active = active;
  }

  /**
   * @return The value of the {@code catalogName} attribute
   */
  @JsonProperty("catalogName")
  @JacksonXmlProperty(localName = "CATALOG_NAME")
  @Override
  public @Nullable String getCatalogName() {
    return catalogName;
  }

  /**
   * @return The value of the {@code databaseName} attribute
   */
  @JsonProperty("databaseName")
  @JacksonXmlProperty(localName = "DatabaseName")
  @Override
  public @Nullable String getDatabaseName() {
    return databaseName;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @JacksonXmlProperty(localName = "Name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @JacksonXmlProperty(localName = "ID")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code tableId} attribute
   */
  @JsonProperty("tableId")
  @JacksonXmlProperty(localName = "TableID")
  @Override
  public @Nullable String getTableId() {
    return tableId;
  }

  /**
   * @return The value of the {@code fromTableId} attribute
   */
  @JsonProperty("fromTableId")
  @JacksonXmlProperty(localName = "FromTableID")
  @Override
  public @Nullable String getFromTableId() {
    return fromTableId;
  }

  /**
   * @return The value of the {@code active} attribute
   */
  @JsonProperty("active")
  @JacksonXmlProperty(localName = "IsActive")
  @Override
  public @Nullable Boolean isActive() {
    return active;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RestrictionList#getCatalogName() catalogName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for catalogName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRestrictionList withCatalogName(@Nullable String value) {
    if (Objects.equals(this.catalogName, value)) return this;
    return new ImmutableRestrictionList(value, this.databaseName, this.name, this.id, this.tableId, this.fromTableId, this.active);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RestrictionList#getDatabaseName() databaseName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for databaseName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRestrictionList withDatabaseName(@Nullable String value) {
    if (Objects.equals(this.databaseName, value)) return this;
    return new ImmutableRestrictionList(this.catalogName, value, this.name, this.id, this.tableId, this.fromTableId, this.active);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RestrictionList#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRestrictionList withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableRestrictionList(
        this.catalogName,
        this.databaseName,
        value,
        this.id,
        this.tableId,
        this.fromTableId,
        this.active);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RestrictionList#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRestrictionList withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableRestrictionList(
        this.catalogName,
        this.databaseName,
        this.name,
        value,
        this.tableId,
        this.fromTableId,
        this.active);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RestrictionList#getTableId() tableId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tableId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRestrictionList withTableId(@Nullable String value) {
    if (Objects.equals(this.tableId, value)) return this;
    return new ImmutableRestrictionList(this.catalogName, this.databaseName, this.name, this.id, value, this.fromTableId, this.active);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RestrictionList#getFromTableId() fromTableId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fromTableId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRestrictionList withFromTableId(@Nullable String value) {
    if (Objects.equals(this.fromTableId, value)) return this;
    return new ImmutableRestrictionList(this.catalogName, this.databaseName, this.name, this.id, this.tableId, value, this.active);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RestrictionList#isActive() active} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for active (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRestrictionList withActive(@Nullable Boolean value) {
    if (Objects.equals(this.active, value)) return this;
    return new ImmutableRestrictionList(this.catalogName, this.databaseName, this.name, this.id, this.tableId, this.fromTableId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRestrictionList} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRestrictionList
        && equalTo(0, (ImmutableRestrictionList) another);
  }

  private boolean equalTo(int synthetic, ImmutableRestrictionList another) {
    return Objects.equals(catalogName, another.catalogName)
        && Objects.equals(databaseName, another.databaseName)
        && Objects.equals(name, another.name)
        && Objects.equals(id, another.id)
        && Objects.equals(tableId, another.tableId)
        && Objects.equals(fromTableId, another.fromTableId)
        && Objects.equals(active, another.active);
  }

  /**
   * Computes a hash code from attributes: {@code catalogName}, {@code databaseName}, {@code name}, {@code id}, {@code tableId}, {@code fromTableId}, {@code active}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(catalogName);
    h += (h << 5) + Objects.hashCode(databaseName);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(tableId);
    h += (h << 5) + Objects.hashCode(fromTableId);
    h += (h << 5) + Objects.hashCode(active);
    return h;
  }

  /**
   * Prints the immutable value {@code RestrictionList} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RestrictionList{"
        + "catalogName=" + catalogName
        + ", databaseName=" + databaseName
        + ", name=" + name
        + ", id=" + id
        + ", tableId=" + tableId
        + ", fromTableId=" + fromTableId
        + ", active=" + active
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link RestrictionList} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RestrictionList instance
   */
  public static ImmutableRestrictionList copyOf(RestrictionList instance) {
    if (instance instanceof ImmutableRestrictionList) {
      return (ImmutableRestrictionList) instance;
    }
    return ImmutableRestrictionList.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRestrictionList ImmutableRestrictionList}.
   * <pre>
   * ImmutableRestrictionList.builder()
   *    .catalogName(String | null) // nullable {@link RestrictionList#getCatalogName() catalogName}
   *    .databaseName(String | null) // nullable {@link RestrictionList#getDatabaseName() databaseName}
   *    .name(String | null) // nullable {@link RestrictionList#getName() name}
   *    .id(String | null) // nullable {@link RestrictionList#getId() id}
   *    .tableId(String | null) // nullable {@link RestrictionList#getTableId() tableId}
   *    .fromTableId(String | null) // nullable {@link RestrictionList#getFromTableId() fromTableId}
   *    .active(Boolean | null) // nullable {@link RestrictionList#isActive() active}
   *    .build();
   * </pre>
   * @return A new ImmutableRestrictionList builder
   */
  public static ImmutableRestrictionList.Builder builder() {
    return new ImmutableRestrictionList.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRestrictionList ImmutableRestrictionList}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RestrictionList", generator = "Immutables")
  @JacksonXmlRootElement(localName = "RestrictionList")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  public static final class Builder {
    private String catalogName;
    private String databaseName;
    private String name;
    private String id;
    private String tableId;
    private String fromTableId;
    private Boolean active;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RestrictionList} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RestrictionList instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String catalogNameValue = instance.getCatalogName();
      if (catalogNameValue != null) {
        catalogName(catalogNameValue);
      }
      @Nullable String databaseNameValue = instance.getDatabaseName();
      if (databaseNameValue != null) {
        databaseName(databaseNameValue);
      }
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      @Nullable String tableIdValue = instance.getTableId();
      if (tableIdValue != null) {
        tableId(tableIdValue);
      }
      @Nullable String fromTableIdValue = instance.getFromTableId();
      if (fromTableIdValue != null) {
        fromTableId(fromTableIdValue);
      }
      @Nullable Boolean activeValue = instance.isActive();
      if (activeValue != null) {
        active(activeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link RestrictionList#getCatalogName() catalogName} attribute.
     * @param catalogName The value for catalogName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("catalogName")
    @JacksonXmlProperty(localName = "CATALOG_NAME")
    public final Builder catalogName(@Nullable String catalogName) {
      this.catalogName = catalogName;
      return this;
    }

    /**
     * Initializes the value for the {@link RestrictionList#getDatabaseName() databaseName} attribute.
     * @param databaseName The value for databaseName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("databaseName")
    @JacksonXmlProperty(localName = "DatabaseName")
    public final Builder databaseName(@Nullable String databaseName) {
      this.databaseName = databaseName;
      return this;
    }

    /**
     * Initializes the value for the {@link RestrictionList#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    @JacksonXmlProperty(localName = "Name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link RestrictionList#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    @JacksonXmlProperty(localName = "ID")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link RestrictionList#getTableId() tableId} attribute.
     * @param tableId The value for tableId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tableId")
    @JacksonXmlProperty(localName = "TableID")
    public final Builder tableId(@Nullable String tableId) {
      this.tableId = tableId;
      return this;
    }

    /**
     * Initializes the value for the {@link RestrictionList#getFromTableId() fromTableId} attribute.
     * @param fromTableId The value for fromTableId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("fromTableId")
    @JacksonXmlProperty(localName = "FromTableID")
    public final Builder fromTableId(@Nullable String fromTableId) {
      this.fromTableId = fromTableId;
      return this;
    }

    /**
     * Initializes the value for the {@link RestrictionList#isActive() active} attribute.
     * @param active The value for active (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("active")
    @JacksonXmlProperty(localName = "IsActive")
    public final Builder active(@Nullable Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRestrictionList ImmutableRestrictionList}.
     * @return An immutable instance of RestrictionList
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRestrictionList build() {
      return new ImmutableRestrictionList(catalogName, databaseName, name, id, tableId, fromTableId, active);
    }
  }
}
