package zeenea.connector.sqlserver.services.ssas.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.Objects;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link ResponseBody}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableResponseBody.builder()}.
 */
@Generated(from = "ResponseBody", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableResponseBody<T>
    implements ResponseBody<T> {
  private final @Nullable DiscoverResponse<T> discoverResponse;
  private final @Nullable Fault fault;

  private ImmutableResponseBody(
      @Nullable DiscoverResponse<T> discoverResponse,
      @Nullable Fault fault) {
    this.discoverResponse = discoverResponse;
    this.fault = fault;
  }

  /**
   * @return The value of the {@code discoverResponse} attribute
   */
  @JsonProperty("discoverResponse")
  @JacksonXmlProperty(localName = "DiscoverResponse")
  @Override
  public @Nullable DiscoverResponse<T> getDiscoverResponse() {
    return discoverResponse;
  }

  /**
   * @return The value of the {@code fault} attribute
   */
  @JsonProperty("fault")
  @JacksonXmlProperty(namespace = "soap", localName = "Fault")
  @Override
  public @Nullable Fault getFault() {
    return fault;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ResponseBody#getDiscoverResponse() discoverResponse} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for discoverResponse (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableResponseBody<T> withDiscoverResponse(@Nullable DiscoverResponse<T> value) {
    if (this.discoverResponse == value) return this;
    return new ImmutableResponseBody<>(value, this.fault);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ResponseBody#getFault() fault} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fault (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableResponseBody<T> withFault(@Nullable Fault value) {
    if (this.fault == value) return this;
    return new ImmutableResponseBody<>(this.discoverResponse, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableResponseBody} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableResponseBody<?>
        && equalTo(0, (ImmutableResponseBody<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableResponseBody<?> another) {
    return Objects.equals(discoverResponse, another.discoverResponse)
        && Objects.equals(fault, another.fault);
  }

  /**
   * Computes a hash code from attributes: {@code discoverResponse}, {@code fault}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(discoverResponse);
    h += (h << 5) + Objects.hashCode(fault);
    return h;
  }

  /**
   * Prints the immutable value {@code ResponseBody} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ResponseBody{"
        + "discoverResponse=" + discoverResponse
        + ", fault=" + fault
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ResponseBody} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable ResponseBody instance
   */
  public static <T> ImmutableResponseBody<T> copyOf(ResponseBody<T> instance) {
    if (instance instanceof ImmutableResponseBody<?>) {
      return (ImmutableResponseBody<T>) instance;
    }
    return ImmutableResponseBody.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableResponseBody ImmutableResponseBody}.
   * <pre>
   * ImmutableResponseBody.&amp;lt;T&amp;gt;builder()
   *    .discoverResponse(zeenea.connector.sqlserver.services.ssas.client.model.DiscoverResponse&amp;lt;T&amp;gt; | null) // nullable {@link ResponseBody#getDiscoverResponse() discoverResponse}
   *    .fault(zeenea.connector.sqlserver.services.ssas.client.model.Fault | null) // nullable {@link ResponseBody#getFault() fault}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableResponseBody builder
   */
  public static <T> ImmutableResponseBody.Builder<T> builder() {
    return new ImmutableResponseBody.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableResponseBody ImmutableResponseBody}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ResponseBody", generator = "Immutables")
  @JacksonXmlRootElement(namespace = "soap", localName = "Body")
  public static final class Builder<T> {
    private DiscoverResponse<T> discoverResponse;
    private Fault fault;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ResponseBody} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(ResponseBody<T> instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable DiscoverResponse<T> discoverResponseValue = instance.getDiscoverResponse();
      if (discoverResponseValue != null) {
        discoverResponse(discoverResponseValue);
      }
      @Nullable Fault faultValue = instance.getFault();
      if (faultValue != null) {
        fault(faultValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ResponseBody#getDiscoverResponse() discoverResponse} attribute.
     * @param discoverResponse The value for discoverResponse (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("discoverResponse")
    @JacksonXmlProperty(localName = "DiscoverResponse")
    public final Builder<T> discoverResponse(@Nullable DiscoverResponse<T> discoverResponse) {
      this.discoverResponse = discoverResponse;
      return this;
    }

    /**
     * Initializes the value for the {@link ResponseBody#getFault() fault} attribute.
     * @param fault The value for fault (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("fault")
    @JacksonXmlProperty(namespace = "soap", localName = "Fault")
    public final Builder<T> fault(@Nullable Fault fault) {
      this.fault = fault;
      return this;
    }

    /**
     * Builds a new {@link ImmutableResponseBody ImmutableResponseBody}.
     * @return An immutable instance of ResponseBody
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableResponseBody<T> build() {
      return new ImmutableResponseBody<>(discoverResponse, fault);
    }
  }
}
