package zeenea.connector.sqlserver.services.ssas.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RequestBody}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRequestBody.builder()}.
 */
@Generated(from = "RequestBody", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableRequestBody
    implements RequestBody {
  private final Discover discover;

  private ImmutableRequestBody(Discover discover) {
    this.discover = discover;
  }

  /**
   * @return The value of the {@code discover} attribute
   */
  @JsonProperty("discover")
  @JacksonXmlProperty(localName = "Discover")
  @Override
  public Discover getDiscover() {
    return discover;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RequestBody#getDiscover() discover} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for discover
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRequestBody withDiscover(Discover value) {
    if (this.discover == value) return this;
    Discover newValue = Objects.requireNonNull(value, "discover");
    return new ImmutableRequestBody(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRequestBody} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRequestBody
        && equalTo(0, (ImmutableRequestBody) another);
  }

  private boolean equalTo(int synthetic, ImmutableRequestBody another) {
    return discover.equals(another.discover);
  }

  /**
   * Computes a hash code from attributes: {@code discover}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + discover.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RequestBody} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RequestBody{"
        + "discover=" + discover
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link RequestBody} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RequestBody instance
   */
  public static ImmutableRequestBody copyOf(RequestBody instance) {
    if (instance instanceof ImmutableRequestBody) {
      return (ImmutableRequestBody) instance;
    }
    return ImmutableRequestBody.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRequestBody ImmutableRequestBody}.
   * <pre>
   * ImmutableRequestBody.builder()
   *    .discover(zeenea.connector.sqlserver.services.ssas.client.model.Discover) // required {@link RequestBody#getDiscover() discover}
   *    .build();
   * </pre>
   * @return A new ImmutableRequestBody builder
   */
  public static ImmutableRequestBody.Builder builder() {
    return new ImmutableRequestBody.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRequestBody ImmutableRequestBody}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RequestBody", generator = "Immutables")
  @JacksonXmlRootElement(localName = "SOAP-ENV:Body")
  public static final class Builder {
    private static final long INIT_BIT_DISCOVER = 0x1L;
    private long initBits = 0x1L;

    private Discover discover;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RequestBody} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RequestBody instance) {
      Objects.requireNonNull(instance, "instance");
      this.discover(instance.getDiscover());
      return this;
    }

    /**
     * Initializes the value for the {@link RequestBody#getDiscover() discover} attribute.
     * @param discover The value for discover 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("discover")
    @JacksonXmlProperty(localName = "Discover")
    public final Builder discover(Discover discover) {
      this.discover = Objects.requireNonNull(discover, "discover");
      initBits &= ~INIT_BIT_DISCOVER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRequestBody ImmutableRequestBody}.
     * @return An immutable instance of RequestBody
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRequestBody build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRequestBody(discover);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DISCOVER) != 0) attributes.add("discover");
      return "Cannot build RequestBody, some of required attributes are not set " + attributes;
    }
  }
}
