package zeenea.connector.sqlserver.services.ssas.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Fault}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFault.builder()}.
 */
@Generated(from = "Fault", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableFault implements Fault {
  private final @Nullable String faultCode;
  private final @Nullable String faultString;
  private final @Nullable List<Error> errors;

  private ImmutableFault(
      @Nullable String faultCode,
      @Nullable String faultString,
      @Nullable List<Error> errors) {
    this.faultCode = faultCode;
    this.faultString = faultString;
    this.errors = errors;
  }

  /**
   * @return The value of the {@code faultCode} attribute
   */
  @JsonProperty("faultCode")
  @JacksonXmlProperty(localName = "faultcode")
  @Override
  public @Nullable String getFaultCode() {
    return faultCode;
  }

  /**
   * @return The value of the {@code faultString} attribute
   */
  @JsonProperty("faultString")
  @JacksonXmlProperty(localName = "faultstring")
  @Override
  public @Nullable String getFaultString() {
    return faultString;
  }

  /**
   * @return The value of the {@code errors} attribute
   */
  @JsonProperty("errors")
  @JacksonXmlElementWrapper(localName = "detail")
  @Override
  public @Nullable List<Error> getErrors() {
    return errors;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Fault#getFaultCode() faultCode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for faultCode (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFault withFaultCode(@Nullable String value) {
    if (Objects.equals(this.faultCode, value)) return this;
    return new ImmutableFault(value, this.faultString, this.errors);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Fault#getFaultString() faultString} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for faultString (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFault withFaultString(@Nullable String value) {
    if (Objects.equals(this.faultString, value)) return this;
    return new ImmutableFault(this.faultCode, value, this.errors);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Fault#getErrors() errors}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFault withErrors(@Nullable Error... elements) {
    if (elements == null) {
      return new ImmutableFault(this.faultCode, this.faultString, null);
    }
    List<Error> newValue = List.of(elements);
    return new ImmutableFault(this.faultCode, this.faultString, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Fault#getErrors() errors}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of errors elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFault withErrors(@Nullable Iterable<? extends Error> elements) {
    if (this.errors == elements) return this;
    @Nullable List<Error> newValue = elements == null ? null : elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Error>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableFault(this.faultCode, this.faultString, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFault} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFault
        && equalTo(0, (ImmutableFault) another);
  }

  private boolean equalTo(int synthetic, ImmutableFault another) {
    return Objects.equals(faultCode, another.faultCode)
        && Objects.equals(faultString, another.faultString)
        && Objects.equals(errors, another.errors);
  }

  /**
   * Computes a hash code from attributes: {@code faultCode}, {@code faultString}, {@code errors}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(faultCode);
    h += (h << 5) + Objects.hashCode(faultString);
    h += (h << 5) + Objects.hashCode(errors);
    return h;
  }

  /**
   * Prints the immutable value {@code Fault} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Fault{"
        + "faultCode=" + faultCode
        + ", faultString=" + faultString
        + ", errors=" + errors
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Fault} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Fault instance
   */
  public static ImmutableFault copyOf(Fault instance) {
    if (instance instanceof ImmutableFault) {
      return (ImmutableFault) instance;
    }
    return ImmutableFault.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFault ImmutableFault}.
   * <pre>
   * ImmutableFault.builder()
   *    .faultCode(String | null) // nullable {@link Fault#getFaultCode() faultCode}
   *    .faultString(String | null) // nullable {@link Fault#getFaultString() faultString}
   *    .errors(List&amp;lt;zeenea.connector.sqlserver.services.ssas.client.model.Error&amp;gt; | null) // nullable {@link Fault#getErrors() errors}
   *    .build();
   * </pre>
   * @return A new ImmutableFault builder
   */
  public static ImmutableFault.Builder builder() {
    return new ImmutableFault.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFault ImmutableFault}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Fault", generator = "Immutables")
  @JacksonXmlRootElement(namespace = "soap", localName = "Fault")
  public static final class Builder {
    private String faultCode;
    private String faultString;
    private List<Error> errors = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Fault} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Fault instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String faultCodeValue = instance.getFaultCode();
      if (faultCodeValue != null) {
        faultCode(faultCodeValue);
      }
      @Nullable String faultStringValue = instance.getFaultString();
      if (faultStringValue != null) {
        faultString(faultStringValue);
      }
      @Nullable List<Error> errorsValue = instance.getErrors();
      if (errorsValue != null) {
        addAllErrors(errorsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Fault#getFaultCode() faultCode} attribute.
     * @param faultCode The value for faultCode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("faultCode")
    @JacksonXmlProperty(localName = "faultcode")
    public final Builder faultCode(@Nullable String faultCode) {
      this.faultCode = faultCode;
      return this;
    }

    /**
     * Initializes the value for the {@link Fault#getFaultString() faultString} attribute.
     * @param faultString The value for faultString (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("faultString")
    @JacksonXmlProperty(localName = "faultstring")
    public final Builder faultString(@Nullable String faultString) {
      this.faultString = faultString;
      return this;
    }

    /**
     * Adds one element to {@link Fault#getErrors() errors} list.
     * @param element A errors element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addErrors(Error element) {
      if (this.errors == null) {
        this.errors = new ArrayList<Error>();
      }
      this.errors.add(Objects.requireNonNull(element, "errors element"));
      return this;
    }

    /**
     * Adds elements to {@link Fault#getErrors() errors} list.
     * @param elements An array of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addErrors(Error... elements) {
      if (this.errors == null) {
        this.errors = new ArrayList<Error>();
      }
      for (Error element : elements) {
        this.errors.add(Objects.requireNonNull(element, "errors element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Fault#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("errors")
    @JacksonXmlElementWrapper(localName = "detail")
    public final Builder errors(@Nullable Iterable<? extends Error> elements) {
      if (elements == null) {
        this.errors = null;
        return this;
      }
      this.errors = new ArrayList<Error>();
      return addAllErrors(elements);
    }

    /**
     * Adds elements to {@link Fault#getErrors() errors} list.
     * @param elements An iterable of errors elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllErrors(Iterable<? extends Error> elements) {
      Objects.requireNonNull(elements, "errors element");
      if (this.errors == null) {
        this.errors = new ArrayList<Error>();
      }
      for (Error element : elements) {
        this.errors.add(Objects.requireNonNull(element, "errors element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableFault ImmutableFault}.
     * @return An immutable instance of Fault
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFault build() {
      return new ImmutableFault(faultCode, faultString, errors == null ? null : List.copyOf(errors));
    }
  }
}
