/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.util;

import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringUtil {
    private static final Pattern startOfLine = Pattern.compile("^", 8);

    public static String indent(String value, int count) {
        if (value == null) {
            return null;
        }
        if (count > 0) {
            return startOfLine.matcher(value).replaceAll(" ".repeat(count));
        }
        return value;
    }

    public static boolean isEmpty(@Nullable String s) {
        return s == null || s.isEmpty();
    }

    public static boolean nonEmpty(@Nullable String s) {
        return !StringUtil.isEmpty(s);
    }

    public static boolean allEmpty(String ... s) {
        return Stream.of(s).allMatch(StringUtil::isEmpty);
    }

    public static boolean anyEmpty(String ... s) {
        return Stream.of(s).anyMatch(StringUtil::isEmpty);
    }

    public static boolean noneEmpty(String ... s) {
        return Stream.of(s).noneMatch(StringUtil::isEmpty);
    }

    @Nullable
    public static String emptyToNull(@Nullable String s) {
        return StringUtil.nonEmpty(s) ? s : null;
    }

    @NotNull
    public static String nullToEmpty(@Nullable String s) {
        return s == null ? "" : s;
    }

    @NotNull
    public static String defaultTo(@Nullable String value, @NotNull String defaultValue) {
        return StringUtil.nonEmpty(value) ? value : defaultValue;
    }

    @NotNull
    public static String defaultGet(@Nullable String value, @NotNull Supplier<String> defaultValue) {
        return StringUtil.nonEmpty(value) ? value : defaultValue.get();
    }

    @Nullable
    public static String firstNonEmpty(String ... str) {
        for (String s : str) {
            if (!StringUtil.nonEmpty(s)) continue;
            return s;
        }
        return null;
    }
}

