/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.util;

import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ObjectUtil {
    @NotNull
    public static <T> T defaultTo(@Nullable T value, @NotNull T defaultValue) {
        return value != null ? value : defaultValue;
    }

    @NotNull
    public static <T> T defaultTo(@Nullable T value, @NotNull @NotNull Supplier<@NotNull T> defaultValue) {
        return value != null ? value : defaultValue.get();
    }

    @SafeVarargs
    @Nullable
    public static <T> T firstNonNull(T ... ts) {
        for (T t : ts) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static boolean anyNull(Object item1, Object ... items) {
        if (item1 == null) {
            return true;
        }
        for (Object item : items) {
            if (item != null) continue;
            return true;
        }
        return false;
    }

    public static boolean noneNull(Object item1, Object ... items) {
        return !ObjectUtil.anyNull(item1, items);
    }

    @Nullable
    public static <T, U> U apply(@Nullable T value, @NotNull Function<T, U> function) {
        return value != null ? (U)function.apply(value) : null;
    }
}

