/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class Lazy<T>
implements Supplier<T> {
    private static final Object UNINITIALIZED = new Object();
    @NotNull
    private final Supplier<T> supplier;
    private volatile T value = UNINITIALIZED;
    private volatile RuntimeException exception;

    public Lazy(@NotNull Supplier<T> supplier) {
        this.supplier = Objects.requireNonNull(supplier);
    }

    public static <T> Lazy<T> of(@NotNull Supplier<T> supplier) {
        return new Lazy<T>(supplier);
    }

    public boolean isInitialized() {
        return this.value != UNINITIALIZED;
    }

    public boolean isValid() {
        return this.value != UNINITIALIZED && this.exception == null;
    }

    public boolean failed() {
        return this.value != UNINITIALIZED && this.exception != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"THROWS"})
    public T get() {
        if (this.value == UNINITIALIZED) {
            Lazy lazy = this;
            synchronized (lazy) {
                if (this.value == UNINITIALIZED) {
                    try {
                        this.value = this.supplier.get();
                    }
                    catch (RuntimeException e) {
                        this.value = null;
                        this.exception = e;
                    }
                }
            }
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.value;
    }
}

