/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.api;

import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.UUID;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.ConnectorConfigurationException;
import zeenea.connector.commons.api.CantGuessStoreTypeException;
import zeenea.connector.commons.api.ImmutableKeyStoreConfig;
import zeenea.connector.commons.api.StoreHelper;
import zeenea.connector.commons.api.TrustStorePathMissingException;
import zeenea.connector.commons.immutables.ImmutablePojo;
import zeenea.connector.config.ConfigPropertyKey;
import zeenea.connector.jdk.ConnectorBuilders;
import zeenea.connector.jdk.PropertyValueMap;
import zeenea.connector.source.PasswordSourceConnectionConfigurationProperty;
import zeenea.connector.source.SourceConnectionConfigurationProperty;
import zeenea.connector.source.SourceProperty;
import zeenea.connector.source.SourceSection;
import zeenea.connector.source.SourceStringProperty;
import zeenea.connector.source.StringSourceConnectionConfigurationProperty;

@ImmutablePojo
public abstract class KeyStoreConfig {
    public static final StringSourceConnectionConfigurationProperty TLS_KEYSTORE_PATH_CONF = ConnectorBuilders.stringConfig((UUID)UUID.fromString("ae514bc3-934d-4515-97c2-21b777805a1b"), (ConfigPropertyKey)ConfigPropertyKey.of((String)"tls.keystore.path"), (String)"TLS/SSL Keystore Path");
    public static final PasswordSourceConnectionConfigurationProperty TLS_KEYSTORE_PASSWORD_CONF = ConnectorBuilders.passwordConfig((UUID)UUID.fromString("f5c01885-4576-48ac-84b4-47090662752d"), (ConfigPropertyKey)ConfigPropertyKey.of((String)"tls.keystore.password"), (String)"TLS/SSL Keystore Password");
    public static final StringSourceConnectionConfigurationProperty TLS_KEYSTORE_TYPE_CONF = ConnectorBuilders.stringConfig((UUID)UUID.fromString("e4dcab04-d65f-4c62-9e2e-044846bea3fa"), (ConfigPropertyKey)ConfigPropertyKey.of((String)"tls.keystore.type"), (String)"TLS/SSL Keystore Type");
    public static final PasswordSourceConnectionConfigurationProperty TLS_KEY_PASSWORD_CONF = ConnectorBuilders.passwordConfig((UUID)UUID.fromString("e816781e-55aa-437e-bf43-c9321613826a"), (ConfigPropertyKey)ConfigPropertyKey.of((String)"tls.key.password"), (String)"TLS/SSL Key Password");

    public static SourceSection section() {
        return ConnectorBuilders.sourceSection((String)"TLS Key Store").property((SourceConnectionConfigurationProperty)TLS_KEYSTORE_PATH_CONF).property((SourceConnectionConfigurationProperty)TLS_KEYSTORE_PASSWORD_CONF).property((SourceConnectionConfigurationProperty)TLS_KEYSTORE_TYPE_CONF).property((SourceConnectionConfigurationProperty)TLS_KEY_PASSWORD_CONF).build();
    }

    public static ImmutableKeyStoreConfig.Builder builder() {
        return ImmutableKeyStoreConfig.builder();
    }

    @Nullable
    public static KeyStoreConfig of(PropertyValueMap configuration) throws ConnectorConfigurationException {
        Optional<Path> path = configuration.get((SourceStringProperty)TLS_KEYSTORE_PATH_CONF).map(x$0 -> Paths.get(x$0, new String[0]));
        if (path.isPresent()) {
            try {
                ImmutableKeyStoreConfig.Builder builder = KeyStoreConfig.builder();
                builder.storePath(path.get());
                configuration.get((SourceStringProperty)TLS_KEYSTORE_TYPE_CONF).ifPresent(builder::storeType);
                configuration.get((SourceStringProperty)TLS_KEYSTORE_PASSWORD_CONF).ifPresent(builder::storePassword);
                configuration.get((SourceStringProperty)TLS_KEY_PASSWORD_CONF).ifPresent(builder::keyPassword);
                return builder.build();
            }
            catch (InvalidPathException | TrustStorePathMissingException e) {
                throw new ConnectorConfigurationException((SourceProperty)TLS_KEYSTORE_PATH_CONF, e.getMessage(), (Throwable)e);
            }
            catch (CantGuessStoreTypeException e) {
                throw new ConnectorConfigurationException((SourceProperty)TLS_KEYSTORE_TYPE_CONF, e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Value.Check
    protected void check() {
        Path path = this.getStorePath();
        if (!Files.exists(path, new LinkOption[0])) {
            throw new TrustStorePathMissingException("keystore_config_store_path_doesnt_exist '" + path + "'");
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new TrustStorePathMissingException("truststore_config_store_path_isnt_regular_file '" + path + "'");
        }
        if (!Files.isReadable(path)) {
            throw new TrustStorePathMissingException("truststore_config_store_path_cant_be_read '" + path + "'");
        }
    }

    public abstract Path getStorePath();

    @Value.Default
    public String getStoreType() {
        return StoreHelper.storeTypeFromExtension(this.getStorePath());
    }

    @Value.Redacted
    public abstract String getStorePassword();

    @Value.Default
    @Value.Redacted
    public String getKeyPassword() {
        return this.getStorePassword();
    }
}

