/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.sql.parser;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.merge.Merge;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.jetbrains.annotations.NotNull;

public class TableFinder
extends TablesNamesFinder {
    @NotNull
    private final Map<String, Table> sources = new HashMap<String, Table>();
    @NotNull
    private final Map<String, Table> targets = new HashMap<String, Table>();

    @NotNull
    public Set<String> getTables(Statement statement) {
        Set<String> tableList = super.getTables(statement);
        return tableList != null ? tableList : Collections.emptySet();
    }

    public void visit(Table table) {
        super.visit(table);
        this.sources.put(table.getFullyQualifiedName(), table);
    }

    public void visit(Merge merge) {
        super.visit(merge.getTable());
        this.targets.put(merge.getTable().getFullyQualifiedName(), merge.getTable());
        if (merge.getWithItemsList() != null) {
            for (WithItem withItem : merge.getWithItemsList()) {
                withItem.accept((SelectVisitor)this);
            }
        }
        if (merge.getFromItem() != null) {
            merge.getFromItem().accept((FromItemVisitor)this);
        }
    }

    @NotNull
    public List<Table> getSources(List<String> foundTables) {
        return foundTables.stream().map(this.sources::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    public List<Table> getTargets(List<String> foundTables) {
        return foundTables.stream().map(this.targets::get).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

