/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.sql.parser;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.sql.parser.SqlStatement;
import zeenea.connector.commons.sql.parser.SqlTable;

@ParametersAreNonnullByDefault
@Generated(from="SqlStatement", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableSqlStatement
implements SqlStatement {
    @Nullable
    private final String statement;
    private final List<SqlTable> sourceTables;
    private final List<SqlTable> targetTables;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSqlStatement(Builder builder) {
        this.statement = builder.statement;
        if (builder.sourceTablesIsSet()) {
            this.initShim.sourceTables(List.copyOf(builder.sourceTables));
        }
        if (builder.targetTablesIsSet()) {
            this.initShim.targetTables(List.copyOf(builder.targetTables));
        }
        this.sourceTables = this.initShim.sourceTables();
        this.targetTables = this.initShim.targetTables();
        this.initShim = null;
    }

    private ImmutableSqlStatement(@Nullable String statement, List<SqlTable> sourceTables, List<SqlTable> targetTables) {
        this.statement = statement;
        this.sourceTables = sourceTables;
        this.targetTables = targetTables;
        this.initShim = null;
    }

    private List<SqlTable> sourceTablesInitialize() {
        return SqlStatement.super.sourceTables();
    }

    private List<SqlTable> targetTablesInitialize() {
        return SqlStatement.super.targetTables();
    }

    @Override
    @Nullable
    public String statement() {
        return this.statement;
    }

    @Override
    public List<SqlTable> sourceTables() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sourceTables() : this.sourceTables;
    }

    @Override
    public List<SqlTable> targetTables() {
        InitShim shim = this.initShim;
        return shim != null ? shim.targetTables() : this.targetTables;
    }

    public final ImmutableSqlStatement withStatement(@Nullable String value) {
        if (Objects.equals(this.statement, value)) {
            return this;
        }
        return new ImmutableSqlStatement(value, this.sourceTables, this.targetTables);
    }

    public final ImmutableSqlStatement withSourceTables(SqlTable ... elements) {
        List<SqlTable> newValue = List.of(elements);
        return new ImmutableSqlStatement(this.statement, newValue, this.targetTables);
    }

    public final ImmutableSqlStatement withSourceTables(Iterable<? extends SqlTable> elements) {
        if (this.sourceTables == elements) {
            return this;
        }
        List<SqlTable> newValue = elements instanceof Collection ? List.copyOf((Collection)elements) : StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toUnmodifiableList());
        return new ImmutableSqlStatement(this.statement, newValue, this.targetTables);
    }

    public final ImmutableSqlStatement withTargetTables(SqlTable ... elements) {
        List<SqlTable> newValue = List.of(elements);
        return new ImmutableSqlStatement(this.statement, this.sourceTables, newValue);
    }

    public final ImmutableSqlStatement withTargetTables(Iterable<? extends SqlTable> elements) {
        if (this.targetTables == elements) {
            return this;
        }
        List<SqlTable> newValue = elements instanceof Collection ? List.copyOf((Collection)elements) : StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toUnmodifiableList());
        return new ImmutableSqlStatement(this.statement, this.sourceTables, newValue);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSqlStatement && this.equalTo(0, (ImmutableSqlStatement)another);
    }

    private boolean equalTo(int synthetic, ImmutableSqlStatement another) {
        return Objects.equals(this.statement, another.statement) && this.sourceTables.equals(another.sourceTables) && this.targetTables.equals(another.targetTables);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.statement);
        h += (h << 5) + this.sourceTables.hashCode();
        h += (h << 5) + this.targetTables.hashCode();
        return h;
    }

    public String toString() {
        return "SqlStatement{statement=" + this.statement + ", sourceTables=" + this.sourceTables + ", targetTables=" + this.targetTables + "}";
    }

    public static ImmutableSqlStatement copyOf(SqlStatement instance) {
        if (instance instanceof ImmutableSqlStatement) {
            return (ImmutableSqlStatement)instance;
        }
        return ImmutableSqlStatement.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SqlStatement", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SOURCE_TABLES = 1L;
        private static final long OPT_BIT_TARGET_TABLES = 2L;
        private long optBits;
        @javax.annotation.Nullable
        private String statement;
        private List<SqlTable> sourceTables = new ArrayList<SqlTable>();
        private List<SqlTable> targetTables = new ArrayList<SqlTable>();

        private Builder() {
        }

        public final Builder from(SqlStatement instance) {
            Objects.requireNonNull(instance, "instance");
            @Nullable String statementValue = instance.statement();
            if (statementValue != null) {
                this.statement(statementValue);
            }
            this.addAllSourceTables(instance.sourceTables());
            this.addAllTargetTables(instance.targetTables());
            return this;
        }

        public final Builder statement(@Nullable String statement) {
            this.statement = statement;
            return this;
        }

        public final Builder addSourceTables(SqlTable element) {
            this.sourceTables.add(Objects.requireNonNull(element, "sourceTables element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addSourceTables(SqlTable ... elements) {
            for (SqlTable element : elements) {
                this.sourceTables.add(Objects.requireNonNull(element, "sourceTables element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder sourceTables(Iterable<? extends SqlTable> elements) {
            this.sourceTables.clear();
            return this.addAllSourceTables(elements);
        }

        public final Builder addAllSourceTables(Iterable<? extends SqlTable> elements) {
            for (SqlTable sqlTable : elements) {
                this.sourceTables.add(Objects.requireNonNull(sqlTable, "sourceTables element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder addTargetTables(SqlTable element) {
            this.targetTables.add(Objects.requireNonNull(element, "targetTables element"));
            this.optBits |= 2L;
            return this;
        }

        public final Builder addTargetTables(SqlTable ... elements) {
            for (SqlTable element : elements) {
                this.targetTables.add(Objects.requireNonNull(element, "targetTables element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public final Builder targetTables(Iterable<? extends SqlTable> elements) {
            this.targetTables.clear();
            return this.addAllTargetTables(elements);
        }

        public final Builder addAllTargetTables(Iterable<? extends SqlTable> elements) {
            for (SqlTable sqlTable : elements) {
                this.targetTables.add(Objects.requireNonNull(sqlTable, "targetTables element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public ImmutableSqlStatement build() {
            return new ImmutableSqlStatement(this);
        }

        private boolean sourceTablesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean targetTablesIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Generated(from="SqlStatement", generator="Immutables")
    private final class InitShim {
        private byte sourceTablesBuildStage = 0;
        private List<SqlTable> sourceTables;
        private byte targetTablesBuildStage = 0;
        private List<SqlTable> targetTables;

        private InitShim() {
        }

        List<SqlTable> sourceTables() {
            if (this.sourceTablesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sourceTablesBuildStage == 0) {
                this.sourceTablesBuildStage = (byte)-1;
                this.sourceTables = ImmutableSqlStatement.this.sourceTablesInitialize() instanceof Collection ? List.copyOf(ImmutableSqlStatement.this.sourceTablesInitialize()) : StreamSupport.stream(ImmutableSqlStatement.this.sourceTablesInitialize().spliterator(), false).collect(Collectors.toUnmodifiableList());
                this.sourceTablesBuildStage = 1;
            }
            return this.sourceTables;
        }

        void sourceTables(List<SqlTable> sourceTables) {
            this.sourceTables = sourceTables;
            this.sourceTablesBuildStage = 1;
        }

        List<SqlTable> targetTables() {
            if (this.targetTablesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.targetTablesBuildStage == 0) {
                this.targetTablesBuildStage = (byte)-1;
                this.targetTables = ImmutableSqlStatement.this.targetTablesInitialize() instanceof Collection ? List.copyOf(ImmutableSqlStatement.this.targetTablesInitialize()) : StreamSupport.stream(ImmutableSqlStatement.this.targetTablesInitialize().spliterator(), false).collect(Collectors.toUnmodifiableList());
                this.targetTablesBuildStage = 1;
            }
            return this.targetTables;
        }

        void targetTables(List<SqlTable> targetTables) {
            this.targetTables = targetTables;
            this.targetTablesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sourceTablesBuildStage == -1) {
                attributes.add("sourceTables");
            }
            if (this.targetTablesBuildStage == -1) {
                attributes.add("targetTables");
            }
            return "Cannot build SqlStatement, attribute initializers form cycle " + attributes;
        }
    }
}

