package zeenea.connector.sap.sac.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;

/**
 * Immutable implementation of {@link Story}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableStory.builder()}.
 */
@Generated(from = "Story", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableStory implements Story {
  @NotNull
  private final String id;
  @NotNull
  private final String name;
  private final String description;
  private final String createdBy;
  private final String createdAt;
  private final String updatedBy;
  private final String updatedAt;
  private final String openURL;
  private final List<Model> models;

  private ImmutableStory(
      String id,
      String name,
      String description,
      String createdBy,
      String createdAt,
      String updatedBy,
      String updatedAt,
      String openURL,
      List<Model> models) {
    this.id = id;
    this.name = name;
    this.description = description;
    this.createdBy = createdBy;
    this.createdAt = createdAt;
    this.updatedBy = updatedBy;
    this.updatedAt = updatedAt;
    this.openURL = openURL;
    this.models = models;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @NotNull
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @NotNull
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code createdBy} attribute
   */
  @JsonProperty("createdBy")
  @Override
  public String getCreatedBy() {
    return createdBy;
  }

  /**
   * @return The value of the {@code createdAt} attribute
   */
  @JsonProperty("created")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * @return The value of the {@code updatedBy} attribute
   */
  @JsonProperty("changedBy")
  @Override
  public String getUpdatedBy() {
    return updatedBy;
  }

  /**
   * @return The value of the {@code updatedAt} attribute
   */
  @JsonProperty("changed")
  @Override
  public String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * @return The value of the {@code openURL} attribute
   */
  @JsonProperty("openURL")
  @Override
  public String getOpenURL() {
    return openURL;
  }

  /**
   * @return The value of the {@code models} attribute
   */
  @JsonProperty("models")
  @Override
  public List<Model> getModels() {
    return models;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Story#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStory withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableStory(
        newValue,
        this.name,
        this.description,
        this.createdBy,
        this.createdAt,
        this.updatedBy,
        this.updatedAt,
        this.openURL,
        this.models);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Story#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStory withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableStory(
        this.id,
        newValue,
        this.description,
        this.createdBy,
        this.createdAt,
        this.updatedBy,
        this.updatedAt,
        this.openURL,
        this.models);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Story#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStory withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return new ImmutableStory(
        this.id,
        this.name,
        newValue,
        this.createdBy,
        this.createdAt,
        this.updatedBy,
        this.updatedAt,
        this.openURL,
        this.models);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Story#getCreatedBy() createdBy} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdBy
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStory withCreatedBy(String value) {
    String newValue = Objects.requireNonNull(value, "createdBy");
    if (this.createdBy.equals(newValue)) return this;
    return new ImmutableStory(
        this.id,
        this.name,
        this.description,
        newValue,
        this.createdAt,
        this.updatedBy,
        this.updatedAt,
        this.openURL,
        this.models);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Story#getCreatedAt() createdAt} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdAt
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStory withCreatedAt(String value) {
    String newValue = Objects.requireNonNull(value, "createdAt");
    if (this.createdAt.equals(newValue)) return this;
    return new ImmutableStory(
        this.id,
        this.name,
        this.description,
        this.createdBy,
        newValue,
        this.updatedBy,
        this.updatedAt,
        this.openURL,
        this.models);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Story#getUpdatedBy() updatedBy} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedBy
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStory withUpdatedBy(String value) {
    String newValue = Objects.requireNonNull(value, "updatedBy");
    if (this.updatedBy.equals(newValue)) return this;
    return new ImmutableStory(
        this.id,
        this.name,
        this.description,
        this.createdBy,
        this.createdAt,
        newValue,
        this.updatedAt,
        this.openURL,
        this.models);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Story#getUpdatedAt() updatedAt} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updatedAt
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStory withUpdatedAt(String value) {
    String newValue = Objects.requireNonNull(value, "updatedAt");
    if (this.updatedAt.equals(newValue)) return this;
    return new ImmutableStory(
        this.id,
        this.name,
        this.description,
        this.createdBy,
        this.createdAt,
        this.updatedBy,
        newValue,
        this.openURL,
        this.models);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Story#getOpenURL() openURL} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for openURL
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableStory withOpenURL(String value) {
    String newValue = Objects.requireNonNull(value, "openURL");
    if (this.openURL.equals(newValue)) return this;
    return new ImmutableStory(
        this.id,
        this.name,
        this.description,
        this.createdBy,
        this.createdAt,
        this.updatedBy,
        this.updatedAt,
        newValue,
        this.models);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Story#getModels() models}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStory withModels(Model... elements) {
    List<Model> newValue = List.of(elements);
    return new ImmutableStory(
        this.id,
        this.name,
        this.description,
        this.createdBy,
        this.createdAt,
        this.updatedBy,
        this.updatedAt,
        this.openURL,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Story#getModels() models}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of models elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableStory withModels(Iterable<? extends Model> elements) {
    if (this.models == elements) return this;
    List<Model> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Model>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableStory(
        this.id,
        this.name,
        this.description,
        this.createdBy,
        this.createdAt,
        this.updatedBy,
        this.updatedAt,
        this.openURL,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableStory} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableStory
        && equalTo(0, (ImmutableStory) another);
  }

  private boolean equalTo(int synthetic, ImmutableStory another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && description.equals(another.description)
        && createdBy.equals(another.createdBy)
        && createdAt.equals(another.createdAt)
        && updatedBy.equals(another.updatedBy)
        && updatedAt.equals(another.updatedAt)
        && openURL.equals(another.openURL)
        && models.equals(another.models);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code description}, {@code createdBy}, {@code createdAt}, {@code updatedBy}, {@code updatedAt}, {@code openURL}, {@code models}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + description.hashCode();
    h += (h << 5) + createdBy.hashCode();
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + updatedBy.hashCode();
    h += (h << 5) + updatedAt.hashCode();
    h += (h << 5) + openURL.hashCode();
    h += (h << 5) + models.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Story} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Story{"
        + "id=" + id
        + ", name=" + name
        + ", description=" + description
        + ", createdBy=" + createdBy
        + ", createdAt=" + createdAt
        + ", updatedBy=" + updatedBy
        + ", updatedAt=" + updatedAt
        + ", openURL=" + openURL
        + ", models=" + models
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Story", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Story {
    @Nullable String id;
    @Nullable String name;
    @Nullable String description;
    @Nullable String createdBy;
    @Nullable String createdAt;
    @Nullable String updatedBy;
    @Nullable String updatedAt;
    @Nullable String openURL;
    @Nullable List<Model> models = List.of();
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("description")
    public void setDescription(String description) {
      this.description = description;
    }
    @JsonProperty("createdBy")
    public void setCreatedBy(String createdBy) {
      this.createdBy = createdBy;
    }
    @JsonProperty("created")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("changedBy")
    public void setUpdatedBy(String updatedBy) {
      this.updatedBy = updatedBy;
    }
    @JsonProperty("changed")
    public void setUpdatedAt(String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @JsonProperty("openURL")
    public void setOpenURL(String openURL) {
      this.openURL = openURL;
    }
    @JsonProperty("models")
    public void setModels(List<Model> models) {
      this.models = models;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getCreatedBy() { throw new UnsupportedOperationException(); }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedBy() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getOpenURL() { throw new UnsupportedOperationException(); }
    @Override
    public List<Model> getModels() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableStory fromJson(Json json) {
    ImmutableStory.Builder builder = ImmutableStory.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.createdBy != null) {
      builder.createdBy(json.createdBy);
    }
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.updatedBy != null) {
      builder.updatedBy(json.updatedBy);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    if (json.openURL != null) {
      builder.openURL(json.openURL);
    }
    if (json.models != null) {
      builder.addAllModels(json.models);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Story} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Story instance
   */
  public static ImmutableStory copyOf(Story instance) {
    if (instance instanceof ImmutableStory) {
      return (ImmutableStory) instance;
    }
    return ImmutableStory.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableStory ImmutableStory}.
   * <pre>
   * ImmutableStory.builder()
   *    .id(String) // required {@link Story#getId() id}
   *    .name(String) // required {@link Story#getName() name}
   *    .description(String) // required {@link Story#getDescription() description}
   *    .createdBy(String) // required {@link Story#getCreatedBy() createdBy}
   *    .createdAt(String) // required {@link Story#getCreatedAt() createdAt}
   *    .updatedBy(String) // required {@link Story#getUpdatedBy() updatedBy}
   *    .updatedAt(String) // required {@link Story#getUpdatedAt() updatedAt}
   *    .openURL(String) // required {@link Story#getOpenURL() openURL}
   *    .addModels|addAllModels(zeenea.connector.sap.sac.client.model.Model) // {@link Story#getModels() models} elements
   *    .build();
   * </pre>
   * @return A new ImmutableStory builder
   */
  public static ImmutableStory.Builder builder() {
    return new ImmutableStory.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableStory ImmutableStory}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Story", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_DESCRIPTION = 0x4L;
    private static final long INIT_BIT_CREATED_BY = 0x8L;
    private static final long INIT_BIT_CREATED_AT = 0x10L;
    private static final long INIT_BIT_UPDATED_BY = 0x20L;
    private static final long INIT_BIT_UPDATED_AT = 0x40L;
    private static final long INIT_BIT_OPEN_U_R_L = 0x80L;
    private long initBits = 0xffL;

    private @Nullable String id;
    private @Nullable String name;
    private @Nullable String description;
    private @Nullable String createdBy;
    private @Nullable String createdAt;
    private @Nullable String updatedBy;
    private @Nullable String updatedAt;
    private @Nullable String openURL;
    private List<Model> models = new ArrayList<Model>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Story} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Story instance) {
      Objects.requireNonNull(instance, "instance");
      this.id(instance.getId());
      this.name(instance.getName());
      this.description(instance.getDescription());
      this.createdBy(instance.getCreatedBy());
      this.createdAt(instance.getCreatedAt());
      this.updatedBy(instance.getUpdatedBy());
      this.updatedAt(instance.getUpdatedAt());
      this.openURL(instance.getOpenURL());
      addAllModels(instance.getModels());
      return this;
    }

    /**
     * Initializes the value for the {@link Story#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Story#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Story#getDescription() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("description")
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Initializes the value for the {@link Story#getCreatedBy() createdBy} attribute.
     * @param createdBy The value for createdBy 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("createdBy")
    public final Builder createdBy(String createdBy) {
      this.createdBy = Objects.requireNonNull(createdBy, "createdBy");
      initBits &= ~INIT_BIT_CREATED_BY;
      return this;
    }

    /**
     * Initializes the value for the {@link Story#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("created")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link Story#getUpdatedBy() updatedBy} attribute.
     * @param updatedBy The value for updatedBy 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("changedBy")
    public final Builder updatedBy(String updatedBy) {
      this.updatedBy = Objects.requireNonNull(updatedBy, "updatedBy");
      initBits &= ~INIT_BIT_UPDATED_BY;
      return this;
    }

    /**
     * Initializes the value for the {@link Story#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("changed")
    public final Builder updatedAt(String updatedAt) {
      this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
      initBits &= ~INIT_BIT_UPDATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link Story#getOpenURL() openURL} attribute.
     * @param openURL The value for openURL 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("openURL")
    public final Builder openURL(String openURL) {
      this.openURL = Objects.requireNonNull(openURL, "openURL");
      initBits &= ~INIT_BIT_OPEN_U_R_L;
      return this;
    }

    /**
     * Adds one element to {@link Story#getModels() models} list.
     * @param element A models element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addModels(Model element) {
      this.models.add(Objects.requireNonNull(element, "models element"));
      return this;
    }

    /**
     * Adds elements to {@link Story#getModels() models} list.
     * @param elements An array of models elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addModels(Model... elements) {
      for (Model element : elements) {
        this.models.add(Objects.requireNonNull(element, "models element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Story#getModels() models} list.
     * @param elements An iterable of models elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("models")
    public final Builder models(Iterable<? extends Model> elements) {
      this.models.clear();
      return addAllModels(elements);
    }

    /**
     * Adds elements to {@link Story#getModels() models} list.
     * @param elements An iterable of models elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllModels(Iterable<? extends Model> elements) {
      for (Model element : elements) {
        this.models.add(Objects.requireNonNull(element, "models element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableStory ImmutableStory}.
     * @return An immutable instance of Story
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableStory build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableStory(
          id,
          name,
          description,
          createdBy,
          createdAt,
          updatedBy,
          updatedAt,
          openURL,
          List.copyOf(models));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      if ((initBits & INIT_BIT_CREATED_BY) != 0) attributes.add("createdBy");
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_UPDATED_BY) != 0) attributes.add("updatedBy");
      if ((initBits & INIT_BIT_UPDATED_AT) != 0) attributes.add("updatedAt");
      if ((initBits & INIT_BIT_OPEN_U_R_L) != 0) attributes.add("openURL");
      return "Cannot build Story, some of required attributes are not set " + attributes;
    }
  }
}
