package zeenea.connector.sap.sac.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link RemoteConnection}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRemoteConnection.builder()}.
 */
@Generated(from = "RemoteConnection", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRemoteConnection implements RemoteConnection {
  private final @Nullable String client;
  private final @Nullable String connectionType;
  private final @Nullable String systemType;
  private final @Nullable String name;
  private final @Nullable String protocol;
  private final @Nullable String language;
  private final @Nullable String database;
  private final @Nullable String pathPrefix;
  private final @Nullable String host;
  private final @Nullable String port;
  private final @Nullable String scpAccount;

  private ImmutableRemoteConnection(
      @Nullable String client,
      @Nullable String connectionType,
      @Nullable String systemType,
      @Nullable String name,
      @Nullable String protocol,
      @Nullable String language,
      @Nullable String database,
      @Nullable String pathPrefix,
      @Nullable String host,
      @Nullable String port,
      @Nullable String scpAccount) {
    this.client = client;
    this.connectionType = connectionType;
    this.systemType = systemType;
    this.name = name;
    this.protocol = protocol;
    this.language = language;
    this.database = database;
    this.pathPrefix = pathPrefix;
    this.host = host;
    this.port = port;
    this.scpAccount = scpAccount;
  }

  /**
   * @return The value of the {@code client} attribute
   */
  @JsonProperty("client")
  @Override
  public @Nullable String getClient() {
    return client;
  }

  /**
   * @return The value of the {@code connectionType} attribute
   */
  @JsonProperty("connectionType")
  @Override
  public @Nullable String getConnectionType() {
    return connectionType;
  }

  /**
   * @return The value of the {@code systemType} attribute
   */
  @JsonProperty("systemType")
  @Override
  public @Nullable String getSystemType() {
    return systemType;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code protocol} attribute
   */
  @JsonProperty("protocol")
  @Override
  public @Nullable String getProtocol() {
    return protocol;
  }

  /**
   * @return The value of the {@code language} attribute
   */
  @JsonProperty("language")
  @Override
  public @Nullable String getLanguage() {
    return language;
  }

  /**
   * @return The value of the {@code database} attribute
   */
  @JsonProperty("database")
  @Override
  public @Nullable String getDatabase() {
    return database;
  }

  /**
   * @return The value of the {@code pathPrefix} attribute
   */
  @JsonProperty("pathPrefix")
  @Override
  public @Nullable String getPathPrefix() {
    return pathPrefix;
  }

  /**
   * @return The value of the {@code host} attribute
   */
  @JsonProperty("host")
  @Override
  public @Nullable String getHost() {
    return host;
  }

  /**
   * @return The value of the {@code port} attribute
   */
  @JsonProperty("port")
  @Override
  public @Nullable String getPort() {
    return port;
  }

  /**
   * @return The value of the {@code scpAccount} attribute
   */
  @JsonProperty("scpAccount")
  @Override
  public @Nullable String getScpAccount() {
    return scpAccount;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RemoteConnection#getClient() client} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for client (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRemoteConnection withClient(@Nullable String value) {
    if (Objects.equals(this.client, value)) return this;
    return new ImmutableRemoteConnection(
        value,
        this.connectionType,
        this.systemType,
        this.name,
        this.protocol,
        this.language,
        this.database,
        this.pathPrefix,
        this.host,
        this.port,
        this.scpAccount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RemoteConnection#getConnectionType() connectionType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for connectionType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRemoteConnection withConnectionType(@Nullable String value) {
    if (Objects.equals(this.connectionType, value)) return this;
    return new ImmutableRemoteConnection(
        this.client,
        value,
        this.systemType,
        this.name,
        this.protocol,
        this.language,
        this.database,
        this.pathPrefix,
        this.host,
        this.port,
        this.scpAccount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RemoteConnection#getSystemType() systemType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for systemType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRemoteConnection withSystemType(@Nullable String value) {
    if (Objects.equals(this.systemType, value)) return this;
    return new ImmutableRemoteConnection(
        this.client,
        this.connectionType,
        value,
        this.name,
        this.protocol,
        this.language,
        this.database,
        this.pathPrefix,
        this.host,
        this.port,
        this.scpAccount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RemoteConnection#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRemoteConnection withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableRemoteConnection(
        this.client,
        this.connectionType,
        this.systemType,
        value,
        this.protocol,
        this.language,
        this.database,
        this.pathPrefix,
        this.host,
        this.port,
        this.scpAccount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RemoteConnection#getProtocol() protocol} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for protocol (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRemoteConnection withProtocol(@Nullable String value) {
    if (Objects.equals(this.protocol, value)) return this;
    return new ImmutableRemoteConnection(
        this.client,
        this.connectionType,
        this.systemType,
        this.name,
        value,
        this.language,
        this.database,
        this.pathPrefix,
        this.host,
        this.port,
        this.scpAccount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RemoteConnection#getLanguage() language} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for language (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRemoteConnection withLanguage(@Nullable String value) {
    if (Objects.equals(this.language, value)) return this;
    return new ImmutableRemoteConnection(
        this.client,
        this.connectionType,
        this.systemType,
        this.name,
        this.protocol,
        value,
        this.database,
        this.pathPrefix,
        this.host,
        this.port,
        this.scpAccount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RemoteConnection#getDatabase() database} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for database (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRemoteConnection withDatabase(@Nullable String value) {
    if (Objects.equals(this.database, value)) return this;
    return new ImmutableRemoteConnection(
        this.client,
        this.connectionType,
        this.systemType,
        this.name,
        this.protocol,
        this.language,
        value,
        this.pathPrefix,
        this.host,
        this.port,
        this.scpAccount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RemoteConnection#getPathPrefix() pathPrefix} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pathPrefix (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRemoteConnection withPathPrefix(@Nullable String value) {
    if (Objects.equals(this.pathPrefix, value)) return this;
    return new ImmutableRemoteConnection(
        this.client,
        this.connectionType,
        this.systemType,
        this.name,
        this.protocol,
        this.language,
        this.database,
        value,
        this.host,
        this.port,
        this.scpAccount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RemoteConnection#getHost() host} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for host (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRemoteConnection withHost(@Nullable String value) {
    if (Objects.equals(this.host, value)) return this;
    return new ImmutableRemoteConnection(
        this.client,
        this.connectionType,
        this.systemType,
        this.name,
        this.protocol,
        this.language,
        this.database,
        this.pathPrefix,
        value,
        this.port,
        this.scpAccount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RemoteConnection#getPort() port} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for port (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRemoteConnection withPort(@Nullable String value) {
    if (Objects.equals(this.port, value)) return this;
    return new ImmutableRemoteConnection(
        this.client,
        this.connectionType,
        this.systemType,
        this.name,
        this.protocol,
        this.language,
        this.database,
        this.pathPrefix,
        this.host,
        value,
        this.scpAccount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RemoteConnection#getScpAccount() scpAccount} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for scpAccount (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRemoteConnection withScpAccount(@Nullable String value) {
    if (Objects.equals(this.scpAccount, value)) return this;
    return new ImmutableRemoteConnection(
        this.client,
        this.connectionType,
        this.systemType,
        this.name,
        this.protocol,
        this.language,
        this.database,
        this.pathPrefix,
        this.host,
        this.port,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRemoteConnection} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRemoteConnection
        && equalTo(0, (ImmutableRemoteConnection) another);
  }

  private boolean equalTo(int synthetic, ImmutableRemoteConnection another) {
    return Objects.equals(client, another.client)
        && Objects.equals(connectionType, another.connectionType)
        && Objects.equals(systemType, another.systemType)
        && Objects.equals(name, another.name)
        && Objects.equals(protocol, another.protocol)
        && Objects.equals(language, another.language)
        && Objects.equals(database, another.database)
        && Objects.equals(pathPrefix, another.pathPrefix)
        && Objects.equals(host, another.host)
        && Objects.equals(port, another.port)
        && Objects.equals(scpAccount, another.scpAccount);
  }

  /**
   * Computes a hash code from attributes: {@code client}, {@code connectionType}, {@code systemType}, {@code name}, {@code protocol}, {@code language}, {@code database}, {@code pathPrefix}, {@code host}, {@code port}, {@code scpAccount}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(client);
    h += (h << 5) + Objects.hashCode(connectionType);
    h += (h << 5) + Objects.hashCode(systemType);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(protocol);
    h += (h << 5) + Objects.hashCode(language);
    h += (h << 5) + Objects.hashCode(database);
    h += (h << 5) + Objects.hashCode(pathPrefix);
    h += (h << 5) + Objects.hashCode(host);
    h += (h << 5) + Objects.hashCode(port);
    h += (h << 5) + Objects.hashCode(scpAccount);
    return h;
  }

  /**
   * Prints the immutable value {@code RemoteConnection} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RemoteConnection{"
        + "client=" + client
        + ", connectionType=" + connectionType
        + ", systemType=" + systemType
        + ", name=" + name
        + ", protocol=" + protocol
        + ", language=" + language
        + ", database=" + database
        + ", pathPrefix=" + pathPrefix
        + ", host=" + host
        + ", port=" + port
        + ", scpAccount=" + scpAccount
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "RemoteConnection", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements RemoteConnection {
    @javax.annotation.Nullable String client;
    @javax.annotation.Nullable String connectionType;
    @javax.annotation.Nullable String systemType;
    @javax.annotation.Nullable String name;
    @javax.annotation.Nullable String protocol;
    @javax.annotation.Nullable String language;
    @javax.annotation.Nullable String database;
    @javax.annotation.Nullable String pathPrefix;
    @javax.annotation.Nullable String host;
    @javax.annotation.Nullable String port;
    @javax.annotation.Nullable String scpAccount;
    @JsonProperty("client")
    public void setClient(@Nullable String client) {
      this.client = client;
    }
    @JsonProperty("connectionType")
    public void setConnectionType(@Nullable String connectionType) {
      this.connectionType = connectionType;
    }
    @JsonProperty("systemType")
    public void setSystemType(@Nullable String systemType) {
      this.systemType = systemType;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("protocol")
    public void setProtocol(@Nullable String protocol) {
      this.protocol = protocol;
    }
    @JsonProperty("language")
    public void setLanguage(@Nullable String language) {
      this.language = language;
    }
    @JsonProperty("database")
    public void setDatabase(@Nullable String database) {
      this.database = database;
    }
    @JsonProperty("pathPrefix")
    public void setPathPrefix(@Nullable String pathPrefix) {
      this.pathPrefix = pathPrefix;
    }
    @JsonProperty("host")
    public void setHost(@Nullable String host) {
      this.host = host;
    }
    @JsonProperty("port")
    public void setPort(@Nullable String port) {
      this.port = port;
    }
    @JsonProperty("scpAccount")
    public void setScpAccount(@Nullable String scpAccount) {
      this.scpAccount = scpAccount;
    }
    @Override
    public String getClient() { throw new UnsupportedOperationException(); }
    @Override
    public String getConnectionType() { throw new UnsupportedOperationException(); }
    @Override
    public String getSystemType() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getProtocol() { throw new UnsupportedOperationException(); }
    @Override
    public String getLanguage() { throw new UnsupportedOperationException(); }
    @Override
    public String getDatabase() { throw new UnsupportedOperationException(); }
    @Override
    public String getPathPrefix() { throw new UnsupportedOperationException(); }
    @Override
    public String getHost() { throw new UnsupportedOperationException(); }
    @Override
    public String getPort() { throw new UnsupportedOperationException(); }
    @Override
    public String getScpAccount() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableRemoteConnection fromJson(Json json) {
    ImmutableRemoteConnection.Builder builder = ImmutableRemoteConnection.builder();
    if (json.client != null) {
      builder.client(json.client);
    }
    if (json.connectionType != null) {
      builder.connectionType(json.connectionType);
    }
    if (json.systemType != null) {
      builder.systemType(json.systemType);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.protocol != null) {
      builder.protocol(json.protocol);
    }
    if (json.language != null) {
      builder.language(json.language);
    }
    if (json.database != null) {
      builder.database(json.database);
    }
    if (json.pathPrefix != null) {
      builder.pathPrefix(json.pathPrefix);
    }
    if (json.host != null) {
      builder.host(json.host);
    }
    if (json.port != null) {
      builder.port(json.port);
    }
    if (json.scpAccount != null) {
      builder.scpAccount(json.scpAccount);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link RemoteConnection} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RemoteConnection instance
   */
  public static ImmutableRemoteConnection copyOf(RemoteConnection instance) {
    if (instance instanceof ImmutableRemoteConnection) {
      return (ImmutableRemoteConnection) instance;
    }
    return ImmutableRemoteConnection.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRemoteConnection ImmutableRemoteConnection}.
   * <pre>
   * ImmutableRemoteConnection.builder()
   *    .client(String | null) // nullable {@link RemoteConnection#getClient() client}
   *    .connectionType(String | null) // nullable {@link RemoteConnection#getConnectionType() connectionType}
   *    .systemType(String | null) // nullable {@link RemoteConnection#getSystemType() systemType}
   *    .name(String | null) // nullable {@link RemoteConnection#getName() name}
   *    .protocol(String | null) // nullable {@link RemoteConnection#getProtocol() protocol}
   *    .language(String | null) // nullable {@link RemoteConnection#getLanguage() language}
   *    .database(String | null) // nullable {@link RemoteConnection#getDatabase() database}
   *    .pathPrefix(String | null) // nullable {@link RemoteConnection#getPathPrefix() pathPrefix}
   *    .host(String | null) // nullable {@link RemoteConnection#getHost() host}
   *    .port(String | null) // nullable {@link RemoteConnection#getPort() port}
   *    .scpAccount(String | null) // nullable {@link RemoteConnection#getScpAccount() scpAccount}
   *    .build();
   * </pre>
   * @return A new ImmutableRemoteConnection builder
   */
  public static ImmutableRemoteConnection.Builder builder() {
    return new ImmutableRemoteConnection.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRemoteConnection ImmutableRemoteConnection}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RemoteConnection", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String client;
    private @javax.annotation.Nullable String connectionType;
    private @javax.annotation.Nullable String systemType;
    private @javax.annotation.Nullable String name;
    private @javax.annotation.Nullable String protocol;
    private @javax.annotation.Nullable String language;
    private @javax.annotation.Nullable String database;
    private @javax.annotation.Nullable String pathPrefix;
    private @javax.annotation.Nullable String host;
    private @javax.annotation.Nullable String port;
    private @javax.annotation.Nullable String scpAccount;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RemoteConnection} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RemoteConnection instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String clientValue = instance.getClient();
      if (clientValue != null) {
        client(clientValue);
      }
      @Nullable String connectionTypeValue = instance.getConnectionType();
      if (connectionTypeValue != null) {
        connectionType(connectionTypeValue);
      }
      @Nullable String systemTypeValue = instance.getSystemType();
      if (systemTypeValue != null) {
        systemType(systemTypeValue);
      }
      @Nullable String nameValue = instance.getName();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable String protocolValue = instance.getProtocol();
      if (protocolValue != null) {
        protocol(protocolValue);
      }
      @Nullable String languageValue = instance.getLanguage();
      if (languageValue != null) {
        language(languageValue);
      }
      @Nullable String databaseValue = instance.getDatabase();
      if (databaseValue != null) {
        database(databaseValue);
      }
      @Nullable String pathPrefixValue = instance.getPathPrefix();
      if (pathPrefixValue != null) {
        pathPrefix(pathPrefixValue);
      }
      @Nullable String hostValue = instance.getHost();
      if (hostValue != null) {
        host(hostValue);
      }
      @Nullable String portValue = instance.getPort();
      if (portValue != null) {
        port(portValue);
      }
      @Nullable String scpAccountValue = instance.getScpAccount();
      if (scpAccountValue != null) {
        scpAccount(scpAccountValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link RemoteConnection#getClient() client} attribute.
     * @param client The value for client (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("client")
    public final Builder client(@Nullable String client) {
      this.client = client;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoteConnection#getConnectionType() connectionType} attribute.
     * @param connectionType The value for connectionType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("connectionType")
    public final Builder connectionType(@Nullable String connectionType) {
      this.connectionType = connectionType;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoteConnection#getSystemType() systemType} attribute.
     * @param systemType The value for systemType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("systemType")
    public final Builder systemType(@Nullable String systemType) {
      this.systemType = systemType;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoteConnection#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoteConnection#getProtocol() protocol} attribute.
     * @param protocol The value for protocol (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("protocol")
    public final Builder protocol(@Nullable String protocol) {
      this.protocol = protocol;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoteConnection#getLanguage() language} attribute.
     * @param language The value for language (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("language")
    public final Builder language(@Nullable String language) {
      this.language = language;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoteConnection#getDatabase() database} attribute.
     * @param database The value for database (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("database")
    public final Builder database(@Nullable String database) {
      this.database = database;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoteConnection#getPathPrefix() pathPrefix} attribute.
     * @param pathPrefix The value for pathPrefix (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("pathPrefix")
    public final Builder pathPrefix(@Nullable String pathPrefix) {
      this.pathPrefix = pathPrefix;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoteConnection#getHost() host} attribute.
     * @param host The value for host (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("host")
    public final Builder host(@Nullable String host) {
      this.host = host;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoteConnection#getPort() port} attribute.
     * @param port The value for port (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("port")
    public final Builder port(@Nullable String port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the value for the {@link RemoteConnection#getScpAccount() scpAccount} attribute.
     * @param scpAccount The value for scpAccount (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("scpAccount")
    public final Builder scpAccount(@Nullable String scpAccount) {
      this.scpAccount = scpAccount;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRemoteConnection ImmutableRemoteConnection}.
     * @return An immutable instance of RemoteConnection
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRemoteConnection build() {
      return new ImmutableRemoteConnection(
          client,
          connectionType,
          systemType,
          name,
          protocol,
          language,
          database,
          pathPrefix,
          host,
          port,
          scpAccount);
    }
  }
}
