package zeenea.connector.sap.sac.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Model}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableModel.builder()}.
 */
@Generated(from = "Model", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableModel implements Model {
  private final @Nullable String description;
  @NotNull
  private final String id;
  private final @Nullable String externalId;
  private final @Nullable RemoteConnection remoteConnection;

  private ImmutableModel(
      @Nullable String description,
      String id,
      @Nullable String externalId,
      @Nullable RemoteConnection remoteConnection) {
    this.description = description;
    this.id = id;
    this.externalId = externalId;
    this.remoteConnection = remoteConnection;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @NotNull
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code externalId} attribute
   */
  @JsonProperty("externalId")
  @Override
  public @Nullable String getExternalId() {
    return externalId;
  }

  /**
   * @return The value of the {@code remoteConnection} attribute
   */
  @JsonProperty("remoteConnection")
  @Override
  public @Nullable RemoteConnection getRemoteConnection() {
    return remoteConnection;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Model#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableModel withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableModel(value, this.id, this.externalId, this.remoteConnection);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Model#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableModel withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableModel(this.description, newValue, this.externalId, this.remoteConnection);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Model#getExternalId() externalId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for externalId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableModel withExternalId(@Nullable String value) {
    if (Objects.equals(this.externalId, value)) return this;
    return new ImmutableModel(this.description, this.id, value, this.remoteConnection);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Model#getRemoteConnection() remoteConnection} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for remoteConnection (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableModel withRemoteConnection(@Nullable RemoteConnection value) {
    if (this.remoteConnection == value) return this;
    return new ImmutableModel(this.description, this.id, this.externalId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableModel} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableModel
        && equalTo(0, (ImmutableModel) another);
  }

  private boolean equalTo(int synthetic, ImmutableModel another) {
    return Objects.equals(description, another.description)
        && id.equals(another.id)
        && Objects.equals(externalId, another.externalId)
        && Objects.equals(remoteConnection, another.remoteConnection);
  }

  /**
   * Computes a hash code from attributes: {@code description}, {@code id}, {@code externalId}, {@code remoteConnection}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + id.hashCode();
    h += (h << 5) + Objects.hashCode(externalId);
    h += (h << 5) + Objects.hashCode(remoteConnection);
    return h;
  }

  /**
   * Prints the immutable value {@code Model} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Model{"
        + "description=" + description
        + ", id=" + id
        + ", externalId=" + externalId
        + ", remoteConnection=" + remoteConnection
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Model", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Model {
    @javax.annotation.Nullable String description;
    @javax.annotation.Nullable String id;
    @javax.annotation.Nullable String externalId;
    @javax.annotation.Nullable RemoteConnection remoteConnection;
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("externalId")
    public void setExternalId(@Nullable String externalId) {
      this.externalId = externalId;
    }
    @JsonProperty("remoteConnection")
    public void setRemoteConnection(@Nullable RemoteConnection remoteConnection) {
      this.remoteConnection = remoteConnection;
    }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getExternalId() { throw new UnsupportedOperationException(); }
    @Override
    public RemoteConnection getRemoteConnection() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableModel fromJson(Json json) {
    ImmutableModel.Builder builder = ImmutableModel.builder();
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.externalId != null) {
      builder.externalId(json.externalId);
    }
    if (json.remoteConnection != null) {
      builder.remoteConnection(json.remoteConnection);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Model} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Model instance
   */
  public static ImmutableModel copyOf(Model instance) {
    if (instance instanceof ImmutableModel) {
      return (ImmutableModel) instance;
    }
    return ImmutableModel.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableModel ImmutableModel}.
   * <pre>
   * ImmutableModel.builder()
   *    .description(String | null) // nullable {@link Model#getDescription() description}
   *    .id(String) // required {@link Model#getId() id}
   *    .externalId(String | null) // nullable {@link Model#getExternalId() externalId}
   *    .remoteConnection(zeenea.connector.sap.sac.client.model.RemoteConnection | null) // nullable {@link Model#getRemoteConnection() remoteConnection}
   *    .build();
   * </pre>
   * @return A new ImmutableModel builder
   */
  public static ImmutableModel.Builder builder() {
    return new ImmutableModel.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableModel ImmutableModel}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Model", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @javax.annotation.Nullable String description;
    private @javax.annotation.Nullable String id;
    private @javax.annotation.Nullable String externalId;
    private @javax.annotation.Nullable RemoteConnection remoteConnection;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Model} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Model instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      this.id(instance.getId());
      @Nullable String externalIdValue = instance.getExternalId();
      if (externalIdValue != null) {
        externalId(externalIdValue);
      }
      @Nullable RemoteConnection remoteConnectionValue = instance.getRemoteConnection();
      if (remoteConnectionValue != null) {
        remoteConnection(remoteConnectionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Model#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link Model#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link Model#getExternalId() externalId} attribute.
     * @param externalId The value for externalId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("externalId")
    public final Builder externalId(@Nullable String externalId) {
      this.externalId = externalId;
      return this;
    }

    /**
     * Initializes the value for the {@link Model#getRemoteConnection() remoteConnection} attribute.
     * @param remoteConnection The value for remoteConnection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("remoteConnection")
    public final Builder remoteConnection(@Nullable RemoteConnection remoteConnection) {
      this.remoteConnection = remoteConnection;
      return this;
    }

    /**
     * Builds a new {@link ImmutableModel ImmutableModel}.
     * @return An immutable instance of Model
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableModel build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableModel(description, id, externalId, remoteConnection);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build Model, some of required attributes are not set " + attributes;
    }
  }
}
