/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import zeenea.connector.commons.cache.ByteIterator;
import zeenea.connector.commons.cache.InvalidPageException;
import zeenea.connector.commons.cache.PageLoader;
import zeenea.connector.commons.cache.PageOverflowException;
import zeenea.connector.commons.cache.PageState;
import zeenea.connector.commons.cache.ReadOnlyPageException;
import zeenea.connector.commons.cache.ResourceExhaustedException;
import zeenea.connector.commons.cache.VarInt;

class Page {
    public static final int LEN_POW = 12;
    public static final int LENGTH = 4096;
    public static final int INVALID_PAGE = -1;
    private static final byte[] ZEROS = new byte[4096];
    private final PageLoader loader;
    @NotNull
    private final ByteBuffer buffer;
    @NotNull
    private PageState state;
    private int number = -1;
    private int borrowCount;
    private Page nextFree;
    private Page previousFree;

    private Page(PageLoader loader, @NotNull PageState state, @NotNull ByteBuffer buffer) {
        this.loader = Objects.requireNonNull(loader);
        this.state = Objects.requireNonNull(state);
        this.buffer = Objects.requireNonNull(buffer);
    }

    static Page of(@NotNull PageLoader loader, @NotNull ByteBuffer buffer) {
        return new Page(loader, PageState.FREE, buffer);
    }

    static int count(long size) {
        long pageCount = (size >>> 12) + (long)((size & 0xFFFL) == 0L ? 0 : 1);
        if (pageCount <= Integer.MAX_VALUE) {
            return (int)pageCount;
        }
        throw new ResourceExhaustedException("Too long source page_count='" + pageCount + "' max_page_count_supported='2147483647'");
    }

    static long offset(int pageNumber) {
        if (pageNumber == -1) {
            throw new InvalidPageException("Cannot read or write invalid page");
        }
        return (long)pageNumber * 4096L;
    }

    public PageState state() {
        return this.state;
    }

    void setState(@NotNull PageState state) {
        this.state = state;
    }

    boolean isBorrowed() {
        return this.borrowCount > 0;
    }

    void borrow() {
        ++this.borrowCount;
    }

    boolean release() {
        --this.borrowCount;
        return !this.isBorrowed();
    }

    public int number() {
        return this.number;
    }

    void setNumber(int number) {
        this.number = number;
    }

    Page nextFree() {
        return this.nextFree;
    }

    void setNextFree(Page nextFree) {
        this.nextFree = nextFree;
    }

    Page previousFree() {
        return this.previousFree;
    }

    void setPreviousFree(Page previousFree) {
        this.previousFree = previousFree;
    }

    void write(FileChannel channel) {
        try {
            this.buffer.clear();
            while (this.buffer.hasRemaining()) {
                channel.write(this.buffer, this.offset() + (long)this.buffer.position());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void read(FileChannel channel) {
        try {
            this.buffer.clear();
            while (this.buffer.hasRemaining()) {
                int remaining;
                int read = channel.read(this.buffer, this.offset() + (long)this.buffer.position());
                if (read >= 0 || (remaining = this.buffer.remaining()) <= 0) continue;
                this.buffer.put(new byte[remaining]);
            }
            this.buffer.flip();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    void reset() {
        this.setNumber(-1);
        this.setState(PageState.FREE);
        this.borrowCount = 0;
    }

    void clear() {
        this.buffer.clear();
        this.buffer.put(ZEROS);
        this.buffer.clear();
        this.reset();
    }

    void zero(int fromIndex, int toIndex) {
        ByteBuffer bb = this.buffer.duplicate();
        bb.limit(toIndex);
        bb.position(fromIndex);
        bb.put(ZEROS, 0, toIndex - fromIndex);
    }

    private long offset() {
        return Page.offset(this.number);
    }

    private void checkPageBounds(int index, int length) {
        int limit = this.buffer.limit();
        if (index + length > limit) {
            throw new PageOverflowException(this.number, index, length, limit);
        }
    }

    private void maxCheckPageBounds(int index, int length) {
        if (index + length > 4096) {
            throw new PageOverflowException(this.number, index, length, 4096);
        }
    }

    private void modify(int index, int size) {
        if (this.loader.readOnly()) {
            throw new ReadOnlyPageException("Cannot modify read only page " + this.number);
        }
        this.maxCheckPageBounds(index, size);
        this.setState(PageState.MODIFIED);
    }

    public byte get(int index) {
        this.checkPageBounds(index, 1);
        return this.buffer.get(index);
    }

    public void get(int index, ByteBuffer dest) {
        this.checkPageBounds(index, dest.remaining());
        ByteBuffer bb = this.buffer.duplicate();
        bb.limit(index + dest.remaining());
        bb.position(index);
        dest.put(bb);
    }

    public void get(int index, byte[] dst, int offset, int length) {
        this.checkPageBounds(index, length);
        ByteBuffer bb = this.buffer.duplicate();
        bb.limit(index + length);
        bb.position(index);
        bb.get(dst, offset, length);
    }

    public void get(int index, byte[] dst) {
        this.get(index, dst, 0, dst.length);
    }

    public short getShort(int index) {
        this.checkPageBounds(index, 2);
        return this.buffer.getShort(index);
    }

    public int getInt(int index) {
        this.checkPageBounds(index, 4);
        return this.buffer.getInt(index);
    }

    public long getLong(int index) {
        this.checkPageBounds(index, 8);
        return this.buffer.getLong(index);
    }

    public VarInt getVarInt(int index) {
        return VarInt.read(this.buffer, index);
    }

    public void put(int index, byte b) {
        this.modify(index, 1);
        this.buffer.put(index, b);
    }

    public void putShort(int index, short value) {
        this.modify(index, 2);
        this.buffer.putShort(index, value);
    }

    public void putInt(int index, int value) {
        this.modify(index, 4);
        this.buffer.putInt(index, value);
    }

    public void putLong(int index, long value) {
        this.modify(index, 8);
        this.buffer.putLong(index, value);
    }

    public void putVarInt(int index, VarInt value) {
        this.modify(index, value.length());
        value.writeTo(this.buffer, index);
    }

    public int put(int index, ByteBuffer src, int maxLength) {
        if (maxLength == 0) {
            return 0;
        }
        int remaining = src.remaining();
        if (remaining <= maxLength) {
            this.modify(index, remaining);
            this.buffer.position(index);
            this.buffer.put(src);
            return remaining;
        }
        this.modify(index, maxLength);
        ByteBuffer bb = src.duplicate();
        bb.limit(bb.position() + maxLength);
        this.buffer.position(index);
        this.buffer.put(bb);
        src.position(bb.position());
        return maxLength;
    }

    public int put(int index, ByteIterator src, int maxLength) {
        if (maxLength == 0) {
            return 0;
        }
        long remaining = src.remaining();
        int len = remaining <= (long)maxLength ? (int)remaining : maxLength;
        this.modify(index, len);
        int n = index + len;
        for (int i = index; i < n; ++i) {
            this.buffer.put(i, src.next());
        }
        return len;
    }

    public void put(int index, ByteBuffer src) {
        this.modify(index, src.remaining());
        this.buffer.position(index);
        this.buffer.put(src);
    }

    public void put(int index, byte[] b) {
        this.put(index, b, 0, b.length);
    }

    public void put(int index, byte[] src, int offset, int length) {
        this.modify(index, length);
        this.buffer.position(index);
        this.buffer.put(src, offset, length);
    }

    public void copyFrom(int index, Page src, int srcIndex, int length) {
        this.modify(index, length);
        ByteBuffer bb = src.buffer.duplicate();
        bb.limit(srcIndex + length);
        bb.position(srcIndex);
        this.buffer.position(index);
        this.buffer.put(bb);
    }

    public String toString() {
        return String.format("Page %1$d (0x%1$x): %2$d ('%2$c')", this.number, this.buffer.get(0));
    }
}

