/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zeenea.connector.commons.cache.InvalidCacheStateException;
import zeenea.connector.commons.cache.InvalidPageException;
import zeenea.connector.commons.cache.Page;
import zeenea.connector.commons.cache.PageLoader;
import zeenea.connector.commons.cache.PageLoaderState;
import zeenea.connector.commons.cache.PageState;
import zeenea.connector.commons.cache.ReadOnlyPageException;
import zeenea.connector.commons.cache.ResourceExhaustedException;

class MemoryPageLoader
implements PageLoader {
    private static final Logger log = LoggerFactory.getLogger(MemoryPageLoader.class);
    private static final int INIT_MEM_PAGE_COUNT = 2048;
    private static final int WARN_MEM_PAGE_COUNT = 131072;
    private static final int MAX_MEM_PAGE_COUNT = 262144;
    public static final int MEGABYTE = 0x100000;
    private final boolean directAllocation;
    private final List<Page> memPages = new ArrayList<Page>();
    private PageLoaderState state;
    private int pageCount;

    public MemoryPageLoader(boolean directAllocation) {
        this.directAllocation = directAllocation;
        this.state = PageLoaderState.READ;
        this.addPages();
    }

    @Override
    public void close() {
        this.state = PageLoaderState.CLOSED;
    }

    @Override
    public boolean readOnly() {
        return this.state == PageLoaderState.READ;
    }

    private void addPages() {
        ByteBuffer buffer = this.directAllocation ? ByteBuffer.allocateDirect(0x800000) : ByteBuffer.allocate(0x800000);
        for (int i = 0; i < 2048; ++i) {
            buffer.limit((i + 1) * 4096);
            buffer.position(i * 4096);
            ByteBuffer pageBuffer = buffer.slice();
            this.memPages.add(Page.of(this, pageBuffer));
        }
    }

    @Override
    public void startLoading() {
        this.state = PageLoaderState.LOAD;
        this.pageCount = 0;
        for (Page page : this.memPages) {
            page.setState(PageState.FREE);
        }
    }

    @Override
    public void stopLoading() {
        this.state = PageLoaderState.READ;
    }

    @Override
    public boolean hasPage(int pageNumber) {
        return pageNumber < this.pageCount;
    }

    @Override
    public Page newPage() {
        int pageNumber;
        if (this.state == PageLoaderState.CLOSED) {
            throw MemoryPageLoader.cacheIsClosed();
        }
        if (this.state == PageLoaderState.READ) {
            throw new ReadOnlyPageException("Cannot create new pages in readonly mode");
        }
        if (this.pageCount >= 262144) {
            throw new ResourceExhaustedException("Memory cache cannot be bigger than 1GB.");
        }
        if (this.pageCount == 131072) {
            log.warn("Many pages for an in memory cache consider using a file cache instead cache_size='{} MB'", (Object)(((long)this.pageCount + 1L) * 4096L / 0x100000L));
        }
        if ((pageNumber = this.pageCount++) >= this.memPages.size()) {
            this.addPages();
        }
        Page page = this.memPages.get(pageNumber);
        page.setNumber(pageNumber);
        page.setState(PageState.LOADED);
        return page;
    }

    @Override
    public Page page(int pageNumber) {
        if (this.state == PageLoaderState.CLOSED) {
            throw MemoryPageLoader.cacheIsClosed();
        }
        if (pageNumber >= this.pageCount) {
            throw new InvalidPageException("The page " + pageNumber + " doesn't exist.");
        }
        return this.memPages.get(pageNumber);
    }

    @Override
    public void release(Page page) {
    }

    @NotNull
    private static InvalidCacheStateException cacheIsClosed() {
        return new InvalidCacheStateException("Memory Cache is closed");
    }
}

