/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import zeenea.connector.commons.cache.InvalidPageException;
import zeenea.connector.commons.cache.Page;
import zeenea.connector.commons.cache.PageLoader;
import zeenea.connector.commons.cache.TableDesc;

class HeaderPage {
    public static final int PAGE_NUMBER = 0;
    private static final byte[] MAGIC = "Zeenea Cache".getBytes(StandardCharsets.UTF_8);
    private static final int MAGIC_INDEX = 0;
    private static final int VERSION_INDEX = MAGIC.length;
    private static final int APP_VERSION_INDEX = VERSION_INDEX + 4;
    private static final int CACHE_DATE_INDEX = APP_VERSION_INDEX + 4;
    private static final int ROOT_TABLE_DESC_PAGE_INDEX = CACHE_DATE_INDEX + 8;
    static final int HEADER_LENGTH = ROOT_TABLE_DESC_PAGE_INDEX + 12;
    @NotNull
    private final PageLoader loader;

    private HeaderPage(@NotNull PageLoader pageLoader) {
        this.loader = pageLoader;
    }

    static HeaderPage of(@NotNull PageLoader pageLoader) {
        return new HeaderPage(pageLoader);
    }

    public boolean isCacheHeader() {
        return this.loader.testPage(0, page -> {
            byte[] magic = new byte[MAGIC.length];
            page.get(0, magic);
            return Arrays.equals(magic, MAGIC);
        });
    }

    public int version() {
        return this.loader.applyToPageAsInt(0, page -> page.getInt(VERSION_INDEX));
    }

    public int applicationVersion() {
        return this.loader.applyToPageAsInt(0, page -> page.getInt(APP_VERSION_INDEX));
    }

    public Instant cacheDate() {
        return this.loader.applyToPage(0, page -> Instant.ofEpochSecond(page.getLong(CACHE_DATE_INDEX)));
    }

    TableDesc rootTable() {
        return this.loader.applyToPage(0, page -> TableDesc.read(page, ROOT_TABLE_DESC_PAGE_INDEX));
    }

    void rootTable(TableDesc tableDesc) {
        this.loader.consumePage(0, page -> page.put(ROOT_TABLE_DESC_PAGE_INDEX, tableDesc.toByteBuffer()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(int version, int appVersion, Instant cacheDate) {
        Page page = this.loader.newPage();
        try {
            if (page.number() != 0) {
                throw new InvalidPageException("Header page should be the first to be created");
            }
            page.put(0, MAGIC);
            page.putInt(VERSION_INDEX, version);
            page.putInt(APP_VERSION_INDEX, appVersion);
            page.putLong(CACHE_DATE_INDEX, cacheDate.getEpochSecond());
            page.put(ROOT_TABLE_DESC_PAGE_INDEX, TableDesc.INVALID.toByteBuffer());
        }
        finally {
            this.loader.release(page);
        }
    }
}

