/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import org.jetbrains.annotations.Nullable;
import zeenea.connector.commons.cache.CacheData;
import zeenea.connector.commons.cache.Page;
import zeenea.connector.commons.cache.VarInt;

final class DataEntry {
    private static final int MIN_DATA_LENGTH = 128;
    private static final int MAX_DATA_LENGTH = 256;
    @Nullable
    private Integer entryIndex;
    private final VarInt length;

    private DataEntry(@Nullable Integer entryIndex, VarInt length) {
        this.entryIndex = entryIndex;
        this.length = length;
    }

    static DataEntry of(CacheData data) {
        return new DataEntry(null, VarInt.of(data.length()));
    }

    static DataEntry of(int dataLength) {
        return new DataEntry(null, VarInt.of(dataLength));
    }

    static DataEntry of(Page page, int entryIndex) {
        return new DataEntry(entryIndex, page.getVarInt(entryIndex));
    }

    boolean hasEntryIndex() {
        return this.entryIndex != null;
    }

    void setEntryIndex(int entryIndex) {
        this.entryIndex = entryIndex;
    }

    int entryIndex() {
        if (this.entryIndex == null) {
            throw new IllegalStateException("no entry index defined");
        }
        return this.entryIndex;
    }

    VarInt varLength() {
        return this.length;
    }

    int dataLength() {
        return this.length.intValue();
    }

    boolean overflow() {
        return this.dataLength() > 256;
    }

    int localDataLength() {
        return this.overflow() ? 128 : this.dataLength();
    }

    int localEntryLength() {
        return this.length.length() + this.moreLength() + this.localDataLength();
    }

    int moreRelativeIndex() {
        return this.length.length();
    }

    int moreLength() {
        return this.overflow() ? 6 : 0;
    }

    int moreIndex() {
        return this.entryIndex() + this.moreRelativeIndex();
    }

    int dataRelativeIndex() {
        return this.moreRelativeIndex() + this.moreLength();
    }

    int dataIndex() {
        return this.entryIndex() + this.dataRelativeIndex();
    }
}

