/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.util.function.Function;
import zeenea.connector.commons.cache.BTreeFindResult;
import zeenea.connector.commons.cache.BTreeLeafPage;
import zeenea.connector.commons.cache.BTreeLeafPointer;
import zeenea.connector.commons.cache.BTreeNodePage;
import zeenea.connector.commons.cache.BTreePage;
import zeenea.connector.commons.cache.BTreePointer;
import zeenea.connector.commons.cache.CacheData;
import zeenea.connector.commons.cache.CachePageLoader;

final class BTreeNodePointer
extends BTreePointer {
    private final BTreeNodePage page;

    BTreeNodePointer(CachePageLoader pageLoader, BTreeNodePage page, BTreeNodePointer parent, int entryNumber) {
        super(pageLoader, parent, entryNumber);
        this.page = page;
    }

    @Override
    boolean isLeaf() {
        return false;
    }

    @Override
    BTreeNodePage page() {
        return this.page;
    }

    @Override
    BTreeLeafPointer asLeaf() {
        throw new ClassCastException("Not a leaf");
    }

    @Override
    BTreeNodePointer asNode() {
        return this;
    }

    @Override
    BTreeLeafPointer findLeaf(CacheData key) {
        BTreeFindResult findResult = this.page.findEntry(key);
        int childPage = this.page.childPage(findResult.entryNumber());
        return this.loadAndRecurse(childPage, findResult.entryNumber(), n -> n.findLeaf(key));
    }

    @Override
    BTreeLeafPointer lastLeaf() {
        int childPage = this.page.lastChildPage();
        return this.loadAndRecurse(childPage, this.page.entryCount(), BTreeNodePointer::lastLeaf);
    }

    @Override
    BTreeLeafPointer firstLeaf() {
        int childPage = this.page.childPage(0);
        return this.loadAndRecurse(childPage, 0, BTreeNodePointer::firstLeaf);
    }

    BTreeLeafPointer loadAndRecurse(int childPageNum, int entryNumber, Function<BTreeNodePointer, BTreeLeafPointer> rec) {
        BTreePage childPage = this.pageLoader.page(childPageNum, BTreePage.class);
        if (childPage instanceof BTreeLeafPage) {
            return new BTreeLeafPointer(this.pageLoader, (BTreeLeafPage)childPage, this, entryNumber);
        }
        return rec.apply(new BTreeNodePointer(this.pageLoader, (BTreeNodePage)childPage, this, entryNumber));
    }

    BTreePointer child(int entryNumber) {
        int childPageNum = this.page.childPage(entryNumber);
        BTreePage childPage = this.pageLoader.page(childPageNum, BTreePage.class);
        if (childPage instanceof BTreeLeafPage) {
            return new BTreeLeafPointer(this.pageLoader, (BTreeLeafPage)childPage, this, entryNumber);
        }
        return new BTreeNodePointer(this.pageLoader, (BTreeNodePage)childPage, this, entryNumber);
    }

    BTreePointer futureChild(BTreePage page, int entryNumber) {
        if (page instanceof BTreeLeafPage) {
            return new BTreeLeafPointer(this.pageLoader, (BTreeLeafPage)page, this, entryNumber);
        }
        return new BTreeNodePointer(this.pageLoader, (BTreeNodePage)page, this, entryNumber);
    }

    public String toString() {
        if (this.isRoot()) {
            return String.format("BTreeNodePointer to %1$d (0x%1$x), no parent", this.page.pageNumber());
        }
        return String.format("BTreeNodePointer to %1$d (0x%1$x), %2$d @ parent %3$d (0x%3$x)", this.page.pageNumber(), this.entryNumber(), this.parent().page().pageNumber());
    }
}

