/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.cache;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import zeenea.connector.commons.cache.BTreeEntry;
import zeenea.connector.commons.cache.BTreeNodeEntry;
import zeenea.connector.commons.cache.BTreePage;
import zeenea.connector.commons.cache.ByteIterator;
import zeenea.connector.commons.cache.CacheAddress;
import zeenea.connector.commons.cache.CacheData;
import zeenea.connector.commons.cache.CachePageLoader;
import zeenea.connector.commons.cache.DataEntry;
import zeenea.connector.commons.cache.Page;
import zeenea.connector.commons.cache.ResourceExhaustedException;

final class BTreeNodePage
extends BTreePage {
    private static final int ENTRY_COUNT_INDEX = 1;
    private static final int ENTRY_DATA_ZONE_INDEX = 3;
    private static final int LAST_CHILD_PAGE_NUMBER = 5;
    private static final int ENTRY_LIST_INDEX = 9;

    private BTreeNodePage(CachePageLoader pageLoader, int pageNumber) {
        super(pageLoader, pageNumber);
    }

    static BTreeNodePage of(CachePageLoader pageLoader, int pageNumber) {
        return new BTreeNodePage(pageLoader, pageNumber);
    }

    public static BTreeNodePage init(CachePageLoader pageLoader, Page page) {
        BTreeNodePage nodePage = new BTreeNodePage(pageLoader, page.number());
        page.put(0, (byte)78);
        page.putShort(1, (short)0);
        page.putShort(3, (short)4096);
        page.putInt(5, -1);
        return nodePage;
    }

    @Override
    byte code() {
        return 78;
    }

    @Override
    boolean isLeaf() {
        return false;
    }

    @Override
    boolean isLast(int entryNumber) {
        return entryNumber == this.entryCount();
    }

    @Override
    int entryCount() {
        return this.applyToPageAsInt(this::entryCount);
    }

    @Override
    protected int entryCount(Page page) {
        return page.getShort(1) & 0xFFFF;
    }

    @Override
    protected void setEntryCount(Page page, int value) {
        page.putShort(1, (short)value);
    }

    @Override
    protected int entryDataZone(Page page) {
        return page.getShort(3) & 0xFFFF;
    }

    @Override
    protected void setEntryDataZone(Page page, int value) {
        page.putShort(3, (short)value);
    }

    @Override
    protected int entryPointerIndex(int entryNumber) {
        return 9 + entryNumber * 2;
    }

    @Override
    @NotNull
    protected CacheData key(Page page, int entryNumber) {
        this.checkEntryNumber(page, entryNumber, true);
        int entryIndex = this.entryIndex(page, entryNumber);
        return CacheData.of(this, DataEntry.of(page, entryIndex));
    }

    int lastChildPage() {
        return this.applyToPageAsInt(page -> page.getInt(5));
    }

    public void setLastChildPage(int pageNumber) {
        this.consumePage(page -> page.putInt(5, pageNumber));
    }

    int childPage(int entryNumber) {
        return this.applyToPageAsInt(page -> this.childPage((Page)page, entryNumber));
    }

    private int childPage(Page page, int entryNumber) {
        this.checkEntryNumber(page, entryNumber, false);
        if (entryNumber == this.entryCount(page)) {
            return this.lastChildPage();
        }
        int entryIndex = this.entryIndex(page, entryNumber);
        BTreeNodeEntry entry = BTreeNodeEntry.of(page, entryIndex);
        return page.getInt(entry.childIndex());
    }

    void setChild(BTreeNodeEntry entry, int child) {
        this.consumePage(page -> this.setChild((Page)page, entry, child));
    }

    private void setChild(Page page, BTreeNodeEntry entry, int child) {
        page.putInt(entry.childIndex(), child);
    }

    @Override
    BTreeNodeEntry entry(int entryNumber) {
        return this.applyToPage(page -> this.entry((Page)page, entryNumber));
    }

    @Override
    protected BTreeNodeEntry entry(Page page, int entryNumber) {
        int entryIndex = this.entryIndex(page, entryNumber);
        return BTreeNodeEntry.of(page, entryIndex);
    }

    int splitTo(BTreeNodePage target) {
        return this.applyToPageAsInt(page -> {
            int pivot = this.entryCount((Page)page) / 2;
            this.copyTo((Page)page, target, pivot + 1);
            target.setLastChildPage(this.lastChildPage());
            this.setLastChildPage(this.childPage((Page)page, pivot));
            this.compact((Page)page, pivot);
            return pivot + 1;
        });
    }

    public void updateKey(int entryNumber, CacheAddress more, ByteIterator keyData) {
        this.consumePage(page -> {
            this.checkEntryNumber((Page)page, entryNumber, true);
            BTreeNodeEntry updatedEntry = this.entry((Page)page, entryNumber);
            BTreeNodeEntry sourceEntry = BTreeNodeEntry.of(keyData.remaining());
            if (this.freeSpace((Page)page) < sourceEntry.localEntryLength() - updatedEntry.localEntryLength()) {
                throw new ResourceExhaustedException("Not enough free space");
            }
            int entryIndex = updatedEntry.entryIndex();
            int updatedChild = page.getInt(updatedEntry.childIndex());
            int count = this.entryCount((Page)page);
            ArrayList<Integer> entryNumbers = new ArrayList<Integer>(count);
            ArrayList<BTreeEntry> entries = new ArrayList<BTreeEntry>(count);
            for (int i = 0; i < count; ++i) {
                int idx = this.entryIndex((Page)page, i);
                if (idx < entryIndex) {
                    entryNumbers.add(i);
                    entries.add(BTreeNodeEntry.of(page, idx));
                    continue;
                }
                entries.add(null);
            }
            this.doCompact((Page)page, (List<Integer>)entryNumbers, (List<BTreeEntry>)entries, entryIndex + updatedEntry.localEntryLength());
            int entryDataZone = this.entryDataZone((Page)page);
            page.zero(this.entryPointerIndex(count), entryDataZone);
            int newEntryIndex = this.entryDataZone((Page)page) - sourceEntry.localEntryLength();
            sourceEntry.setEntryIndex(newEntryIndex);
            page.putShort(this.entryPointerIndex(entryNumber), (short)newEntryIndex);
            this.writeLocalData(sourceEntry.keyEntry(), more, keyData);
            this.setChild((Page)page, sourceEntry, updatedChild);
            this.setEntryDataZone((Page)page, newEntryIndex);
        });
    }

    public String toString() {
        return String.format("BTreeNodePage %1$d (0x%1$x) with %2$d entries", this.pageNumber(), this.entryCount());
    }
}

