/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.util;

import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import zeenea.connector.commons.log.SimpleLogger;
import zeenea.connector.commons.log.TracingContext;

public class FieldUtil {
    private static final SimpleLogger log = SimpleLogger.of(FieldUtil.class);

    @NotNull
    public static <T> String from(TracingContext ctx, List<T> allFields, T currentField, Function<T, String> getFieldName) {
        String currentColumnName = getFieldName.apply(currentField);
        if (allFields.stream().filter(f -> ((String)getFieldName.apply(f)).equals(currentColumnName)).count() == 1L) {
            return currentColumnName;
        }
        long currentIndex = allFields.stream().filter(f -> ((String)getFieldName.apply(f)).equals(currentColumnName)).takeWhile(f -> f != currentField).count() + 1L;
        log.entry("field_util_duplicate_column_name").context(ctx).with("column_name", currentColumnName).with("appending_index", currentIndex).warn();
        return currentColumnName + "_" + currentIndex;
    }
}

