/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.crypto;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

public class Hash {
    private static final Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();

    public static String sha256(String input) {
        return Hash.hash("SHA-256", input);
    }

    public static String sha512(String input) {
        return Hash.hash("SHA-512", input);
    }

    private static String hash(String algo, String input) {
        try {
            byte[] bytes = input.getBytes(StandardCharsets.UTF_8);
            byte[] digest = MessageDigest.getInstance(algo).digest(bytes);
            byte[] base64 = encoder.encode(digest);
            return new String(base64, StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to find algorithm " + algo, e);
        }
    }
}

