/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.codegen;

import com.sforce.ws.ConnectionException;
import com.sforce.ws.bind.NameMapper;
import com.sforce.ws.bind.TypeMapper;
import com.sforce.ws.codegen.metadata.ConnectionClassMetadata;
import com.sforce.ws.codegen.metadata.ElementMetadata;
import com.sforce.ws.codegen.metadata.HeaderMetadata;
import com.sforce.ws.codegen.metadata.OperationMetadata;
import com.sforce.ws.util.FileUtil;
import com.sforce.ws.wsdl.BindingOperation;
import com.sforce.ws.wsdl.Collection;
import com.sforce.ws.wsdl.ComplexType;
import com.sforce.ws.wsdl.Definitions;
import com.sforce.ws.wsdl.Element;
import com.sforce.ws.wsdl.Message;
import com.sforce.ws.wsdl.Operation;
import com.sforce.ws.wsdl.Part;
import com.sforce.ws.wsdl.Schema;
import com.sforce.ws.wsdl.SfdcApiType;
import com.sforce.ws.wsdl.SoapHeader;
import com.sforce.ws.wsdl.Types;
import com.sforce.ws.wsdl.WsdlNode;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class ConnectionMetadataConstructor {
    private final String className;
    private final String packageName;
    private final Definitions definitions;
    protected final TypeMapper typeMapper;
    protected final boolean addDeprecatedAnnotation;

    public ConnectionMetadataConstructor(Definitions definitions, TypeMapper typeMapper, String packagePrefix) {
        this(definitions, typeMapper, packagePrefix, false);
    }

    public ConnectionMetadataConstructor(Definitions definitions, TypeMapper typeMapper, String packagePrefix, boolean addDeprecatedAnnotation) {
        this.definitions = definitions;
        this.typeMapper = typeMapper;
        this.className = (definitions.getApiType() != null ? definitions.getApiType().name() : "Soap") + "Connection";
        this.packageName = NameMapper.getPackageName(definitions.getTargetNamespace(), packagePrefix);
        this.addDeprecatedAnnotation = addDeprecatedAnnotation;
    }

    static String convertJavaClassToInterface(String javaClassName, boolean isComplexType) {
        if (!isComplexType) {
            return javaClassName;
        }
        int i = javaClassName.lastIndexOf(".");
        return javaClassName.substring(0, i + 1) + "I" + javaClassName.substring(i + 1);
    }

    public ConnectionClassMetadata getConnectionClassMetadata() {
        try {
            Element element;
            Iterator<Element> j;
            ArrayList<HeaderMetadata.HeaderElementMetadata> elements;
            ArrayList<HeaderMetadata> headers = new ArrayList<HeaderMetadata>();
            ArrayList<OperationMetadata> operations = new ArrayList<OperationMetadata>();
            Iterator<WsdlNode> i = this.headers();
            while (i.hasNext()) {
                Part header = i.next();
                elements = new ArrayList<HeaderMetadata.HeaderElementMetadata>();
                j = this.headerElements(header);
                while (j.hasNext()) {
                    element = j.next();
                    elements.add(HeaderMetadata.HeaderElementMetadata.newInstance(this.argSetMethod(element), this.argName(element)));
                }
                headers.add(HeaderMetadata.newInstance(this.headerType(header), this.headerName(header), this.headerArgs(header), this.headerElement(header), elements));
            }
            i = this.getOperations();
            while (i.hasNext()) {
                Operation operation = (Operation)i.next();
                elements = new ArrayList();
                j = this.argElements(operation);
                while (j.hasNext()) {
                    element = j.next();
                    elements.add((HeaderMetadata.HeaderElementMetadata)((Object)ElementMetadata.newInstance(this.argSetMethod(element), this.argName(element))));
                }
                ArrayList<HeaderMetadata> operationHeaders = new ArrayList<HeaderMetadata>();
                Iterator<Part> j2 = this.headersFor(operation);
                while (j2.hasNext()) {
                    Part part = j2.next();
                    operationHeaders.add(HeaderMetadata.newInstance(null, this.headerName(part), null, this.headerElement(part), null));
                }
                operations.add(OperationMetadata.newInstance(this.returnType(operation), this.getOperationName(operation), this.requestType(operation), this.responseType(operation), this.getArgs(operation, ArgListTypesToGenerate.CLASSES), this.getArgs(operation, ArgListTypesToGenerate.NONE), this.getArgs(operation, ArgListTypesToGenerate.INTERFACE), this.getArgs(operation, ArgListTypesToGenerate.CAST_TO_CLASSES), this.soapAction(operation), this.requestName(operation), this.responseName(operation), this.getResultCall(operation), elements, operationHeaders, this.isReturnTypeComplexType(operation), this.returnTypeInterface(operation)));
            }
            ConnectionClassMetadata connectionClassMetadata = new ConnectionClassMetadata(this.getPackagePrefix(), this.packageName, this.className, this.hasLoginCall(), this.verifyEndpoint(), this.hasLoginCall() ? this.loginResult() : null, this.hasSessionHeader(), this.sobjectNamespace(), this.dumpQNames(), this.dumpKnownHeaders(), headers, operations, this.addDeprecatedAnnotation);
            return connectionClassMetadata;
        }
        catch (ConnectionException e) {
            throw new IllegalStateException(e);
        }
    }

    protected String returnTypeInterface(Operation operation) throws ConnectionException {
        return ConnectionMetadataConstructor.convertJavaClassToInterface(this.returnType(operation), this.isReturnTypeComplexType(operation));
    }

    protected boolean isReturnTypeComplexType(Operation operation) throws ConnectionException {
        Element el = this.getResponseElement(operation);
        return el != null && this.isComplexType(el);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String endpoint() {
        return this.definitions.getService().getPort().getSoapAddress().getLocation();
    }

    public String verifyEndpoint() {
        return this.definitions.getApiType() == null ? null : this.definitions.getApiType().getVerifyEndpoint();
    }

    public String getPackagePrefix() {
        String prefix = this.typeMapper.getPackagePrefix();
        return prefix == null ? "null" : "\"" + prefix + "\"";
    }

    public String getTargetNamespace() {
        return this.definitions.getTargetNamespace();
    }

    public String sobjectNamespace() {
        if (this.definitions.getApiType() == SfdcApiType.Tooling && !this.hasSobjectNamespace(this.definitions)) {
            return "\"" + this.definitions.getApiType().getNamespace() + "\"";
        }
        return this.definitions.getApiType() == null ? "null" : "\"" + this.definitions.getApiType().getSobjectNamespace() + "\"";
    }

    private boolean hasSobjectNamespace(Definitions definitions) {
        for (Schema schema : definitions.getTypes().getSchemas()) {
            if (!definitions.getApiType().getSobjectNamespace().equals(schema.getTargetNamespace())) continue;
            return true;
        }
        return false;
    }

    public String dumpQNames() throws ConnectionException {
        StringBuilder sb = new StringBuilder();
        Iterator<Operation> oit = this.definitions.getPortType().getOperations();
        while (oit.hasNext()) {
            Operation operation = oit.next();
            Part in = operation.getInput().getParts().next();
            this.addQName(sb, in.getElement());
            Part out = operation.getOutput().getParts().next();
            this.addQName(sb, out.getElement());
        }
        Iterator<Part> parts = this.headers();
        while (parts.hasNext()) {
            Part hp = parts.next();
            this.addQName(sb, hp.getElement());
        }
        return sb.toString();
    }

    public String dumpKnownHeaders() throws ConnectionException {
        StringBuilder sb = new StringBuilder();
        Iterator<Part> parts = this.headers();
        while (parts.hasNext()) {
            Part hp = parts.next();
            String varName = this.qname(hp.getElement().getLocalPart());
            sb.append("  knownHeaders.put(");
            sb.append(varName).append(",");
            sb.append(this.headerType(hp)).append(".class");
            sb.append(");").append(FileUtil.EOL);
        }
        return sb.toString();
    }

    private boolean isSimpleType(Part header) throws ConnectionException {
        Types types = this.definitions.getTypes();
        Element element = types.getElement(header.getElement());
        if (!element.isComplexType()) {
            return true;
        }
        return this.typeMapper.isWellKnownType(element.getType().getNamespaceURI(), element.getType().getLocalPart());
    }

    public String headerName(Part header) {
        return header.getName();
    }

    public String headerElement(Part header) throws ConnectionException {
        return this.qname(header.getElement().getLocalPart());
    }

    private void addQName(StringBuilder sb, QName el) {
        sb.append("    private static final javax.xml.namespace.QName ");
        sb.append(this.qname(el.getLocalPart()));
        sb.append(" = new javax.xml.namespace.QName(\"");
        sb.append(el.getNamespaceURI());
        sb.append("\", \"");
        sb.append(el.getLocalPart());
        sb.append("\");");
        sb.append(FileUtil.EOL);
    }

    public boolean hasLoginCall() {
        return this.definitions.getApiType() != null && this.definitions.getApiType().hasLoginCall();
    }

    private String qname(String str) {
        return str + "_qname";
    }

    public boolean hasSessionHeader() throws ConnectionException {
        Iterator<Part> it = this.headers();
        while (it.hasNext()) {
            Part part = it.next();
            if (!part.getName().equals("SessionHeader")) continue;
            return true;
        }
        return false;
    }

    public Iterator<Part> headersFor(Operation operation) throws ConnectionException {
        BindingOperation bop = this.definitions.getBinding().getOperation(operation.getName());
        ArrayList<Part> parts = new ArrayList<Part>();
        Iterator<SoapHeader> hit = bop.getInput().getHeaders();
        while (hit.hasNext()) {
            SoapHeader sh = hit.next();
            parts.add(this.definitions.getMessage(sh.getMessage()).getPart(sh.getPart()));
        }
        return parts.iterator();
    }

    public Iterator<Part> headers() throws ConnectionException {
        return this.definitions.getBinding().getAllHeaders();
    }

    public String headerType(Part header) throws ConnectionException {
        if (this.isSimpleType(header)) {
            return "java.lang.String";
        }
        ComplexType type = this.getType(header);
        QName qn = new QName(type.getSchema().getTargetNamespace(), type.getName());
        return this.typeMapper.getJavaClassName(qn, this.definitions.getTypes(), false);
    }

    public String getResultCall(Operation operation) throws ConnectionException {
        Element el = this.getResponseElement(operation);
        if (el == null) {
            return "";
        }
        return "return __response.get" + NameMapper.getMethodName(el.getName()) + "();";
    }

    public String soapAction(Operation operation) throws ConnectionException {
        BindingOperation bop = this.definitions.getBinding().getOperation(operation.getName());
        String soapAction = bop.getSoapAction();
        return "\"" + soapAction + "\"";
    }

    public String returnType(Operation operation) throws ConnectionException {
        Element el = this.getResponseElement(operation);
        if (el == null) {
            return "void";
        }
        return this.getJavaClassName(el, true);
    }

    public Element getResponseElement(Operation operation) throws ConnectionException {
        Element result;
        ComplexType ct = this.getType(operation.getOutput());
        Collection sequence = ct.getContent();
        if (sequence == null) {
            return null;
        }
        Iterator<Element> eit = sequence.getElements();
        if (eit.hasNext()) {
            result = eit.next();
            if (eit.hasNext()) {
                throw new IllegalArgumentException("Operation.output got more than one element:" + operation);
            }
        } else {
            result = null;
        }
        return result;
    }

    public String headerArgs(Part header) throws ConnectionException {
        Iterator<Element> eit = this.headerElements(header);
        return this.toArgs(eit, ArgListTypesToGenerate.CLASSES);
    }

    public Iterator<Element> headerElements(Part header) throws ConnectionException {
        if (this.isSimpleType(header)) {
            ArrayList list = new ArrayList();
            return list.iterator();
        }
        ComplexType ct = this.getType(header);
        Collection sequence = ct.getContent();
        return sequence.getElements();
    }

    public String getArgs(Operation operation, ArgListTypesToGenerate types) throws ConnectionException {
        Iterator<Element> eit = this.argElements(operation);
        return this.toArgs(eit, types);
    }

    private String toArgs(Iterator<Element> eit, ArgListTypesToGenerate types) {
        StringBuilder sb = new StringBuilder();
        while (eit.hasNext()) {
            boolean appendedArgName = false;
            Element el = eit.next();
            if (types == ArgListTypesToGenerate.INTERFACE) {
                sb.append(this.getJavaInterfaceName(el));
            } else if (types == ArgListTypesToGenerate.CLASSES) {
                sb.append(this.getJavaClassName(el, true));
            } else if (types == ArgListTypesToGenerate.CAST_TO_CLASSES && this.isComplexType(el)) {
                if (this.isArray(el)) {
                    sb.append("castArray(").append(this.getJavaClassName(el, false)).append(".class, ").append(this.argName(el)).append(")");
                    appendedArgName = true;
                } else {
                    sb.append("(").append(this.getJavaClassName(el, true)).append(")");
                }
            }
            if (!appendedArgName) {
                sb.append(" ").append(this.argName(el));
            }
            if (!eit.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public String argSetMethod(Element element) {
        return "set" + NameMapper.getMethodName(element.getName());
    }

    public String argName(Element element) {
        return element.getName();
    }

    public Iterator<Element> argElements(Operation operation) throws ConnectionException {
        ComplexType ct = this.getType(operation.getInput());
        Collection sequence = ct.getContent();
        return sequence == null ? new ArrayList().iterator() : sequence.getElements();
    }

    public String getJavaClassName(Element el, boolean addBracketsForArray) {
        String clazz = this.typeMapper.getJavaClassName(el.getType(), this.definitions.getTypes(), el.isNillable());
        if (addBracketsForArray && this.isArray(el)) {
            clazz = clazz + "[]";
        }
        return clazz;
    }

    public boolean isArray(Element el) {
        return el.getMaxOccurs() != 1;
    }

    protected String getJavaInterfaceName(Element el) {
        String clazz = this.getJavaClassName(el, true);
        return ConnectionMetadataConstructor.convertJavaClassToInterface(clazz, this.isComplexType(el));
    }

    public boolean isComplexType(Element el) {
        return this.definitions.getTypes().getComplexTypeAllowNull(el.getType()) != null;
    }

    public String loginResult() throws ConnectionException {
        QName ln = new QName(this.definitions.getTargetNamespace(), "login");
        Operation op = this.definitions.getPortType().getOperation(ln);
        return this.returnType(op);
    }

    public String responseName(Operation operation) throws ConnectionException {
        return this.qname(operation.getOutput().getParts().next().getElement().getLocalPart());
    }

    public String requestName(Operation operation) throws ConnectionException {
        return this.qname(operation.getInput().getParts().next().getElement().getLocalPart());
    }

    public String responseType(Operation operation) throws ConnectionException {
        ComplexType ct = this.getType(operation.getOutput());
        QName type = new QName(ct.getSchema().getTargetNamespace(), ct.getName());
        return this.typeMapper.getJavaClassName(type, this.definitions.getTypes(), false);
    }

    public String requestType(Operation operation) throws ConnectionException {
        ComplexType ct = this.getType(operation.getInput());
        QName type = new QName(ct.getSchema().getTargetNamespace(), ct.getName());
        return this.typeMapper.getJavaClassName(type, this.definitions.getTypes(), false);
    }

    private ComplexType getType(Message message) throws ConnectionException {
        Iterator<Part> it = message.getParts();
        if (!it.hasNext()) {
            throw new IllegalArgumentException("Input for operation " + message + " does not have a part");
        }
        Part part = it.next();
        if (it.hasNext()) {
            throw new IllegalArgumentException("Found more than one part for operation " + message);
        }
        return this.getType(part);
    }

    private ComplexType getType(Part part) throws ConnectionException {
        Types types = this.definitions.getTypes();
        Element element = types.getElement(part.getElement());
        QName type = element.getType();
        return types.getComplexType(type);
    }

    public Iterator<Operation> getOperations() {
        return this.definitions.getPortType().getOperations();
    }

    public String getOperationName(Operation operation) {
        return operation.getName().getLocalPart();
    }

    protected static enum ArgListTypesToGenerate {
        NONE,
        CLASSES,
        INTERFACE,
        CAST_TO_CLASSES;

    }
}

