package zeenea.connector.qlik.cloud.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Table}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTable.builder()}.
 */
@Generated(from = "Table", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableTable implements Table {
  private final String name;
  private final @Nullable String comment;
  private final @Nullable Integer numberOfRows;
  private final @Nullable Boolean system;
  private final @Nullable Integer byteSize;

  private ImmutableTable(
      String name,
      @Nullable String comment,
      @Nullable Integer numberOfRows,
      @Nullable Boolean system,
      @Nullable Integer byteSize) {
    this.name = name;
    this.comment = comment;
    this.numberOfRows = numberOfRows;
    this.system = system;
    this.byteSize = byteSize;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code comment} attribute
   */
  @JsonProperty("comment")
  @Override
  public @Nullable String comment() {
    return comment;
  }

  /**
   * @return The value of the {@code numberOfRows} attribute
   */
  @JsonProperty("no_of_rows")
  @Override
  public @Nullable Integer numberOfRows() {
    return numberOfRows;
  }

  /**
   * @return The value of the {@code system} attribute
   */
  @JsonProperty("is_system")
  @Override
  public @Nullable Boolean isSystem() {
    return system;
  }

  /**
   * @return The value of the {@code byteSize} attribute
   */
  @JsonProperty("byte_size")
  @Override
  public @Nullable Integer byteSize() {
    return byteSize;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableTable(newValue, this.comment, this.numberOfRows, this.system, this.byteSize);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#comment() comment} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for comment (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withComment(@Nullable String value) {
    if (Objects.equals(this.comment, value)) return this;
    return new ImmutableTable(this.name, value, this.numberOfRows, this.system, this.byteSize);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#numberOfRows() numberOfRows} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for numberOfRows (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withNumberOfRows(@Nullable Integer value) {
    if (Objects.equals(this.numberOfRows, value)) return this;
    return new ImmutableTable(this.name, this.comment, value, this.system, this.byteSize);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#isSystem() system} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for system (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withSystem(@Nullable Boolean value) {
    if (Objects.equals(this.system, value)) return this;
    return new ImmutableTable(this.name, this.comment, this.numberOfRows, value, this.byteSize);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Table#byteSize() byteSize} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for byteSize (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTable withByteSize(@Nullable Integer value) {
    if (Objects.equals(this.byteSize, value)) return this;
    return new ImmutableTable(this.name, this.comment, this.numberOfRows, this.system, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTable
        && equalTo(0, (ImmutableTable) another);
  }

  private boolean equalTo(int synthetic, ImmutableTable another) {
    return name.equals(another.name)
        && Objects.equals(comment, another.comment)
        && Objects.equals(numberOfRows, another.numberOfRows)
        && Objects.equals(system, another.system)
        && Objects.equals(byteSize, another.byteSize);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code comment}, {@code numberOfRows}, {@code system}, {@code byteSize}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(comment);
    h += (h << 5) + Objects.hashCode(numberOfRows);
    h += (h << 5) + Objects.hashCode(system);
    h += (h << 5) + Objects.hashCode(byteSize);
    return h;
  }

  /**
   * Prints the immutable value {@code Table} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Table{"
        + "name=" + name
        + ", comment=" + comment
        + ", numberOfRows=" + numberOfRows
        + ", system=" + system
        + ", byteSize=" + byteSize
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Table", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Table {
    @javax.annotation.Nullable String name;
    @javax.annotation.Nullable String comment;
    @javax.annotation.Nullable Integer numberOfRows;
    @javax.annotation.Nullable Boolean system;
    @javax.annotation.Nullable Integer byteSize;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("comment")
    public void setComment(@Nullable String comment) {
      this.comment = comment;
    }
    @JsonProperty("no_of_rows")
    public void setNumberOfRows(@Nullable Integer numberOfRows) {
      this.numberOfRows = numberOfRows;
    }
    @JsonProperty("is_system")
    public void setSystem(@Nullable Boolean system) {
      this.system = system;
    }
    @JsonProperty("byte_size")
    public void setByteSize(@Nullable Integer byteSize) {
      this.byteSize = byteSize;
    }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public String comment() { throw new UnsupportedOperationException(); }
    @Override
    public Integer numberOfRows() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean isSystem() { throw new UnsupportedOperationException(); }
    @Override
    public Integer byteSize() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTable fromJson(Json json) {
    ImmutableTable.Builder builder = ImmutableTable.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.comment != null) {
      builder.comment(json.comment);
    }
    if (json.numberOfRows != null) {
      builder.numberOfRows(json.numberOfRows);
    }
    if (json.system != null) {
      builder.system(json.system);
    }
    if (json.byteSize != null) {
      builder.byteSize(json.byteSize);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Table} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Table instance
   */
  public static ImmutableTable copyOf(Table instance) {
    if (instance instanceof ImmutableTable) {
      return (ImmutableTable) instance;
    }
    return ImmutableTable.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTable ImmutableTable}.
   * <pre>
   * ImmutableTable.builder()
   *    .name(String) // required {@link Table#name() name}
   *    .comment(String | null) // nullable {@link Table#comment() comment}
   *    .numberOfRows(Integer | null) // nullable {@link Table#numberOfRows() numberOfRows}
   *    .system(Boolean | null) // nullable {@link Table#isSystem() system}
   *    .byteSize(Integer | null) // nullable {@link Table#byteSize() byteSize}
   *    .build();
   * </pre>
   * @return A new ImmutableTable builder
   */
  public static ImmutableTable.Builder builder() {
    return new ImmutableTable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTable ImmutableTable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Table", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private @javax.annotation.Nullable String name;
    private @javax.annotation.Nullable String comment;
    private @javax.annotation.Nullable Integer numberOfRows;
    private @javax.annotation.Nullable Boolean system;
    private @javax.annotation.Nullable Integer byteSize;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Table} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Table instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.name());
      @Nullable String commentValue = instance.comment();
      if (commentValue != null) {
        comment(commentValue);
      }
      @Nullable Integer numberOfRowsValue = instance.numberOfRows();
      if (numberOfRowsValue != null) {
        numberOfRows(numberOfRowsValue);
      }
      @Nullable Boolean systemValue = instance.isSystem();
      if (systemValue != null) {
        system(systemValue);
      }
      @Nullable Integer byteSizeValue = instance.byteSize();
      if (byteSizeValue != null) {
        byteSize(byteSizeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Table#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#comment() comment} attribute.
     * @param comment The value for comment (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("comment")
    public final Builder comment(@Nullable String comment) {
      this.comment = comment;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#numberOfRows() numberOfRows} attribute.
     * @param numberOfRows The value for numberOfRows (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("no_of_rows")
    public final Builder numberOfRows(@Nullable Integer numberOfRows) {
      this.numberOfRows = numberOfRows;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#isSystem() system} attribute.
     * @param system The value for system (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("is_system")
    public final Builder system(@Nullable Boolean system) {
      this.system = system;
      return this;
    }

    /**
     * Initializes the value for the {@link Table#byteSize() byteSize} attribute.
     * @param byteSize The value for byteSize (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("byte_size")
    public final Builder byteSize(@Nullable Integer byteSize) {
      this.byteSize = byteSize;
      return this;
    }

    /**
     * Builds a new {@link ImmutableTable ImmutableTable}.
     * @return An immutable instance of Table
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTable build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTable(name, comment, numberOfRows, system, byteSize);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Table, some of required attributes are not set " + attributes;
    }
  }
}
