package zeenea.connector.qlik.cloud.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Schema}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSchema.builder()}.
 */
@Generated(from = "Schema", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableSchema implements Schema {
  private final Table table;
  private final Field field;

  private ImmutableSchema(
      Table table,
      Field field) {
    this.table = table;
    this.field = field;
  }

  /**
   * @return The value of the {@code table} attribute
   */
  @JsonProperty("table")
  @Override
  public Table table() {
    return table;
  }

  /**
   * @return The value of the {@code field} attribute
   */
  @JsonProperty("field")
  @Override
  public Field field() {
    return field;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Schema#table() table} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for table
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSchema withTable(Table value) {
    if (this.table == value) return this;
    Table newValue = Objects.requireNonNull(value, "table");
    return new ImmutableSchema(newValue, this.field);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Schema#field() field} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for field
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSchema withField(Field value) {
    if (this.field == value) return this;
    Field newValue = Objects.requireNonNull(value, "field");
    return new ImmutableSchema(this.table, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSchema} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSchema
        && equalTo(0, (ImmutableSchema) another);
  }

  private boolean equalTo(int synthetic, ImmutableSchema another) {
    return table.equals(another.table)
        && field.equals(another.field);
  }

  /**
   * Computes a hash code from attributes: {@code table}, {@code field}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + table.hashCode();
    h += (h << 5) + field.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Schema} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Schema{"
        + "table=" + table
        + ", field=" + field
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Schema", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Schema {
    @Nullable Table table;
    @Nullable Field field;
    @JsonProperty("table")
    public void setTable(Table table) {
      this.table = table;
    }
    @JsonProperty("field")
    public void setField(Field field) {
      this.field = field;
    }
    @Override
    public Table table() { throw new UnsupportedOperationException(); }
    @Override
    public Field field() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSchema fromJson(Json json) {
    ImmutableSchema.Builder builder = ImmutableSchema.builder();
    if (json.table != null) {
      builder.table(json.table);
    }
    if (json.field != null) {
      builder.field(json.field);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Schema} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Schema instance
   */
  public static ImmutableSchema copyOf(Schema instance) {
    if (instance instanceof ImmutableSchema) {
      return (ImmutableSchema) instance;
    }
    return ImmutableSchema.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSchema ImmutableSchema}.
   * <pre>
   * ImmutableSchema.builder()
   *    .table(zeenea.connector.qlik.cloud.client.model.Table) // required {@link Schema#table() table}
   *    .field(zeenea.connector.qlik.cloud.client.model.Field) // required {@link Schema#field() field}
   *    .build();
   * </pre>
   * @return A new ImmutableSchema builder
   */
  public static ImmutableSchema.Builder builder() {
    return new ImmutableSchema.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSchema ImmutableSchema}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Schema", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TABLE = 0x1L;
    private static final long INIT_BIT_FIELD = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Table table;
    private @Nullable Field field;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Schema} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Schema instance) {
      Objects.requireNonNull(instance, "instance");
      this.table(instance.table());
      this.field(instance.field());
      return this;
    }

    /**
     * Initializes the value for the {@link Schema#table() table} attribute.
     * @param table The value for table 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("table")
    public final Builder table(Table table) {
      this.table = Objects.requireNonNull(table, "table");
      initBits &= ~INIT_BIT_TABLE;
      return this;
    }

    /**
     * Initializes the value for the {@link Schema#field() field} attribute.
     * @param field The value for field 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("field")
    public final Builder field(Field field) {
      this.field = Objects.requireNonNull(field, "field");
      initBits &= ~INIT_BIT_FIELD;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSchema ImmutableSchema}.
     * @return An immutable instance of Schema
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSchema build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSchema(table, field);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TABLE) != 0) attributes.add("table");
      if ((initBits & INIT_BIT_FIELD) != 0) attributes.add("field");
      return "Cannot build Schema, some of required attributes are not set " + attributes;
    }
  }
}
