package zeenea.connector.qlik.cloud.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Node}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNode.builder()}.
 */
@Generated(from = "Node", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableNode implements Node {
  private final String label;

  private ImmutableNode(String label) {
    this.label = label;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @JsonProperty("label")
  @Override
  public String label() {
    return label;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Node#label() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNode withLabel(String value) {
    String newValue = Objects.requireNonNull(value, "label");
    if (this.label.equals(newValue)) return this;
    return new ImmutableNode(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNode} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNode
        && equalTo(0, (ImmutableNode) another);
  }

  private boolean equalTo(int synthetic, ImmutableNode another) {
    return label.equals(another.label);
  }

  /**
   * Computes a hash code from attributes: {@code label}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + label.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Node} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Node{"
        + "label=" + label
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Node", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Node {
    @Nullable String label;
    @JsonProperty("label")
    public void setLabel(String label) {
      this.label = label;
    }
    @Override
    public String label() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableNode fromJson(Json json) {
    ImmutableNode.Builder builder = ImmutableNode.builder();
    if (json.label != null) {
      builder.label(json.label);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Node} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Node instance
   */
  public static ImmutableNode copyOf(Node instance) {
    if (instance instanceof ImmutableNode) {
      return (ImmutableNode) instance;
    }
    return ImmutableNode.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNode ImmutableNode}.
   * <pre>
   * ImmutableNode.builder()
   *    .label(String) // required {@link Node#label() label}
   *    .build();
   * </pre>
   * @return A new ImmutableNode builder
   */
  public static ImmutableNode.Builder builder() {
    return new ImmutableNode.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNode ImmutableNode}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Node", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_LABEL = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String label;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Node} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Node instance) {
      Objects.requireNonNull(instance, "instance");
      this.label(instance.label());
      return this;
    }

    /**
     * Initializes the value for the {@link Node#label() label} attribute.
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("label")
    public final Builder label(String label) {
      this.label = Objects.requireNonNull(label, "label");
      initBits &= ~INIT_BIT_LABEL;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNode ImmutableNode}.
     * @return An immutable instance of Node
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNode build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNode(label);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LABEL) != 0) attributes.add("label");
      return "Cannot build Node, some of required attributes are not set " + attributes;
    }
  }
}
