package zeenea.connector.qlik.cloud.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link ItemDetails}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableItemDetails.builder()}.
 */
@Generated(from = "ItemDetails", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableItemDetails implements ItemDetails {
  private final @Nullable String name;
  private final @Nullable String resourceId;
  private final @Nullable String resourceType;

  private ImmutableItemDetails(
      @Nullable String name,
      @Nullable String resourceId,
      @Nullable String resourceType) {
    this.name = name;
    this.resourceId = resourceId;
    this.resourceType = resourceType;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public @Nullable String name() {
    return name;
  }

  /**
   * @return The value of the {@code resourceId} attribute
   */
  @JsonProperty("resourceId")
  @Override
  public @Nullable String resourceId() {
    return resourceId;
  }

  /**
   * @return The value of the {@code resourceType} attribute
   */
  @JsonProperty("resourceType")
  @Override
  public @Nullable String resourceType() {
    return resourceType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemDetails#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemDetails withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableItemDetails(value, this.resourceId, this.resourceType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemDetails#resourceId() resourceId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for resourceId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemDetails withResourceId(@Nullable String value) {
    if (Objects.equals(this.resourceId, value)) return this;
    return new ImmutableItemDetails(this.name, value, this.resourceType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ItemDetails#resourceType() resourceType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for resourceType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableItemDetails withResourceType(@Nullable String value) {
    if (Objects.equals(this.resourceType, value)) return this;
    return new ImmutableItemDetails(this.name, this.resourceId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableItemDetails} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableItemDetails
        && equalTo(0, (ImmutableItemDetails) another);
  }

  private boolean equalTo(int synthetic, ImmutableItemDetails another) {
    return Objects.equals(name, another.name)
        && Objects.equals(resourceId, another.resourceId)
        && Objects.equals(resourceType, another.resourceType);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code resourceId}, {@code resourceType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(resourceId);
    h += (h << 5) + Objects.hashCode(resourceType);
    return h;
  }

  /**
   * Prints the immutable value {@code ItemDetails} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ItemDetails{"
        + "name=" + name
        + ", resourceId=" + resourceId
        + ", resourceType=" + resourceType
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ItemDetails", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ItemDetails {
    @javax.annotation.Nullable String name;
    @javax.annotation.Nullable String resourceId;
    @javax.annotation.Nullable String resourceType;
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("resourceId")
    public void setResourceId(@Nullable String resourceId) {
      this.resourceId = resourceId;
    }
    @JsonProperty("resourceType")
    public void setResourceType(@Nullable String resourceType) {
      this.resourceType = resourceType;
    }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public String resourceId() { throw new UnsupportedOperationException(); }
    @Override
    public String resourceType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableItemDetails fromJson(Json json) {
    ImmutableItemDetails.Builder builder = ImmutableItemDetails.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.resourceId != null) {
      builder.resourceId(json.resourceId);
    }
    if (json.resourceType != null) {
      builder.resourceType(json.resourceType);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ItemDetails} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ItemDetails instance
   */
  public static ImmutableItemDetails copyOf(ItemDetails instance) {
    if (instance instanceof ImmutableItemDetails) {
      return (ImmutableItemDetails) instance;
    }
    return ImmutableItemDetails.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableItemDetails ImmutableItemDetails}.
   * <pre>
   * ImmutableItemDetails.builder()
   *    .name(String | null) // nullable {@link ItemDetails#name() name}
   *    .resourceId(String | null) // nullable {@link ItemDetails#resourceId() resourceId}
   *    .resourceType(String | null) // nullable {@link ItemDetails#resourceType() resourceType}
   *    .build();
   * </pre>
   * @return A new ImmutableItemDetails builder
   */
  public static ImmutableItemDetails.Builder builder() {
    return new ImmutableItemDetails.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableItemDetails ImmutableItemDetails}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ItemDetails", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String name;
    private @javax.annotation.Nullable String resourceId;
    private @javax.annotation.Nullable String resourceType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ItemDetails} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ItemDetails instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String nameValue = instance.name();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable String resourceIdValue = instance.resourceId();
      if (resourceIdValue != null) {
        resourceId(resourceIdValue);
      }
      @Nullable String resourceTypeValue = instance.resourceType();
      if (resourceTypeValue != null) {
        resourceType(resourceTypeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ItemDetails#name() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link ItemDetails#resourceId() resourceId} attribute.
     * @param resourceId The value for resourceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("resourceId")
    public final Builder resourceId(@Nullable String resourceId) {
      this.resourceId = resourceId;
      return this;
    }

    /**
     * Initializes the value for the {@link ItemDetails#resourceType() resourceType} attribute.
     * @param resourceType The value for resourceType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("resourceType")
    public final Builder resourceType(@Nullable String resourceType) {
      this.resourceType = resourceType;
      return this;
    }

    /**
     * Builds a new {@link ImmutableItemDetails ImmutableItemDetails}.
     * @return An immutable instance of ItemDetails
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableItemDetails build() {
      return new ImmutableItemDetails(name, resourceId, resourceType);
    }
  }
}
