package zeenea.connector.qlik.cloud.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.NotNull;

/**
 * Immutable implementation of {@link Graph}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGraph.builder()}.
 */
@Generated(from = "Graph", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableGraph implements Graph {
  @NotNull
  private final Map<String, Node> nodes;

  private ImmutableGraph(Map<String, Node> nodes) {
    this.nodes = nodes;
  }

  /**
   * @return The value of the {@code nodes} attribute
   */
  @JsonProperty("nodes")
  @NotNull
  @Override
  public Map<String, Node> nodes() {
    return nodes;
  }

  /**
   * Copy the current immutable object by replacing the {@link Graph#nodes() nodes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the nodes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGraph withNodes(Map<String, ? extends Node> entries) {
    if (this.nodes == entries) return this;
    Map<String, Node> newValue = Map.copyOf(entries);
    return new ImmutableGraph(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGraph} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGraph
        && equalTo(0, (ImmutableGraph) another);
  }

  private boolean equalTo(int synthetic, ImmutableGraph another) {
    return nodes.equals(another.nodes);
  }

  /**
   * Computes a hash code from attributes: {@code nodes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + nodes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Graph} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Graph{"
        + "nodes=" + nodes
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Graph", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Graph {
    @Nullable Map<String, Node> nodes = Map.of();
    @JsonProperty("nodes")
    public void setNodes(Map<String, Node> nodes) {
      this.nodes = nodes;
    }
    @Override
    public Map<String, Node> nodes() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableGraph fromJson(Json json) {
    ImmutableGraph.Builder builder = ImmutableGraph.builder();
    if (json.nodes != null) {
      builder.putAllNodes(json.nodes);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Graph} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Graph instance
   */
  public static ImmutableGraph copyOf(Graph instance) {
    if (instance instanceof ImmutableGraph) {
      return (ImmutableGraph) instance;
    }
    return ImmutableGraph.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGraph ImmutableGraph}.
   * <pre>
   * ImmutableGraph.builder()
   *    .putNodes|putAllNodes(String =&gt; zeenea.connector.qlik.cloud.client.model.Node) // {@link Graph#nodes() nodes} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableGraph builder
   */
  public static ImmutableGraph.Builder builder() {
    return new ImmutableGraph.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGraph ImmutableGraph}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Graph", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private Map<String, Node> nodes = new LinkedHashMap<String, Node>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Graph} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Graph instance) {
      Objects.requireNonNull(instance, "instance");
      putAllNodes(instance.nodes());
      return this;
    }

    /**
     * Put one entry to the {@link Graph#nodes() nodes} map.
     * @param key The key in the nodes map
     * @param value The associated value in the nodes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putNodes(String key, Node value) {
      this.nodes.put(
          Objects.requireNonNull(key, "nodes key"),
          Objects.requireNonNull(value, value == null ? "nodes value for key: " + key : null));
      return this;
    }

    /**
     * Put one entry to the {@link Graph#nodes() nodes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putNodes(Map.Entry<String, ? extends Node> entry) {
      String k = entry.getKey();
      Node v = entry.getValue();
      this.nodes.put(
          Objects.requireNonNull(k, "nodes key"),
          Objects.requireNonNull(v, v == null ? "nodes value for key: " + k : null));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Graph#nodes() nodes} map. Nulls are not permitted
     * @param entries The entries that will be added to the nodes map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("nodes")
    public final Builder nodes(Map<String, ? extends Node> entries) {
      this.nodes.clear();
      return putAllNodes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Graph#nodes() nodes} map. Nulls are not permitted
     * @param entries The entries that will be added to the nodes map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllNodes(Map<String, ? extends Node> entries) {
      for (Map.Entry<String, ? extends Node> e : entries.entrySet()) {
        String k = e.getKey();
        Node v = e.getValue();
        this.nodes.put(
            Objects.requireNonNull(k, "nodes key"),
            Objects.requireNonNull(v, v == null ? "nodes value for key: " + k : null));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableGraph ImmutableGraph}.
     * @return An immutable instance of Graph
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGraph build() {
      return new ImmutableGraph(Map.copyOf(nodes));
    }
  }
}
