package zeenea.connector.qlik.cloud.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Field}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableField.builder()}.
 */
@Generated(from = "Field", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableField implements Field {
  private final String name;
  private final List<String> sourceTables;
  private final String comment;
  private final List<String> tags;
  private final boolean locked;
  private final boolean system;
  private final int totalCount;
  private final int byteSize;
  private final String hash;

  private ImmutableField(
      String name,
      List<String> sourceTables,
      String comment,
      List<String> tags,
      boolean locked,
      boolean system,
      int totalCount,
      int byteSize,
      String hash) {
    this.name = name;
    this.sourceTables = sourceTables;
    this.comment = comment;
    this.tags = tags;
    this.locked = locked;
    this.system = system;
    this.totalCount = totalCount;
    this.byteSize = byteSize;
    this.hash = hash;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code sourceTables} attribute
   */
  @JsonProperty("src_tables")
  @Override
  public List<String> sourceTables() {
    return sourceTables;
  }

  /**
   * @return The value of the {@code comment} attribute
   */
  @JsonProperty("comment")
  @Override
  public String comment() {
    return comment;
  }

  /**
   * @return The value of the {@code tags} attribute
   */
  @JsonProperty("tags")
  @Override
  public List<String> tags() {
    return tags;
  }

  /**
   * @return The value of the {@code locked} attribute
   */
  @JsonProperty("is_locked")
  @Override
  public boolean isLocked() {
    return locked;
  }

  /**
   * @return The value of the {@code system} attribute
   */
  @JsonProperty("is_system")
  @Override
  public boolean isSystem() {
    return system;
  }

  /**
   * @return The value of the {@code totalCount} attribute
   */
  @JsonProperty("total_count")
  @Override
  public int totalCount() {
    return totalCount;
  }

  /**
   * @return The value of the {@code byteSize} attribute
   */
  @JsonProperty("byte_size")
  @Override
  public int byteSize() {
    return byteSize;
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @JsonProperty("hash")
  @Override
  public String hash() {
    return hash;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableField(
        newValue,
        this.sourceTables,
        this.comment,
        this.tags,
        this.locked,
        this.system,
        this.totalCount,
        this.byteSize,
        this.hash);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Field#sourceTables() sourceTables}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableField withSourceTables(String... elements) {
    List<String> newValue = List.of(elements);
    return new ImmutableField(
        this.name,
        newValue,
        this.comment,
        this.tags,
        this.locked,
        this.system,
        this.totalCount,
        this.byteSize,
        this.hash);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Field#sourceTables() sourceTables}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of sourceTables elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableField withSourceTables(Iterable<String> elements) {
    if (this.sourceTables == elements) return this;
    List<String> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<String>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableField(
        this.name,
        newValue,
        this.comment,
        this.tags,
        this.locked,
        this.system,
        this.totalCount,
        this.byteSize,
        this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#comment() comment} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for comment
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withComment(String value) {
    String newValue = Objects.requireNonNull(value, "comment");
    if (this.comment.equals(newValue)) return this;
    return new ImmutableField(
        this.name,
        this.sourceTables,
        newValue,
        this.tags,
        this.locked,
        this.system,
        this.totalCount,
        this.byteSize,
        this.hash);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Field#tags() tags}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableField withTags(String... elements) {
    List<String> newValue = List.of(elements);
    return new ImmutableField(
        this.name,
        this.sourceTables,
        this.comment,
        newValue,
        this.locked,
        this.system,
        this.totalCount,
        this.byteSize,
        this.hash);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Field#tags() tags}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tags elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableField withTags(Iterable<String> elements) {
    if (this.tags == elements) return this;
    List<String> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<String>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableField(
        this.name,
        this.sourceTables,
        this.comment,
        newValue,
        this.locked,
        this.system,
        this.totalCount,
        this.byteSize,
        this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#isLocked() locked} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for locked
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withLocked(boolean value) {
    if (this.locked == value) return this;
    return new ImmutableField(
        this.name,
        this.sourceTables,
        this.comment,
        this.tags,
        value,
        this.system,
        this.totalCount,
        this.byteSize,
        this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#isSystem() system} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for system
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withSystem(boolean value) {
    if (this.system == value) return this;
    return new ImmutableField(
        this.name,
        this.sourceTables,
        this.comment,
        this.tags,
        this.locked,
        value,
        this.totalCount,
        this.byteSize,
        this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#totalCount() totalCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for totalCount
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withTotalCount(int value) {
    if (this.totalCount == value) return this;
    return new ImmutableField(
        this.name,
        this.sourceTables,
        this.comment,
        this.tags,
        this.locked,
        this.system,
        value,
        this.byteSize,
        this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#byteSize() byteSize} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for byteSize
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withByteSize(int value) {
    if (this.byteSize == value) return this;
    return new ImmutableField(
        this.name,
        this.sourceTables,
        this.comment,
        this.tags,
        this.locked,
        this.system,
        this.totalCount,
        value,
        this.hash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Field#hash() hash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for hash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableField withHash(String value) {
    String newValue = Objects.requireNonNull(value, "hash");
    if (this.hash.equals(newValue)) return this;
    return new ImmutableField(
        this.name,
        this.sourceTables,
        this.comment,
        this.tags,
        this.locked,
        this.system,
        this.totalCount,
        this.byteSize,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableField} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableField
        && equalTo(0, (ImmutableField) another);
  }

  private boolean equalTo(int synthetic, ImmutableField another) {
    return name.equals(another.name)
        && sourceTables.equals(another.sourceTables)
        && comment.equals(another.comment)
        && tags.equals(another.tags)
        && locked == another.locked
        && system == another.system
        && totalCount == another.totalCount
        && byteSize == another.byteSize
        && hash.equals(another.hash);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code sourceTables}, {@code comment}, {@code tags}, {@code locked}, {@code system}, {@code totalCount}, {@code byteSize}, {@code hash}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + sourceTables.hashCode();
    h += (h << 5) + comment.hashCode();
    h += (h << 5) + tags.hashCode();
    h += (h << 5) + Boolean.hashCode(locked);
    h += (h << 5) + Boolean.hashCode(system);
    h += (h << 5) + totalCount;
    h += (h << 5) + byteSize;
    h += (h << 5) + hash.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Field} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Field{"
        + "name=" + name
        + ", sourceTables=" + sourceTables
        + ", comment=" + comment
        + ", tags=" + tags
        + ", locked=" + locked
        + ", system=" + system
        + ", totalCount=" + totalCount
        + ", byteSize=" + byteSize
        + ", hash=" + hash
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Field", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Field {
    @Nullable String name;
    @Nullable List<String> sourceTables = List.of();
    @Nullable String comment;
    @Nullable List<String> tags = List.of();
    boolean locked;
    boolean lockedIsSet;
    boolean system;
    boolean systemIsSet;
    int totalCount;
    boolean totalCountIsSet;
    int byteSize;
    boolean byteSizeIsSet;
    @Nullable String hash;
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("src_tables")
    public void setSourceTables(List<String> sourceTables) {
      this.sourceTables = sourceTables;
    }
    @JsonProperty("comment")
    public void setComment(String comment) {
      this.comment = comment;
    }
    @JsonProperty("tags")
    public void setTags(List<String> tags) {
      this.tags = tags;
    }
    @JsonProperty("is_locked")
    public void setLocked(boolean locked) {
      this.locked = locked;
      this.lockedIsSet = true;
    }
    @JsonProperty("is_system")
    public void setSystem(boolean system) {
      this.system = system;
      this.systemIsSet = true;
    }
    @JsonProperty("total_count")
    public void setTotalCount(int totalCount) {
      this.totalCount = totalCount;
      this.totalCountIsSet = true;
    }
    @JsonProperty("byte_size")
    public void setByteSize(int byteSize) {
      this.byteSize = byteSize;
      this.byteSizeIsSet = true;
    }
    @JsonProperty("hash")
    public void setHash(String hash) {
      this.hash = hash;
    }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> sourceTables() { throw new UnsupportedOperationException(); }
    @Override
    public String comment() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> tags() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isLocked() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isSystem() { throw new UnsupportedOperationException(); }
    @Override
    public int totalCount() { throw new UnsupportedOperationException(); }
    @Override
    public int byteSize() { throw new UnsupportedOperationException(); }
    @Override
    public String hash() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableField fromJson(Json json) {
    ImmutableField.Builder builder = ImmutableField.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.sourceTables != null) {
      builder.addAllSourceTables(json.sourceTables);
    }
    if (json.comment != null) {
      builder.comment(json.comment);
    }
    if (json.tags != null) {
      builder.addAllTags(json.tags);
    }
    if (json.lockedIsSet) {
      builder.locked(json.locked);
    }
    if (json.systemIsSet) {
      builder.system(json.system);
    }
    if (json.totalCountIsSet) {
      builder.totalCount(json.totalCount);
    }
    if (json.byteSizeIsSet) {
      builder.byteSize(json.byteSize);
    }
    if (json.hash != null) {
      builder.hash(json.hash);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Field} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Field instance
   */
  public static ImmutableField copyOf(Field instance) {
    if (instance instanceof ImmutableField) {
      return (ImmutableField) instance;
    }
    return ImmutableField.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableField ImmutableField}.
   * <pre>
   * ImmutableField.builder()
   *    .name(String) // required {@link Field#name() name}
   *    .addSourceTables|addAllSourceTables(String) // {@link Field#sourceTables() sourceTables} elements
   *    .comment(String) // required {@link Field#comment() comment}
   *    .addTags|addAllTags(String) // {@link Field#tags() tags} elements
   *    .locked(boolean) // required {@link Field#isLocked() locked}
   *    .system(boolean) // required {@link Field#isSystem() system}
   *    .totalCount(int) // required {@link Field#totalCount() totalCount}
   *    .byteSize(int) // required {@link Field#byteSize() byteSize}
   *    .hash(String) // required {@link Field#hash() hash}
   *    .build();
   * </pre>
   * @return A new ImmutableField builder
   */
  public static ImmutableField.Builder builder() {
    return new ImmutableField.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableField ImmutableField}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Field", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_COMMENT = 0x2L;
    private static final long INIT_BIT_LOCKED = 0x4L;
    private static final long INIT_BIT_SYSTEM = 0x8L;
    private static final long INIT_BIT_TOTAL_COUNT = 0x10L;
    private static final long INIT_BIT_BYTE_SIZE = 0x20L;
    private static final long INIT_BIT_HASH = 0x40L;
    private long initBits = 0x7fL;

    private @Nullable String name;
    private List<String> sourceTables = new ArrayList<String>();
    private @Nullable String comment;
    private List<String> tags = new ArrayList<String>();
    private boolean locked;
    private boolean system;
    private int totalCount;
    private int byteSize;
    private @Nullable String hash;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Field} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Field instance) {
      Objects.requireNonNull(instance, "instance");
      this.name(instance.name());
      addAllSourceTables(instance.sourceTables());
      this.comment(instance.comment());
      addAllTags(instance.tags());
      this.locked(instance.isLocked());
      this.system(instance.isSystem());
      this.totalCount(instance.totalCount());
      this.byteSize(instance.byteSize());
      this.hash(instance.hash());
      return this;
    }

    /**
     * Initializes the value for the {@link Field#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Adds one element to {@link Field#sourceTables() sourceTables} list.
     * @param element A sourceTables element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSourceTables(String element) {
      this.sourceTables.add(Objects.requireNonNull(element, "sourceTables element"));
      return this;
    }

    /**
     * Adds elements to {@link Field#sourceTables() sourceTables} list.
     * @param elements An array of sourceTables elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSourceTables(String... elements) {
      for (String element : elements) {
        this.sourceTables.add(Objects.requireNonNull(element, "sourceTables element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Field#sourceTables() sourceTables} list.
     * @param elements An iterable of sourceTables elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("src_tables")
    public final Builder sourceTables(Iterable<String> elements) {
      this.sourceTables.clear();
      return addAllSourceTables(elements);
    }

    /**
     * Adds elements to {@link Field#sourceTables() sourceTables} list.
     * @param elements An iterable of sourceTables elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSourceTables(Iterable<String> elements) {
      for (String element : elements) {
        this.sourceTables.add(Objects.requireNonNull(element, "sourceTables element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Field#comment() comment} attribute.
     * @param comment The value for comment 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("comment")
    public final Builder comment(String comment) {
      this.comment = Objects.requireNonNull(comment, "comment");
      initBits &= ~INIT_BIT_COMMENT;
      return this;
    }

    /**
     * Adds one element to {@link Field#tags() tags} list.
     * @param element A tags element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTags(String element) {
      this.tags.add(Objects.requireNonNull(element, "tags element"));
      return this;
    }

    /**
     * Adds elements to {@link Field#tags() tags} list.
     * @param elements An array of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTags(String... elements) {
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Field#tags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tags")
    public final Builder tags(Iterable<String> elements) {
      this.tags.clear();
      return addAllTags(elements);
    }

    /**
     * Adds elements to {@link Field#tags() tags} list.
     * @param elements An iterable of tags elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTags(Iterable<String> elements) {
      for (String element : elements) {
        this.tags.add(Objects.requireNonNull(element, "tags element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Field#isLocked() locked} attribute.
     * @param locked The value for locked 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("is_locked")
    public final Builder locked(boolean locked) {
      this.locked = locked;
      initBits &= ~INIT_BIT_LOCKED;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#isSystem() system} attribute.
     * @param system The value for system 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("is_system")
    public final Builder system(boolean system) {
      this.system = system;
      initBits &= ~INIT_BIT_SYSTEM;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#totalCount() totalCount} attribute.
     * @param totalCount The value for totalCount 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("total_count")
    public final Builder totalCount(int totalCount) {
      this.totalCount = totalCount;
      initBits &= ~INIT_BIT_TOTAL_COUNT;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#byteSize() byteSize} attribute.
     * @param byteSize The value for byteSize 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("byte_size")
    public final Builder byteSize(int byteSize) {
      this.byteSize = byteSize;
      initBits &= ~INIT_BIT_BYTE_SIZE;
      return this;
    }

    /**
     * Initializes the value for the {@link Field#hash() hash} attribute.
     * @param hash The value for hash 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("hash")
    public final Builder hash(String hash) {
      this.hash = Objects.requireNonNull(hash, "hash");
      initBits &= ~INIT_BIT_HASH;
      return this;
    }

    /**
     * Builds a new {@link ImmutableField ImmutableField}.
     * @return An immutable instance of Field
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableField build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableField(
          name,
          List.copyOf(sourceTables),
          comment,
          List.copyOf(tags),
          locked,
          system,
          totalCount,
          byteSize,
          hash);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_COMMENT) != 0) attributes.add("comment");
      if ((initBits & INIT_BIT_LOCKED) != 0) attributes.add("locked");
      if ((initBits & INIT_BIT_SYSTEM) != 0) attributes.add("system");
      if ((initBits & INIT_BIT_TOTAL_COUNT) != 0) attributes.add("totalCount");
      if ((initBits & INIT_BIT_BYTE_SIZE) != 0) attributes.add("byteSize");
      if ((initBits & INIT_BIT_HASH) != 0) attributes.add("hash");
      return "Cannot build Field, some of required attributes are not set " + attributes;
    }
  }
}
