package zeenea.connector.qlik.cloud.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DataModel}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDataModel.builder()}.
 */
@Generated(from = "DataModel", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDataModel implements DataModel {
  private final List<Field> fields;
  private final List<Table> tables;
  private final String usage;

  private ImmutableDataModel(
      List<Field> fields,
      List<Table> tables,
      String usage) {
    this.fields = fields;
    this.tables = tables;
    this.usage = usage;
  }

  /**
   * @return The value of the {@code fields} attribute
   */
  @JsonProperty("fields")
  @Override
  public List<Field> fields() {
    return fields;
  }

  /**
   * @return The value of the {@code tables} attribute
   */
  @JsonProperty("tables")
  @Override
  public List<Table> tables() {
    return tables;
  }

  /**
   * @return The value of the {@code usage} attribute
   */
  @JsonProperty("usage")
  @Override
  public String usage() {
    return usage;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DataModel#fields() fields}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataModel withFields(Field... elements) {
    List<Field> newValue = List.of(elements);
    return new ImmutableDataModel(newValue, this.tables, this.usage);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DataModel#fields() fields}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fields elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataModel withFields(Iterable<? extends Field> elements) {
    if (this.fields == elements) return this;
    List<Field> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Field>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableDataModel(newValue, this.tables, this.usage);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DataModel#tables() tables}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataModel withTables(Table... elements) {
    List<Table> newValue = List.of(elements);
    return new ImmutableDataModel(this.fields, newValue, this.usage);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DataModel#tables() tables}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tables elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataModel withTables(Iterable<? extends Table> elements) {
    if (this.tables == elements) return this;
    List<Table> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends Table>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableDataModel(this.fields, newValue, this.usage);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataModel#usage() usage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for usage
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataModel withUsage(String value) {
    String newValue = Objects.requireNonNull(value, "usage");
    if (this.usage.equals(newValue)) return this;
    return new ImmutableDataModel(this.fields, this.tables, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDataModel} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDataModel
        && equalTo(0, (ImmutableDataModel) another);
  }

  private boolean equalTo(int synthetic, ImmutableDataModel another) {
    return fields.equals(another.fields)
        && tables.equals(another.tables)
        && usage.equals(another.usage);
  }

  /**
   * Computes a hash code from attributes: {@code fields}, {@code tables}, {@code usage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + fields.hashCode();
    h += (h << 5) + tables.hashCode();
    h += (h << 5) + usage.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DataModel} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DataModel{"
        + "fields=" + fields
        + ", tables=" + tables
        + ", usage=" + usage
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DataModel", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DataModel {
    @Nullable List<Field> fields = List.of();
    @Nullable List<Table> tables = List.of();
    @Nullable String usage;
    @JsonProperty("fields")
    public void setFields(List<Field> fields) {
      this.fields = fields;
    }
    @JsonProperty("tables")
    public void setTables(List<Table> tables) {
      this.tables = tables;
    }
    @JsonProperty("usage")
    public void setUsage(String usage) {
      this.usage = usage;
    }
    @Override
    public List<Field> fields() { throw new UnsupportedOperationException(); }
    @Override
    public List<Table> tables() { throw new UnsupportedOperationException(); }
    @Override
    public String usage() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDataModel fromJson(Json json) {
    ImmutableDataModel.Builder builder = ImmutableDataModel.builder();
    if (json.fields != null) {
      builder.addAllFields(json.fields);
    }
    if (json.tables != null) {
      builder.addAllTables(json.tables);
    }
    if (json.usage != null) {
      builder.usage(json.usage);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DataModel} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DataModel instance
   */
  public static ImmutableDataModel copyOf(DataModel instance) {
    if (instance instanceof ImmutableDataModel) {
      return (ImmutableDataModel) instance;
    }
    return ImmutableDataModel.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDataModel ImmutableDataModel}.
   * <pre>
   * ImmutableDataModel.builder()
   *    .addFields|addAllFields(zeenea.connector.qlik.cloud.client.model.Field) // {@link DataModel#fields() fields} elements
   *    .addTables|addAllTables(zeenea.connector.qlik.cloud.client.model.Table) // {@link DataModel#tables() tables} elements
   *    .usage(String) // required {@link DataModel#usage() usage}
   *    .build();
   * </pre>
   * @return A new ImmutableDataModel builder
   */
  public static ImmutableDataModel.Builder builder() {
    return new ImmutableDataModel.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDataModel ImmutableDataModel}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DataModel", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_USAGE = 0x1L;
    private long initBits = 0x1L;

    private List<Field> fields = new ArrayList<Field>();
    private List<Table> tables = new ArrayList<Table>();
    private @Nullable String usage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DataModel} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DataModel instance) {
      Objects.requireNonNull(instance, "instance");
      addAllFields(instance.fields());
      addAllTables(instance.tables());
      this.usage(instance.usage());
      return this;
    }

    /**
     * Adds one element to {@link DataModel#fields() fields} list.
     * @param element A fields element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFields(Field element) {
      this.fields.add(Objects.requireNonNull(element, "fields element"));
      return this;
    }

    /**
     * Adds elements to {@link DataModel#fields() fields} list.
     * @param elements An array of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFields(Field... elements) {
      for (Field element : elements) {
        this.fields.add(Objects.requireNonNull(element, "fields element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DataModel#fields() fields} list.
     * @param elements An iterable of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("fields")
    public final Builder fields(Iterable<? extends Field> elements) {
      this.fields.clear();
      return addAllFields(elements);
    }

    /**
     * Adds elements to {@link DataModel#fields() fields} list.
     * @param elements An iterable of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllFields(Iterable<? extends Field> elements) {
      for (Field element : elements) {
        this.fields.add(Objects.requireNonNull(element, "fields element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link DataModel#tables() tables} list.
     * @param element A tables element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTables(Table element) {
      this.tables.add(Objects.requireNonNull(element, "tables element"));
      return this;
    }

    /**
     * Adds elements to {@link DataModel#tables() tables} list.
     * @param elements An array of tables elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTables(Table... elements) {
      for (Table element : elements) {
        this.tables.add(Objects.requireNonNull(element, "tables element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DataModel#tables() tables} list.
     * @param elements An iterable of tables elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("tables")
    public final Builder tables(Iterable<? extends Table> elements) {
      this.tables.clear();
      return addAllTables(elements);
    }

    /**
     * Adds elements to {@link DataModel#tables() tables} list.
     * @param elements An iterable of tables elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTables(Iterable<? extends Table> elements) {
      for (Table element : elements) {
        this.tables.add(Objects.requireNonNull(element, "tables element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DataModel#usage() usage} attribute.
     * @param usage The value for usage 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("usage")
    public final Builder usage(String usage) {
      this.usage = Objects.requireNonNull(usage, "usage");
      initBits &= ~INIT_BIT_USAGE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDataModel ImmutableDataModel}.
     * @return An immutable instance of DataModel
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDataModel build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDataModel(List.copyOf(fields), List.copyOf(tables), usage);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_USAGE) != 0) attributes.add("usage");
      return "Cannot build DataModel, some of required attributes are not set " + attributes;
    }
  }
}
