package zeenea.connector.qlik.cloud.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DataConnectionItem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDataConnectionItem.builder()}.
 */
@Generated(from = "DataConnectionItem", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDataConnectionItem
    implements DataConnectionItem {
  private final List<DataConnection> data;

  private ImmutableDataConnectionItem(List<DataConnection> data) {
    this.data = data;
  }

  /**
   * @return The value of the {@code data} attribute
   */
  @JsonProperty("data")
  @Override
  public List<DataConnection> data() {
    return data;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DataConnectionItem#data() data}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataConnectionItem withData(DataConnection... elements) {
    List<DataConnection> newValue = List.of(elements);
    return new ImmutableDataConnectionItem(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DataConnectionItem#data() data}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of data elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDataConnectionItem withData(Iterable<? extends DataConnection> elements) {
    if (this.data == elements) return this;
    List<DataConnection> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends DataConnection>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableDataConnectionItem(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDataConnectionItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDataConnectionItem
        && equalTo(0, (ImmutableDataConnectionItem) another);
  }

  private boolean equalTo(int synthetic, ImmutableDataConnectionItem another) {
    return data.equals(another.data);
  }

  /**
   * Computes a hash code from attributes: {@code data}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + data.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DataConnectionItem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DataConnectionItem{"
        + "data=" + data
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DataConnectionItem", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DataConnectionItem {
    @Nullable List<DataConnection> data = List.of();
    @JsonProperty("data")
    public void setData(List<DataConnection> data) {
      this.data = data;
    }
    @Override
    public List<DataConnection> data() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDataConnectionItem fromJson(Json json) {
    ImmutableDataConnectionItem.Builder builder = ImmutableDataConnectionItem.builder();
    if (json.data != null) {
      builder.addAllData(json.data);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DataConnectionItem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DataConnectionItem instance
   */
  public static ImmutableDataConnectionItem copyOf(DataConnectionItem instance) {
    if (instance instanceof ImmutableDataConnectionItem) {
      return (ImmutableDataConnectionItem) instance;
    }
    return ImmutableDataConnectionItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDataConnectionItem ImmutableDataConnectionItem}.
   * <pre>
   * ImmutableDataConnectionItem.builder()
   *    .addData|addAllData(zeenea.connector.qlik.cloud.client.model.DataConnection) // {@link DataConnectionItem#data() data} elements
   *    .build();
   * </pre>
   * @return A new ImmutableDataConnectionItem builder
   */
  public static ImmutableDataConnectionItem.Builder builder() {
    return new ImmutableDataConnectionItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDataConnectionItem ImmutableDataConnectionItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DataConnectionItem", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<DataConnection> data = new ArrayList<DataConnection>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DataConnectionItem} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DataConnectionItem instance) {
      Objects.requireNonNull(instance, "instance");
      addAllData(instance.data());
      return this;
    }

    /**
     * Adds one element to {@link DataConnectionItem#data() data} list.
     * @param element A data element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addData(DataConnection element) {
      this.data.add(Objects.requireNonNull(element, "data element"));
      return this;
    }

    /**
     * Adds elements to {@link DataConnectionItem#data() data} list.
     * @param elements An array of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addData(DataConnection... elements) {
      for (DataConnection element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DataConnectionItem#data() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("data")
    public final Builder data(Iterable<? extends DataConnection> elements) {
      this.data.clear();
      return addAllData(elements);
    }

    /**
     * Adds elements to {@link DataConnectionItem#data() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllData(Iterable<? extends DataConnection> elements) {
      for (DataConnection element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableDataConnectionItem ImmutableDataConnectionItem}.
     * @return An immutable instance of DataConnectionItem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDataConnectionItem build() {
      return new ImmutableDataConnectionItem(List.copyOf(data));
    }
  }
}
