package zeenea.connector.qlik.cloud.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link DataConnection}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDataConnection.builder()}.
 */
@Generated(from = "DataConnection", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableDataConnection implements DataConnection {
  private final @Nullable String datasourceId;
  private final String id;
  private final String qConnectStatement;
  private final @Nullable String qri;

  private ImmutableDataConnection(
      @Nullable String datasourceId,
      String id,
      String qConnectStatement,
      @Nullable String qri) {
    this.datasourceId = datasourceId;
    this.id = id;
    this.qConnectStatement = qConnectStatement;
    this.qri = qri;
  }

  /**
   * @return The value of the {@code datasourceId} attribute
   */
  @JsonProperty("datasourceID")
  @Override
  public @Nullable String datasourceId() {
    return datasourceId;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }

  /**
   * @return The value of the {@code qConnectStatement} attribute
   */
  @JsonProperty("qConnectStatement")
  @Override
  public String qConnectStatement() {
    return qConnectStatement;
  }

  /**
   * @return The value of the {@code qri} attribute
   */
  @JsonProperty("qri")
  @Override
  public @Nullable String qri() {
    return qri;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataConnection#datasourceId() datasourceId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for datasourceId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataConnection withDatasourceId(@Nullable String value) {
    if (Objects.equals(this.datasourceId, value)) return this;
    return new ImmutableDataConnection(value, this.id, this.qConnectStatement, this.qri);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataConnection#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataConnection withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableDataConnection(this.datasourceId, newValue, this.qConnectStatement, this.qri);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataConnection#qConnectStatement() qConnectStatement} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for qConnectStatement
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataConnection withQConnectStatement(String value) {
    String newValue = Objects.requireNonNull(value, "qConnectStatement");
    if (this.qConnectStatement.equals(newValue)) return this;
    return new ImmutableDataConnection(this.datasourceId, this.id, newValue, this.qri);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DataConnection#qri() qri} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for qri (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDataConnection withQri(@Nullable String value) {
    if (Objects.equals(this.qri, value)) return this;
    return new ImmutableDataConnection(this.datasourceId, this.id, this.qConnectStatement, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDataConnection} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDataConnection
        && equalTo(0, (ImmutableDataConnection) another);
  }

  private boolean equalTo(int synthetic, ImmutableDataConnection another) {
    return Objects.equals(datasourceId, another.datasourceId)
        && id.equals(another.id)
        && qConnectStatement.equals(another.qConnectStatement)
        && Objects.equals(qri, another.qri);
  }

  /**
   * Computes a hash code from attributes: {@code datasourceId}, {@code id}, {@code qConnectStatement}, {@code qri}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(datasourceId);
    h += (h << 5) + id.hashCode();
    h += (h << 5) + qConnectStatement.hashCode();
    h += (h << 5) + Objects.hashCode(qri);
    return h;
  }

  /**
   * Prints the immutable value {@code DataConnection} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DataConnection{"
        + "datasourceId=" + datasourceId
        + ", id=" + id
        + ", qConnectStatement=" + qConnectStatement
        + ", qri=" + qri
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "DataConnection", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DataConnection {
    @javax.annotation.Nullable String datasourceId;
    @javax.annotation.Nullable String id;
    @javax.annotation.Nullable String qConnectStatement;
    @javax.annotation.Nullable String qri;
    @JsonProperty("datasourceID")
    public void setDatasourceId(@Nullable String datasourceId) {
      this.datasourceId = datasourceId;
    }
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("qConnectStatement")
    public void setQConnectStatement(String qConnectStatement) {
      this.qConnectStatement = qConnectStatement;
    }
    @JsonProperty("qri")
    public void setQri(@Nullable String qri) {
      this.qri = qri;
    }
    @Override
    public String datasourceId() { throw new UnsupportedOperationException(); }
    @Override
    public String id() { throw new UnsupportedOperationException(); }
    @Override
    public String qConnectStatement() { throw new UnsupportedOperationException(); }
    @Override
    public String qri() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableDataConnection fromJson(Json json) {
    ImmutableDataConnection.Builder builder = ImmutableDataConnection.builder();
    if (json.datasourceId != null) {
      builder.datasourceId(json.datasourceId);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.qConnectStatement != null) {
      builder.qConnectStatement(json.qConnectStatement);
    }
    if (json.qri != null) {
      builder.qri(json.qri);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DataConnection} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DataConnection instance
   */
  public static ImmutableDataConnection copyOf(DataConnection instance) {
    if (instance instanceof ImmutableDataConnection) {
      return (ImmutableDataConnection) instance;
    }
    return ImmutableDataConnection.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDataConnection ImmutableDataConnection}.
   * <pre>
   * ImmutableDataConnection.builder()
   *    .datasourceId(String | null) // nullable {@link DataConnection#datasourceId() datasourceId}
   *    .id(String) // required {@link DataConnection#id() id}
   *    .qConnectStatement(String) // required {@link DataConnection#qConnectStatement() qConnectStatement}
   *    .qri(String | null) // nullable {@link DataConnection#qri() qri}
   *    .build();
   * </pre>
   * @return A new ImmutableDataConnection builder
   */
  public static ImmutableDataConnection.Builder builder() {
    return new ImmutableDataConnection.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDataConnection ImmutableDataConnection}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DataConnection", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_Q_CONNECT_STATEMENT = 0x2L;
    private long initBits = 0x3L;

    private @javax.annotation.Nullable String datasourceId;
    private @javax.annotation.Nullable String id;
    private @javax.annotation.Nullable String qConnectStatement;
    private @javax.annotation.Nullable String qri;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DataConnection} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DataConnection instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String datasourceIdValue = instance.datasourceId();
      if (datasourceIdValue != null) {
        datasourceId(datasourceIdValue);
      }
      this.id(instance.id());
      this.qConnectStatement(instance.qConnectStatement());
      @Nullable String qriValue = instance.qri();
      if (qriValue != null) {
        qri(qriValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DataConnection#datasourceId() datasourceId} attribute.
     * @param datasourceId The value for datasourceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("datasourceID")
    public final Builder datasourceId(@Nullable String datasourceId) {
      this.datasourceId = datasourceId;
      return this;
    }

    /**
     * Initializes the value for the {@link DataConnection#id() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DataConnection#qConnectStatement() qConnectStatement} attribute.
     * @param qConnectStatement The value for qConnectStatement 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("qConnectStatement")
    public final Builder qConnectStatement(String qConnectStatement) {
      this.qConnectStatement = Objects.requireNonNull(qConnectStatement, "qConnectStatement");
      initBits &= ~INIT_BIT_Q_CONNECT_STATEMENT;
      return this;
    }

    /**
     * Initializes the value for the {@link DataConnection#qri() qri} attribute.
     * @param qri The value for qri (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("qri")
    public final Builder qri(@Nullable String qri) {
      this.qri = qri;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDataConnection ImmutableDataConnection}.
     * @return An immutable instance of DataConnection
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDataConnection build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableDataConnection(datasourceId, id, qConnectStatement, qri);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_Q_CONNECT_STATEMENT) != 0) attributes.add("qConnectStatement");
      return "Cannot build DataConnection, some of required attributes are not set " + attributes;
    }
  }
}
