package zeenea.connector.qlik.cloud.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Attributes}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAttributes.builder()}.
 */
@Generated(from = "Attributes", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableAttributes implements Attributes {
  private final @Nullable String id;
  private final @Nullable String name;
  private final @Nullable String description;
  private final @Nullable String createdDate;
  private final @Nullable String modifiedDate;
  private final @Nullable String ownerId;
  private final @Nullable String lastReloadTime;

  private ImmutableAttributes(
      @Nullable String id,
      @Nullable String name,
      @Nullable String description,
      @Nullable String createdDate,
      @Nullable String modifiedDate,
      @Nullable String ownerId,
      @Nullable String lastReloadTime) {
    this.id = id;
    this.name = name;
    this.description = description;
    this.createdDate = createdDate;
    this.modifiedDate = modifiedDate;
    this.ownerId = ownerId;
    this.lastReloadTime = lastReloadTime;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public @Nullable String id() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public @Nullable String name() {
    return name;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public @Nullable String description() {
    return description;
  }

  /**
   * @return The value of the {@code createdDate} attribute
   */
  @JsonProperty("createdDate")
  @Override
  public @Nullable String createdDate() {
    return createdDate;
  }

  /**
   * @return The value of the {@code modifiedDate} attribute
   */
  @JsonProperty("modifiedDate")
  @Override
  public @Nullable String modifiedDate() {
    return modifiedDate;
  }

  /**
   * @return The value of the {@code ownerId} attribute
   */
  @JsonProperty("ownerId")
  @Override
  public @Nullable String ownerId() {
    return ownerId;
  }

  /**
   * @return The value of the {@code lastReloadTime} attribute
   */
  @JsonProperty("lastReloadTime")
  @Override
  public @Nullable String lastReloadTime() {
    return lastReloadTime;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Attributes#id() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttributes withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableAttributes(
        value,
        this.name,
        this.description,
        this.createdDate,
        this.modifiedDate,
        this.ownerId,
        this.lastReloadTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Attributes#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttributes withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableAttributes(
        this.id,
        value,
        this.description,
        this.createdDate,
        this.modifiedDate,
        this.ownerId,
        this.lastReloadTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Attributes#description() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttributes withDescription(@Nullable String value) {
    if (Objects.equals(this.description, value)) return this;
    return new ImmutableAttributes(
        this.id,
        this.name,
        value,
        this.createdDate,
        this.modifiedDate,
        this.ownerId,
        this.lastReloadTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Attributes#createdDate() createdDate} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for createdDate (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttributes withCreatedDate(@Nullable String value) {
    if (Objects.equals(this.createdDate, value)) return this;
    return new ImmutableAttributes(
        this.id,
        this.name,
        this.description,
        value,
        this.modifiedDate,
        this.ownerId,
        this.lastReloadTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Attributes#modifiedDate() modifiedDate} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modifiedDate (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttributes withModifiedDate(@Nullable String value) {
    if (Objects.equals(this.modifiedDate, value)) return this;
    return new ImmutableAttributes(
        this.id,
        this.name,
        this.description,
        this.createdDate,
        value,
        this.ownerId,
        this.lastReloadTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Attributes#ownerId() ownerId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ownerId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttributes withOwnerId(@Nullable String value) {
    if (Objects.equals(this.ownerId, value)) return this;
    return new ImmutableAttributes(
        this.id,
        this.name,
        this.description,
        this.createdDate,
        this.modifiedDate,
        value,
        this.lastReloadTime);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Attributes#lastReloadTime() lastReloadTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for lastReloadTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAttributes withLastReloadTime(@Nullable String value) {
    if (Objects.equals(this.lastReloadTime, value)) return this;
    return new ImmutableAttributes(this.id, this.name, this.description, this.createdDate, this.modifiedDate, this.ownerId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAttributes} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAttributes
        && equalTo(0, (ImmutableAttributes) another);
  }

  private boolean equalTo(int synthetic, ImmutableAttributes another) {
    return Objects.equals(id, another.id)
        && Objects.equals(name, another.name)
        && Objects.equals(description, another.description)
        && Objects.equals(createdDate, another.createdDate)
        && Objects.equals(modifiedDate, another.modifiedDate)
        && Objects.equals(ownerId, another.ownerId)
        && Objects.equals(lastReloadTime, another.lastReloadTime);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code description}, {@code createdDate}, {@code modifiedDate}, {@code ownerId}, {@code lastReloadTime}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + Objects.hashCode(createdDate);
    h += (h << 5) + Objects.hashCode(modifiedDate);
    h += (h << 5) + Objects.hashCode(ownerId);
    h += (h << 5) + Objects.hashCode(lastReloadTime);
    return h;
  }

  /**
   * Prints the immutable value {@code Attributes} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Attributes{"
        + "id=" + id
        + ", name=" + name
        + ", description=" + description
        + ", createdDate=" + createdDate
        + ", modifiedDate=" + modifiedDate
        + ", ownerId=" + ownerId
        + ", lastReloadTime=" + lastReloadTime
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Attributes", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Attributes {
    @javax.annotation.Nullable String id;
    @javax.annotation.Nullable String name;
    @javax.annotation.Nullable String description;
    @javax.annotation.Nullable String createdDate;
    @javax.annotation.Nullable String modifiedDate;
    @javax.annotation.Nullable String ownerId;
    @javax.annotation.Nullable String lastReloadTime;
    @JsonProperty("id")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("createdDate")
    public void setCreatedDate(@Nullable String createdDate) {
      this.createdDate = createdDate;
    }
    @JsonProperty("modifiedDate")
    public void setModifiedDate(@Nullable String modifiedDate) {
      this.modifiedDate = modifiedDate;
    }
    @JsonProperty("ownerId")
    public void setOwnerId(@Nullable String ownerId) {
      this.ownerId = ownerId;
    }
    @JsonProperty("lastReloadTime")
    public void setLastReloadTime(@Nullable String lastReloadTime) {
      this.lastReloadTime = lastReloadTime;
    }
    @Override
    public String id() { throw new UnsupportedOperationException(); }
    @Override
    public String name() { throw new UnsupportedOperationException(); }
    @Override
    public String description() { throw new UnsupportedOperationException(); }
    @Override
    public String createdDate() { throw new UnsupportedOperationException(); }
    @Override
    public String modifiedDate() { throw new UnsupportedOperationException(); }
    @Override
    public String ownerId() { throw new UnsupportedOperationException(); }
    @Override
    public String lastReloadTime() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAttributes fromJson(Json json) {
    ImmutableAttributes.Builder builder = ImmutableAttributes.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.createdDate != null) {
      builder.createdDate(json.createdDate);
    }
    if (json.modifiedDate != null) {
      builder.modifiedDate(json.modifiedDate);
    }
    if (json.ownerId != null) {
      builder.ownerId(json.ownerId);
    }
    if (json.lastReloadTime != null) {
      builder.lastReloadTime(json.lastReloadTime);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Attributes} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Attributes instance
   */
  public static ImmutableAttributes copyOf(Attributes instance) {
    if (instance instanceof ImmutableAttributes) {
      return (ImmutableAttributes) instance;
    }
    return ImmutableAttributes.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAttributes ImmutableAttributes}.
   * <pre>
   * ImmutableAttributes.builder()
   *    .id(String | null) // nullable {@link Attributes#id() id}
   *    .name(String | null) // nullable {@link Attributes#name() name}
   *    .description(String | null) // nullable {@link Attributes#description() description}
   *    .createdDate(String | null) // nullable {@link Attributes#createdDate() createdDate}
   *    .modifiedDate(String | null) // nullable {@link Attributes#modifiedDate() modifiedDate}
   *    .ownerId(String | null) // nullable {@link Attributes#ownerId() ownerId}
   *    .lastReloadTime(String | null) // nullable {@link Attributes#lastReloadTime() lastReloadTime}
   *    .build();
   * </pre>
   * @return A new ImmutableAttributes builder
   */
  public static ImmutableAttributes.Builder builder() {
    return new ImmutableAttributes.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAttributes ImmutableAttributes}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Attributes", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable String id;
    private @javax.annotation.Nullable String name;
    private @javax.annotation.Nullable String description;
    private @javax.annotation.Nullable String createdDate;
    private @javax.annotation.Nullable String modifiedDate;
    private @javax.annotation.Nullable String ownerId;
    private @javax.annotation.Nullable String lastReloadTime;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Attributes} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Attributes instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable String idValue = instance.id();
      if (idValue != null) {
        id(idValue);
      }
      @Nullable String nameValue = instance.name();
      if (nameValue != null) {
        name(nameValue);
      }
      @Nullable String descriptionValue = instance.description();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      @Nullable String createdDateValue = instance.createdDate();
      if (createdDateValue != null) {
        createdDate(createdDateValue);
      }
      @Nullable String modifiedDateValue = instance.modifiedDate();
      if (modifiedDateValue != null) {
        modifiedDate(modifiedDateValue);
      }
      @Nullable String ownerIdValue = instance.ownerId();
      if (ownerIdValue != null) {
        ownerId(ownerIdValue);
      }
      @Nullable String lastReloadTimeValue = instance.lastReloadTime();
      if (lastReloadTimeValue != null) {
        lastReloadTime(lastReloadTimeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Attributes#id() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link Attributes#name() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link Attributes#description() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("description")
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link Attributes#createdDate() createdDate} attribute.
     * @param createdDate The value for createdDate (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("createdDate")
    public final Builder createdDate(@Nullable String createdDate) {
      this.createdDate = createdDate;
      return this;
    }

    /**
     * Initializes the value for the {@link Attributes#modifiedDate() modifiedDate} attribute.
     * @param modifiedDate The value for modifiedDate (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("modifiedDate")
    public final Builder modifiedDate(@Nullable String modifiedDate) {
      this.modifiedDate = modifiedDate;
      return this;
    }

    /**
     * Initializes the value for the {@link Attributes#ownerId() ownerId} attribute.
     * @param ownerId The value for ownerId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ownerId")
    public final Builder ownerId(@Nullable String ownerId) {
      this.ownerId = ownerId;
      return this;
    }

    /**
     * Initializes the value for the {@link Attributes#lastReloadTime() lastReloadTime} attribute.
     * @param lastReloadTime The value for lastReloadTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lastReloadTime")
    public final Builder lastReloadTime(@Nullable String lastReloadTime) {
      this.lastReloadTime = lastReloadTime;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAttributes ImmutableAttributes}.
     * @return An immutable instance of Attributes
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAttributes build() {
      return new ImmutableAttributes(id, name, description, createdDate, modifiedDate, ownerId, lastReloadTime);
    }
  }
}
