package zeenea.connector.qlik.cloud.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ApplicationItem}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableApplicationItem.builder()}.
 */
@Generated(from = "ApplicationItem", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableApplicationItem
    implements ApplicationItem {
  private final List<ItemDetails> data;

  private ImmutableApplicationItem(List<ItemDetails> data) {
    this.data = data;
  }

  /**
   * @return The value of the {@code data} attribute
   */
  @JsonProperty("data")
  @Override
  public List<ItemDetails> data() {
    return data;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ApplicationItem#data() data}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableApplicationItem withData(ItemDetails... elements) {
    List<ItemDetails> newValue = List.of(elements);
    return new ImmutableApplicationItem(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ApplicationItem#data() data}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of data elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableApplicationItem withData(Iterable<? extends ItemDetails> elements) {
    if (this.data == elements) return this;
    List<ItemDetails> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends ItemDetails>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableApplicationItem(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableApplicationItem} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableApplicationItem
        && equalTo(0, (ImmutableApplicationItem) another);
  }

  private boolean equalTo(int synthetic, ImmutableApplicationItem another) {
    return data.equals(another.data);
  }

  /**
   * Computes a hash code from attributes: {@code data}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + data.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationItem} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationItem{"
        + "data=" + data
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ApplicationItem", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ApplicationItem {
    @Nullable List<ItemDetails> data = List.of();
    @JsonProperty("data")
    public void setData(List<ItemDetails> data) {
      this.data = data;
    }
    @Override
    public List<ItemDetails> data() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableApplicationItem fromJson(Json json) {
    ImmutableApplicationItem.Builder builder = ImmutableApplicationItem.builder();
    if (json.data != null) {
      builder.addAllData(json.data);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ApplicationItem} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ApplicationItem instance
   */
  public static ImmutableApplicationItem copyOf(ApplicationItem instance) {
    if (instance instanceof ImmutableApplicationItem) {
      return (ImmutableApplicationItem) instance;
    }
    return ImmutableApplicationItem.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableApplicationItem ImmutableApplicationItem}.
   * <pre>
   * ImmutableApplicationItem.builder()
   *    .addData|addAllData(zeenea.connector.qlik.cloud.client.model.ItemDetails) // {@link ApplicationItem#data() data} elements
   *    .build();
   * </pre>
   * @return A new ImmutableApplicationItem builder
   */
  public static ImmutableApplicationItem.Builder builder() {
    return new ImmutableApplicationItem.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableApplicationItem ImmutableApplicationItem}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ApplicationItem", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<ItemDetails> data = new ArrayList<ItemDetails>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationItem} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationItem instance) {
      Objects.requireNonNull(instance, "instance");
      addAllData(instance.data());
      return this;
    }

    /**
     * Adds one element to {@link ApplicationItem#data() data} list.
     * @param element A data element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addData(ItemDetails element) {
      this.data.add(Objects.requireNonNull(element, "data element"));
      return this;
    }

    /**
     * Adds elements to {@link ApplicationItem#data() data} list.
     * @param elements An array of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addData(ItemDetails... elements) {
      for (ItemDetails element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ApplicationItem#data() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("data")
    public final Builder data(Iterable<? extends ItemDetails> elements) {
      this.data.clear();
      return addAllData(elements);
    }

    /**
     * Adds elements to {@link ApplicationItem#data() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllData(Iterable<? extends ItemDetails> elements) {
      for (ItemDetails element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableApplicationItem ImmutableApplicationItem}.
     * @return An immutable instance of ApplicationItem
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableApplicationItem build() {
      return new ImmutableApplicationItem(List.copyOf(data));
    }
  }
}
