package zeenea.connector.qlik.cloud.client.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Application}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableApplication.builder()}.
 */
@Generated(from = "Application", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableApplication implements Application {
  private final @Nullable Attributes attributes;

  private ImmutableApplication(@Nullable Attributes attributes) {
    this.attributes = attributes;
  }

  /**
   * @return The value of the {@code attributes} attribute
   */
  @JsonProperty("attributes")
  @Override
  public @Nullable Attributes attributes() {
    return attributes;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Application#attributes() attributes} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for attributes (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableApplication withAttributes(@Nullable Attributes value) {
    if (this.attributes == value) return this;
    return new ImmutableApplication(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableApplication} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableApplication
        && equalTo(0, (ImmutableApplication) another);
  }

  private boolean equalTo(int synthetic, ImmutableApplication another) {
    return Objects.equals(attributes, another.attributes);
  }

  /**
   * Computes a hash code from attributes: {@code attributes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(attributes);
    return h;
  }

  /**
   * Prints the immutable value {@code Application} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Application{"
        + "attributes=" + attributes
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Application", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Application {
    @javax.annotation.Nullable Attributes attributes;
    @JsonProperty("attributes")
    public void setAttributes(@Nullable Attributes attributes) {
      this.attributes = attributes;
    }
    @Override
    public Attributes attributes() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableApplication fromJson(Json json) {
    ImmutableApplication.Builder builder = ImmutableApplication.builder();
    if (json.attributes != null) {
      builder.attributes(json.attributes);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Application} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Application instance
   */
  public static ImmutableApplication copyOf(Application instance) {
    if (instance instanceof ImmutableApplication) {
      return (ImmutableApplication) instance;
    }
    return ImmutableApplication.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableApplication ImmutableApplication}.
   * <pre>
   * ImmutableApplication.builder()
   *    .attributes(zeenea.connector.qlik.cloud.client.model.Attributes | null) // nullable {@link Application#attributes() attributes}
   *    .build();
   * </pre>
   * @return A new ImmutableApplication builder
   */
  public static ImmutableApplication.Builder builder() {
    return new ImmutableApplication.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableApplication ImmutableApplication}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Application", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable Attributes attributes;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Application} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Application instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Attributes attributesValue = instance.attributes();
      if (attributesValue != null) {
        attributes(attributesValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Application#attributes() attributes} attribute.
     * @param attributes The value for attributes (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("attributes")
    public final Builder attributes(@Nullable Attributes attributes) {
      this.attributes = attributes;
      return this;
    }

    /**
     * Builds a new {@link ImmutableApplication ImmutableApplication}.
     * @return An immutable instance of Application
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableApplication build() {
      return new ImmutableApplication(attributes);
    }
  }
}
