/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.http.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.ConnectionConfiguration;
import zeenea.connector.commons.api.ApiUrl;
import zeenea.connector.commons.api.TrustStoreConfig;
import zeenea.connector.commons.http.client.AcceptedType;
import zeenea.connector.commons.http.client.ContentTypeUtil;
import zeenea.connector.commons.http.client.EntityMapper;
import zeenea.connector.commons.http.client.HttpClientException;
import zeenea.connector.commons.http.client.HttpConflictException;
import zeenea.connector.commons.http.client.HttpForbiddenException;
import zeenea.connector.commons.http.client.HttpJsonMapper;
import zeenea.connector.commons.http.client.HttpNotFoundException;
import zeenea.connector.commons.http.client.HttpServerException;
import zeenea.connector.commons.http.client.HttpTooManyRequestsException;
import zeenea.connector.commons.http.client.HttpUnauthorizedException;
import zeenea.connector.commons.http.client.HttpXmlMapper;
import zeenea.connector.commons.http.client.HttpYamlMapper;
import zeenea.connector.commons.http.client.HttpZipMapper;
import zeenea.connector.commons.http.client.RestClientConfigException;
import zeenea.connector.commons.http.client.RestClientConfiguration;
import zeenea.connector.commons.http.client.RestClientException;
import zeenea.connector.commons.http.client.RestException;
import zeenea.connector.commons.http.client.RestOptions;
import zeenea.connector.commons.http.client.RestRequest;
import zeenea.connector.commons.http.client.auth.AuthHandler;
import zeenea.connector.commons.json.JsonParsingException;
import zeenea.connector.commons.log.SimpleLogger;
import zeenea.connector.commons.log.TracingContext;
import zeenea.connector.commons.proxy.Proxy;
import zeenea.connector.commons.util.Lazy;
import zeenea.connector.commons.util.ObjectUtil;
import zeenea.connector.commons.util.Pair;
import zeenea.connector.commons.xml.XmlDeserializationException;
import zeenea.connector.jdk.PropertyValueMap;
import zeenea.connector.source.SourceProperty;
import zeenea.connector.source.SourceStringProperty;

public class RestClient
implements Closeable {
    private static final String HTTP_REQUEST_KEY = "http_request";
    private static final String HTTP_STATUS_KEY = "http_status";
    @NotNull
    private static final SimpleLogger log = SimpleLogger.of(RestClient.class);
    @NotNull
    private static final HttpJsonMapper jsonMapper = HttpJsonMapper.of();
    @NotNull
    private static final HttpYamlMapper yamlMapper = HttpYamlMapper.of();
    @NotNull
    private static final HttpXmlMapper xmlMapper = HttpXmlMapper.of();
    @NotNull
    private static final HttpZipMapper zipMapper = HttpZipMapper.of();
    @NotNull
    private final String apiName;
    @NotNull
    private final URI endpoint;
    @NotNull
    private final CloseableHttpClient client;
    @Nullable
    private final AuthHandler authHandler;
    @Nullable
    private final HttpClientContext context;
    @Nullable
    private final Long timeout;
    @Nullable
    private final Long keepAlive;

    private RestClient(@NotNull Builder builder) {
        TrustStoreConfig trustStoreConfig;
        this.apiName = Objects.requireNonNull(builder.apiName);
        this.endpoint = Objects.requireNonNull(builder.endpoint);
        this.authHandler = builder.authHandler;
        this.context = builder.enableCookies ? HttpClientContext.create() : null;
        this.timeout = builder.timeout;
        this.keepAlive = builder.keepAlive;
        HttpClientBuilder clientBuilder = HttpClients.custom();
        Proxy proxy = builder.proxy;
        if (proxy != null) {
            HttpHost proxyHost = new HttpHost(proxy.getScheme(), proxy.getHostname(), proxy.getPort());
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyHost);
            clientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
            String username = proxy.getUsername();
            String password = proxy.getPassword();
            if (username != null && password != null) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(proxyHost), (Credentials)new UsernamePasswordCredentials(username, password.toCharArray()));
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
        }
        if ((trustStoreConfig = builder.trustStoreConfig) != null) {
            SSLContext sslContext = trustStoreConfig.createSSLContext(builder.ctx);
            HostnameVerifier hostnameVerifier = trustStoreConfig.createHostnameVerifier();
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
            PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).build();
            clientBuilder.setConnectionManager((HttpClientConnectionManager)cm);
        }
        RequestConfig.Builder requestConfig = RequestConfig.custom().setCookieSpec(builder.enableCookies || this.authHandler != null && this.authHandler.needsCookies() ? "strict" : "ignore");
        if (this.timeout != null) {
            requestConfig.setConnectTimeout(Timeout.ofMilliseconds((long)this.timeout)).setConnectionRequestTimeout(Timeout.ofMilliseconds((long)this.timeout)).setResponseTimeout(Timeout.ofMilliseconds((long)this.timeout));
        }
        if (this.keepAlive != null) {
            requestConfig.setConnectionKeepAlive((TimeValue)Timeout.ofMilliseconds((long)this.keepAlive));
        }
        clientBuilder.setDefaultRequestConfig(requestConfig.build());
        this.client = clientBuilder.build();
    }

    @Nullable
    public String getCookie(String key) {
        return this.context != null ? (String)this.context.getCookieStore().getCookies().stream().filter(c -> key.equalsIgnoreCase(c.getName())).findFirst().map(Cookie::getValue).orElse(null) : null;
    }

    public static Builder builder(@NotNull TracingContext ctx, String apiName) {
        return new Builder(ctx, apiName);
    }

    @Nullable
    public <T> T get(@NotNull TracingContext ctx, @NotNull String resourcePath, @Nullable Class<T> responseType, RestOptions ... options) throws RestException {
        return this.get(RestRequest.builder(responseType).ctx(ctx).path(resourcePath).options(options).build());
    }

    @Nullable
    public <T> T get(@NotNull TracingContext ctx, @NotNull String resourcePath, @Nullable TypeReference<T> responseType, RestOptions ... options) throws RestException {
        return this.get(RestRequest.builder(responseType).ctx(ctx).path(resourcePath).options(options).build());
    }

    @Nullable
    public <T> T get(@NotNull TracingContext ctx, @NotNull String resourcePath, @NotNull List<Pair<String, String>> queryParams, @Nullable Class<T> responseType, RestOptions ... options) throws RestException {
        return this.get(RestRequest.builder(responseType).ctx(ctx).path(resourcePath).queryParams(queryParams).options(options).build());
    }

    @Nullable
    public <T> T get(@NotNull TracingContext ctx, @NotNull String resourcePath, @NotNull List<Pair<String, String>> queryParams, @Nullable TypeReference<T> responseType, RestOptions ... options) throws RestException {
        return this.get(RestRequest.builder(responseType).ctx(ctx).path(resourcePath).queryParams(queryParams).options(options).build());
    }

    @Nullable
    public <T> T head(@NotNull RestRequest<T> restRequest) {
        return this.execute(restRequest, HttpHead::new);
    }

    @Nullable
    public <T> T get(@NotNull RestRequest<T> restRequest) {
        return this.execute(restRequest, HttpGet::new);
    }

    @Nullable
    public <T> T post(@NotNull TracingContext ctx, @NotNull String resourcePath, @NotNull Object requestBody, @Nullable Class<T> responseType, RestOptions ... options) {
        return this.post(RestRequest.builder(responseType).ctx(ctx).path(resourcePath).options(options).build(), requestBody);
    }

    @Nullable
    public <T> T post(@NotNull TracingContext ctx, @NotNull String resourcePath, @NotNull Object requestBody, @Nullable TypeReference<T> responseType, RestOptions ... options) {
        return this.post(RestRequest.builder(responseType).ctx(ctx).path(resourcePath).options(options).build(), requestBody);
    }

    @Nullable
    public <T> T post(@NotNull RestRequest<T> restRequest, @NotNull Object requestBody) {
        return this.execute(restRequest, uri -> {
            HttpPost request = new HttpPost(uri);
            request.setEntity(this.prepareBody(restRequest.ctx(), requestBody, restRequest.options()));
            return request;
        });
    }

    private HttpEntity prepareBody(@Nullable TracingContext ctx, @NotNull Object requestBody, Set<RestOptions> options) {
        if (options.contains((Object)RestOptions.FORM_ENCODED)) {
            if (requestBody instanceof Map) {
                List body = ((Map)requestBody).entrySet().stream().map(e -> new BasicNameValuePair(Objects.toString(e.getKey(), ""), Objects.toString(e.getValue(), ""))).collect(Collectors.toList());
                return new UrlEncodedFormEntity(body, StandardCharsets.UTF_8);
            }
            throw (RestClientException)log.entry(this.apiName + "_restapi_post_form_encoded_body_not_map").context(ctx).with("body_class", (Object)requestBody.getClass().getName()).exception(RestClientException::new);
        }
        if (options.contains((Object)RestOptions.XML) || options.contains((Object)RestOptions.XML_QUERY)) {
            return xmlMapper.writeAsEntity(requestBody);
        }
        return jsonMapper.writeAsEntity(requestBody);
    }

    @Nullable
    private <T> T execute(@NotNull RestRequest<T> restRequest, @NotNull Function<URI, HttpUriRequest> requestBuilder) {
        if (this.authHandler == null || restRequest.options().contains((Object)RestOptions.NO_AUTH)) {
            return this.prepareAndCall(restRequest, requestBuilder);
        }
        return this.authenticatePrepareAndCall(restRequest, requestBuilder);
    }

    @Nullable
    private <T> T prepareAndCall(@NotNull RestRequest<T> restRequest, @NotNull Function<URI, HttpUriRequest> requestBuilder) {
        URI uri = this.prepareUri(restRequest, Collections.emptyList());
        HttpUriRequest request = requestBuilder.apply(uri);
        this.prepareHeaders(restRequest, request);
        return this.call(restRequest.ctx(), request, restRequest.responseType(), restRequest.options(), restRequest.timeout(), restRequest.keepAlive());
    }

    @Nullable
    private <T> T authenticatePrepareAndCall(@NotNull RestRequest<T> restRequest, @NotNull Function<URI, HttpUriRequest> requestBuilder) {
        Objects.requireNonNull(this.authHandler, "authHandler");
        boolean retry = this.authHandler.retryOnUnauthorized();
        while (true) {
            URI uri = this.prepareUri(restRequest, this.authHandler.authenticationParams(restRequest.ctx(), this));
            HttpUriRequest request = requestBuilder.apply(uri);
            this.prepareHeaders(restRequest, request);
            for (Pair<String, String> header : this.authHandler.authenticationHeaders(restRequest.ctx(), this)) {
                request.addHeader((String)header.getKey(), header.getValue());
            }
            try {
                return this.call(restRequest.ctx(), request, restRequest.responseType(), restRequest.options(), restRequest.timeout(), restRequest.keepAlive());
            }
            catch (HttpUnauthorizedException e) {
                if (!retry) {
                    throw e;
                }
                retry = false;
                this.authHandler.reset();
                continue;
            }
            break;
        }
    }

    @NotNull
    private <T> URI prepareUri(@NotNull RestRequest<T> restRequest, @NotNull List<Pair<String, String>> authParams) {
        URI base = (URI)ObjectUtil.defaultTo((Object)restRequest.base(), (Object)this.endpoint);
        URIBuilder uriBuilder = new URIBuilder(base);
        uriBuilder.appendPathSegments(restRequest.path());
        for (Pair<String, String> p : authParams) {
            uriBuilder.addParameter((String)p.getKey(), (String)p.getValue());
        }
        for (Pair<String, String> p : restRequest.queryParams()) {
            uriBuilder.addParameter((String)p.getKey(), (String)p.getValue());
        }
        uriBuilder.normalizeSyntax();
        try {
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw (RestClientException)log.entry(this.apiName + "_restapi_prepare_uri_error").context(restRequest.ctx()).with("uri", (Object)uriBuilder.toString()).exception((Throwable)e, RestClientException::new);
        }
    }

    private <T> void prepareHeaders(@NotNull RestRequest<T> restRequest, @NotNull HttpUriRequest request) {
        for (Pair<String, String> header : restRequest.headers()) {
            request.addHeader((String)header.getKey(), header.getValue());
        }
        List<AcceptedType> acceptedTypes = restRequest.accept();
        if (acceptedTypes.isEmpty()) {
            Set<RestOptions> options = restRequest.options();
            acceptedTypes = options.contains((Object)RestOptions.DOWNLOAD_FILE) ? Collections.singletonList(AcceptedType.ANY) : (options.contains((Object)RestOptions.XML) || options.contains((Object)RestOptions.XML_RESPONSE) ? Arrays.asList(AcceptedType.APPLICATION_XML, AcceptedType.TEXT_XML) : Collections.singletonList(AcceptedType.JSON));
        }
        request.addHeader("Accept", (Object)acceptedTypes.stream().map(Object::toString).collect(Collectors.joining(",")));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private <T> T call(@Nullable TracingContext ctx, @NotNull HttpUriRequest request, @NotNull JavaType responseType, Set<RestOptions> options, Long requestTimeout, Long requestKeepAlive) {
        HttpClientContext httpContext;
        Lazy requestLine = Lazy.of(() -> request.getMethod() + " " + request.getRequestUri());
        Instant startTime = Instant.now();
        if (requestTimeout == null && requestKeepAlive == null) {
            httpContext = this.context;
        } else {
            httpContext = this.context == null ? HttpClientContext.create() : HttpClientContext.adapt((HttpContext)this.context);
            RequestConfig.Builder requestConfig = RequestConfig.copy((RequestConfig)httpContext.getRequestConfig());
            if (requestTimeout != null) {
                requestConfig.setConnectTimeout(Timeout.ofMilliseconds((long)requestTimeout));
                requestConfig.setConnectionRequestTimeout(Timeout.ofMilliseconds((long)requestTimeout));
                requestConfig.setResponseTimeout(Timeout.ofMilliseconds((long)requestTimeout));
            }
            if (requestKeepAlive != null) {
                requestConfig.setConnectionKeepAlive(TimeValue.ofMilliseconds((long)requestKeepAlive));
            }
            httpContext.setRequestConfig(requestConfig.build());
        }
        try (CloseableHttpResponse response = this.client.execute((ClassicHttpRequest)request, (HttpContext)httpContext);){
            try {
                int statusCode = response.getCode();
                if (200 <= statusCode && statusCode < 300) {
                    log.entry(this.apiName + "_restapi_call_success").context(ctx).startTime(startTime).with(HTTP_STATUS_KEY, (Object)String.valueOf(statusCode)).with(HTTP_REQUEST_KEY, (Supplier)requestLine).info();
                    HttpEntity entity = response.getEntity();
                    if (statusCode == 204 || responseType.getRawClass() == Void.class || entity == null) {
                        log.entry(this.apiName + "_restapi_response_no_content").context(ctx).with(HTTP_REQUEST_KEY, (Supplier)requestLine).trace();
                        T t = null;
                        return t;
                    }
                    if (options.contains((Object)RestOptions.DOWNLOAD_FILE)) {
                        T t = this.readFileBody(ctx, (Supplier<String>)requestLine, entity, responseType);
                        return t;
                    }
                    T t = this.readObjectBody(ctx, (Supplier<String>)requestLine, entity, responseType, options);
                    return t;
                }
                if (statusCode == 401) {
                    throw (HttpUnauthorizedException)log.entry(this.apiName + "_restapi_call_unauthorized").context(ctx).startTime(startTime).with(HTTP_REQUEST_KEY, (Supplier)requestLine).exception(HttpUnauthorizedException::new);
                }
                if (statusCode == 403) {
                    throw (HttpForbiddenException)log.entry(this.apiName + "_restapi_call_forbidden").context(ctx).startTime(startTime).with(HTTP_REQUEST_KEY, (Supplier)requestLine).exception(HttpForbiddenException::new);
                }
                if (statusCode == 404) {
                    throw (HttpNotFoundException)log.entry(this.apiName + "_restapi_call_not_found").context(ctx).startTime(startTime).with(HTTP_REQUEST_KEY, (Supplier)requestLine).exception(HttpNotFoundException::new);
                }
                if (statusCode == 409) {
                    throw (HttpConflictException)log.entry(this.apiName + "_restapi_call_conflict").context(ctx).startTime(startTime).with(HTTP_REQUEST_KEY, (Supplier)requestLine).exception(HttpConflictException::new);
                }
                if (statusCode == 429) {
                    throw (HttpTooManyRequestsException)log.entry(this.apiName + "_restapi_call_too_many_request").context(ctx).startTime(startTime).with(HTTP_REQUEST_KEY, (Supplier)requestLine).exception(HttpTooManyRequestsException::new);
                }
                if (400 <= statusCode && statusCode < 500) {
                    HttpEntity entity = response.getEntity();
                    String errorMessage = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                    throw (HttpClientException)log.entry(this.apiName + "_restapi_call_client_error").context(ctx).startTime(startTime).with(HTTP_STATUS_KEY, (Object)statusCode).with(HTTP_REQUEST_KEY, (Supplier)requestLine).body((Object)errorMessage).exception(HttpClientException::new);
                }
                if (500 > statusCode) throw (RestClientException)log.entry(this.apiName + "_restapi_call_unknown_status").context(ctx).startTime(startTime).with(HTTP_STATUS_KEY, (Object)statusCode).with(HTTP_REQUEST_KEY, (Supplier)requestLine).exception(RestClientException::new);
                if (statusCode >= 600) throw (RestClientException)log.entry(this.apiName + "_restapi_call_unknown_status").context(ctx).startTime(startTime).with(HTTP_STATUS_KEY, (Object)statusCode).with(HTTP_REQUEST_KEY, (Supplier)requestLine).exception(RestClientException::new);
                HttpEntity entity = response.getEntity();
                String errorMessage = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                throw (HttpServerException)log.entry(this.apiName + "_restapi_call_server_error").context(ctx).startTime(startTime).with(HTTP_STATUS_KEY, (Object)statusCode).with(HTTP_REQUEST_KEY, (Supplier)requestLine).body((Object)errorMessage).exception(HttpServerException::new);
            }
            finally {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
        }
        catch (IOException e) {
            throw (RestClientException)log.entry(this.apiName + "_restapi_call_failure").context(ctx).startTime(startTime).with(HTTP_REQUEST_KEY, (Supplier)requestLine).exception((Throwable)e, RestClientException::new);
        }
        catch (ParseException e) {
            throw (RestClientException)log.entry(this.apiName + "_restapi_response_invalid_http_response").context(ctx).with(HTTP_REQUEST_KEY, (Supplier)requestLine).exception((Throwable)e, RestClientException::new);
        }
    }

    @Nullable
    private <T> T readObjectBody(@Nullable TracingContext ctx, @NotNull Supplier<String> requestLine, @NotNull HttpEntity entity, @NotNull JavaType responseType, @NotNull Set<RestOptions> options) throws IOException, ParseException {
        try {
            Enum mapper;
            ContentType contentType = ContentTypeUtil.contentType(entity);
            if (this.isJsonResponse(contentType)) {
                mapper = jsonMapper;
            } else if (this.isYamlResponse(contentType)) {
                mapper = yamlMapper;
            } else if (this.isXmlResponse(contentType, options)) {
                mapper = xmlMapper;
            } else if (this.isZipResponse(contentType)) {
                mapper = zipMapper;
            } else {
                if (!options.contains((Object)RestOptions.NO_BODY_LOG)) {
                    log.entry(this.apiName + "_rest_api_unsupported_content_type").with("content_type", (Object)contentType.getMimeType()).body(() -> {
                        try {
                            return EntityUtils.toString((HttpEntity)entity);
                        }
                        catch (IOException | ParseException e) {
                            return "<Failed to read body>";
                        }
                    }).debug();
                }
                throw new RestClientException(String.format("Unsupported content of type '%s'", contentType.getMimeType()));
            }
            Object result = mapper.readEntity(entity, responseType);
            log.entry(this.apiName + "_restapi_response_content").context(ctx).with(HTTP_REQUEST_KEY, requestLine).body(() -> RestClient.lambda$readObjectBody$5(options, (EntityMapper)((Object)mapper), result)).trace();
            return result;
        }
        catch (JsonParsingException e) {
            log.entry(this.apiName + "_restapi_response_invalid_json_format").context(ctx).with(HTTP_REQUEST_KEY, requestLine).body(() -> e.getBody() != null && options.contains((Object)RestOptions.NO_BODY_LOG) ? "[REDACTED]" : e.getBody()).debug((Throwable)e);
            throw e;
        }
        catch (XmlDeserializationException e) {
            log.entry(this.apiName + "_restapi_response_invalid_xml_format").context(ctx).with(HTTP_REQUEST_KEY, requestLine).body(() -> e.getBody() != null && options.contains((Object)RestOptions.NO_BODY_LOG) ? "[REDACTED]" : e.getBody()).debug((Throwable)e);
            throw e;
        }
    }

    private boolean isJsonResponse(ContentType contentType) {
        return ContentType.APPLICATION_JSON.isSameMimeType(contentType);
    }

    private boolean isYamlResponse(ContentType contentType) {
        return ContentTypeUtil.APPLICATION_YAML.isSameMimeType(contentType);
    }

    private boolean isXmlResponse(@NotNull ContentType contentType, @NotNull Set<RestOptions> options) {
        if (options.contains((Object)RestOptions.XML) || options.contains((Object)RestOptions.XML_RESPONSE)) {
            return true;
        }
        String mimeType = contentType.getMimeType();
        return ContentTypeUtil.subTypeSet(mimeType).contains("xml");
    }

    private boolean isZipResponse(ContentType contentType) {
        return ContentTypeUtil.APPLICATION_ZIP.isSameMimeType(contentType);
    }

    private <T> T readFileBody(@Nullable TracingContext ctx, @NotNull Supplier<String> requestLine, @NotNull HttpEntity entity, @NotNull JavaType responseType) {
        try {
            Class rawClass = responseType.getRawClass();
            if (rawClass.equals(Path.class) || rawClass.equals(File.class)) {
                Path path = Files.createTempFile(this.apiName, ".download", new FileAttribute[0]);
                try (OutputStream outStream = Files.newOutputStream(path, new OpenOption[0]);){
                    entity.writeTo(outStream);
                }
                return rawClass.cast(rawClass.equals(File.class) ? path.toFile() : path);
            }
            if (rawClass.equals(String.class)) {
                return rawClass.cast(EntityUtils.toString((HttpEntity)entity));
            }
            throw (RestClientException)log.entry(this.apiName + "_restapi_download_invalid_response_type").context(ctx).with(HTTP_REQUEST_KEY, requestLine).exception(RestClientException::new);
        }
        catch (IOException | ParseException e) {
            throw (RestClientException)log.entry(this.apiName + "_restapi_download_file_failed").context(ctx).with(HTTP_REQUEST_KEY, requestLine).exception(e, RestClientException::new);
        }
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    private static /* synthetic */ Object lambda$readObjectBody$5(Set options, EntityMapper mapper, Object result) {
        return options.contains((Object)RestOptions.NO_BODY_LOG) ? "[REDACTED]" : mapper.prettyPrint(result);
    }

    public static final class Builder {
        @NotNull
        private final TracingContext ctx;
        private final String apiName;
        private URI endpoint;
        private AuthHandler authHandler;
        private TrustStoreConfig trustStoreConfig;
        private Proxy proxy;
        private boolean enableCookies;
        private boolean configRead;
        private Long timeout;
        private Long keepAlive;

        private Builder(@NotNull TracingContext ctx, String apiName) {
            this.ctx = ctx;
            this.apiName = Objects.requireNonNull(apiName);
        }

        public Builder configuration(@NotNull ConnectionConfiguration configuration) {
            this.configRead = true;
            configuration.getStringOptional("connection.url").ifPresent(this::endpoint);
            return this;
        }

        public Builder configuration(@NotNull PropertyValueMap configuration) {
            this.configRead = true;
            configuration.get((SourceStringProperty)RestClientConfiguration.API_ENDPOINT).ifPresent(this::endpoint);
            return this;
        }

        public Builder endpoint(String value) throws RestClientConfigException {
            try {
                return this.endpoint(new URI(value));
            }
            catch (URISyntaxException e) {
                throw new RestClientConfigException("endpoint must be an URI");
            }
        }

        public Builder endpoint(URI value) throws RestClientConfigException {
            this.endpoint = ApiUrl.normalize((TracingContext)this.ctx, (URI)value);
            return this;
        }

        public Builder trustStoreConfig(TrustStoreConfig trustStoreConfig) {
            this.trustStoreConfig = trustStoreConfig;
            return this;
        }

        public Builder proxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder authHandler(AuthHandler authHandler) {
            this.authHandler = authHandler;
            return this;
        }

        public Builder enableCookies(boolean enableCookies) {
            this.enableCookies = enableCookies;
            return this;
        }

        public Builder timeout(Long value) {
            this.timeout = value;
            return this;
        }

        public Builder keepAlive(Long value) {
            this.keepAlive = value;
            return this;
        }

        @NotNull
        public RestClient build() {
            if (this.endpoint == null) {
                RestClientConfigException.throwConfigException(this.configRead, (SourceProperty)RestClientConfiguration.API_ENDPOINT, "endpoint must be defined");
            }
            return new RestClient(this);
        }
    }
}

