/*
 * Decompiled with CFR 0.152.
 */
package zeenea.connector.commons.api.quota;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.jetbrains.annotations.NotNull;
import zeenea.connector.commons.api.quota.Quota;
import zeenea.connector.commons.api.quota.QuotaTicket;
import zeenea.connector.commons.log.Durations;
import zeenea.connector.commons.log.SimpleLogger;
import zeenea.connector.commons.util.UncheckedInterruptedException;

public abstract class AbstractQuota
implements Quota {
    private static final SimpleLogger log = SimpleLogger.of(AbstractQuota.class);
    private final String name;

    protected AbstractQuota(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @NotNull
    protected abstract QuotaTicket requestTicket();

    @Override
    public void consume() {
        QuotaTicket ticket;
        log.entry("quota_consume").with("name", this.name()).debug();
        long startTime = System.nanoTime();
        while (!(ticket = this.requestTicket()).isGranted()) {
            long deadline = ticket.deadline().toEpochMilli();
            do {
                log.entry("quota_consume_park").with("name", this.name()).with("delay", () -> deadline - System.currentTimeMillis()).trace();
                LockSupport.parkUntil(deadline);
                if (!Thread.interrupted()) continue;
                throw new UncheckedInterruptedException();
            } while (System.currentTimeMillis() < deadline);
        }
        log.entry("quota_consume_end").startTimeNanos(startTime).with("name", this.name()).trace();
    }

    @Override
    public boolean consume(long time, TimeUnit unit) {
        log.entry("quota_consume_with_timeout").with("name", this.name()).with("wait_time", time).with("unit", (Object)unit).debug();
        long startTime = System.nanoTime();
        long lastDeadline = System.currentTimeMillis() + unit.toMillis(time);
        boolean granted = false;
        do {
            QuotaTicket ticket;
            if ((ticket = this.requestTicket()).isGranted()) {
                granted = true;
                break;
            }
            Instant deadline = ticket.deadline();
            long deadlineMillis = deadline.toEpochMilli();
            log.entry("quota_consume_ticket_denied").with("name", this.name()).with("deadline", () -> deadline).with("delay", () -> Durations.toString(Duration.between(Instant.now(), deadline))).debug();
            if (deadlineMillis > lastDeadline) break;
            LockSupport.parkUntil(deadlineMillis);
            if (!Thread.interrupted()) continue;
            throw new UncheckedInterruptedException();
        } while (System.currentTimeMillis() < lastDeadline);
        log.entry("quota_consume_with_timeout_end").startTimeNanos(startTime).with("name", this.name()).with("granted", granted).trace();
        return granted;
    }

    @Override
    public boolean tryConsume() {
        return this.requestTicket().isGranted();
    }
}

