/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParserKeywordsUtils {
    public static final CharsetEncoder CHARSET_ENCODER = StandardCharsets.US_ASCII.newEncoder();
    public static final int RESTRICTED_FUNCTION = 1;
    public static final int RESTRICTED_SCHEMA = 2;
    public static final int RESTRICTED_TABLE = 4;
    public static final int RESTRICTED_COLUMN = 8;
    public static final int RESTRICTED_EXPRESSION = 16;
    public static final int RESTRICTED_ALIAS = 32;
    public static final int RESTRICTED_SQL2016 = 64;
    public static final int RESTRICTED_JSQLPARSER = 255;
    public static final Object[][] ALL_RESERVED_KEYWORDS = new Object[][]{{"ABSENT", 255}, {"ALL", 64}, {"AND", 64}, {"ANY", 255}, {"AS", 64}, {"BETWEEN", 64}, {"BOTH", 64}, {"CASEWHEN", 32}, {"CHECK", 64}, {"CONNECT", 32}, {"CONNECT_BY_ROOT", 255}, {"CONSTRAINT", 64}, {"CREATE", 32}, {"CROSS", 64}, {"CURRENT", 255}, {"DISTINCT", 64}, {"DOUBLE", 32}, {"ELSE", 255}, {"EXCEPT", 64}, {"EXISTS", 64}, {"FETCH", 64}, {"FINAL", 255}, {"FOR", 64}, {"FORCE", 64}, {"FOREIGN", 64}, {"FROM", 64}, {"FULL", 64}, {"GROUP", 64}, {"GROUPING", 32}, {"QUALIFY", 32}, {"HAVING", 64}, {"IF", 64}, {"IIF", 32}, {"IGNORE", 32}, {"ILIKE", 64}, {"IN", 64}, {"INNER", 64}, {"INTERSECT", 64}, {"INTERVAL", 64}, {"INTO", 255}, {"IS", 64}, {"JOIN", 255}, {"LATERAL", 64}, {"LEFT", 64}, {"LIKE", 64}, {"LIMIT", 64}, {"MINUS", 64}, {"NATURAL", 64}, {"NOCYCLE", 255}, {"NOT", 64}, {"NULL", 64}, {"OFFSET", 64}, {"ON", 64}, {"ONLY", 255}, {"OPTIMIZE", 32}, {"OR", 64}, {"ORDER", 64}, {"OUTER", 255}, {"OUTPUT", 255}, {"OPTIMIZE ", 255}, {"PIVOT", 255}, {"PROCEDURE", 32}, {"PUBLIC", 32}, {"RECURSIVE", 64}, {"REGEXP", 64}, {"RETURNING", 255}, {"RIGHT", 64}, {"SAMPLE", 32}, {"SEL", 32}, {"SELECT", 32}, {"SEMI", 255}, {"SET", 255}, {"SOME", 255}, {"START", 255}, {"TABLES", 32}, {"TOP", 64}, {"TRAILING", 64}, {"UNBOUNDED", 255}, {"UNION", 64}, {"UNIQUE", 64}, {"UNPIVOT", 255}, {"USE", 255}, {"USING", 64}, {"SQL_CACHE", 255}, {"SQL_CALC_FOUND_ROWS", 255}, {"SQL_NO_CACHE", 255}, {"STRAIGHT_JOIN", 255}, {"TABLESAMPLE", 32}, {"VALUE", 255}, {"VALUES", 64}, {"VARYING", 255}, {"WHEN", 64}, {"WHERE", 64}, {"WINDOW", 64}, {"WITH", 64}, {"XOR", 255}, {"XMLSERIALIZE", 255}, {"SEL", 255}, {"SELECT", 255}, {"DATE", 255}, {"TIME", 255}, {"TIMESTAMP", 255}, {"YEAR", 255}, {"MONTH", 255}, {"DAY", 255}, {"HOUR", 255}, {"MINUTE", 255}, {"SECOND", 255}, {"SUBSTR", 255}, {"SUBSTRING", 255}, {"TRIM", 255}, {"POSITION", 255}, {"OVERLAY", 255}, {"NEXTVAL", 255}, {"0x", 255}};

    public static List<String> getReservedKeywords(int restriction) {
        ArrayList<String> keywords = new ArrayList<String>();
        for (Object[] data : ALL_RESERVED_KEYWORDS) {
            int value = (Integer)data[1];
            if ((value & restriction) != restriction && (restriction & value) != value) continue;
            keywords.add((String)data[0]);
        }
        return keywords;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            throw new IllegalArgumentException("No filename provided as parameters ARGS[0]");
        }
        File grammarFile = new File(args[0]);
        if (!(grammarFile.exists() && grammarFile.canRead() && grammarFile.canWrite())) {
            throw new FileNotFoundException("Can't read file " + args[0]);
        }
        ParserKeywordsUtils.buildGrammarForRelObjectName(grammarFile);
        ParserKeywordsUtils.buildGrammarForRelObjectNameWithoutValue(grammarFile);
        File keywordDocumentationFile = new File(args[1]);
        keywordDocumentationFile.createNewFile();
        if (!keywordDocumentationFile.canWrite()) {
            throw new FileNotFoundException("Can't read file " + args[1]);
        }
        ParserKeywordsUtils.writeKeywordsDocumentationFile(keywordDocumentationFile);
    }

    public static TreeSet<String> getAllKeywordsUsingRegex(File file) throws IOException {
        Pattern tokenBlockPattern = Pattern.compile("TOKEN\\s*:\\s*(?:/\\*.*\\*/*)\\n\\{(?:[^\\}\\{]+|\\{(?:[^\\}\\{]+|\\{[^\\}\\{]*\\})*\\})*\\}", 8);
        Pattern tokenStringValuePattern = Pattern.compile("\\\"(\\w{2,})\\\"", 8);
        TreeSet<String> allKeywords = new TreeSet<String>();
        Path path = file.toPath();
        Charset charset = Charset.defaultCharset();
        String content = new String(Files.readAllBytes(path), charset);
        Matcher tokenBlockmatcher = tokenBlockPattern.matcher(content);
        while (tokenBlockmatcher.find()) {
            String tokenBlock = tokenBlockmatcher.group(0);
            Matcher tokenStringValueMatcher = tokenStringValuePattern.matcher(tokenBlock);
            while (tokenStringValueMatcher.find()) {
                String tokenValue = tokenStringValueMatcher.group(1);
                if (!CHARSET_ENCODER.canEncode(tokenValue) || !tokenValue.matches("[A-Za-z]+")) continue;
                allKeywords.add(tokenValue);
            }
        }
        return allKeywords;
    }

    public static void buildGrammarForRelObjectNameWithoutValue(File file) throws Exception {
        Pattern methodBlockPattern = Pattern.compile("String\\W*RelObjectNameWithoutValue\\W*\\(\\W*\\)\\W*:\\s*\\{(?:[^}{]+|\\{(?:[^}{]+|\\{[^}{]*})*})*}\\s*\\{(?:[^}{]+|\\{(?:[^}{]+|\\{[^}{]*})*})*}", 8);
        TreeSet<String> allKeywords = ParserKeywordsUtils.getAllKeywords(file);
        for (String reserved : ParserKeywordsUtils.getReservedKeywords(255)) {
            allKeywords.remove(reserved);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("String RelObjectNameWithoutValue() :\n{    Token tk = null; }\n{\n    ( tk=<S_IDENTIFIER> | tk=<S_QUOTED_IDENTIFIER> |  tk=<K_DATE_LITERAL> | tk=<K_DATETIMELITERAL> | tk=<K_STRING_FUNCTION_NAME> | tk=<K_ISOLATION> | tk=<K_TIME_KEY_EXPR> \n      ");
        for (String keyword : allKeywords) {
            builder.append(" | tk=\"").append(keyword).append("\"");
        }
        builder.append(" )\n    { return tk.image; }\n}");
        ParserKeywordsUtils.replaceInFile(file, methodBlockPattern, builder.toString());
    }

    public static void buildGrammarForRelObjectName(File file) throws Exception {
        TreeSet<String> allKeywords = new TreeSet<String>();
        for (String reserved : ParserKeywordsUtils.getReservedKeywords(32)) {
            allKeywords.add(reserved);
        }
        for (String reserved : ParserKeywordsUtils.getReservedKeywords(223)) {
            allKeywords.remove(reserved);
        }
        StringBuilder builder = new StringBuilder();
        builder.append("String RelObjectName() :\n{    Token tk = null; String result = null; }\n{\n    (result = RelObjectNameWithoutValue()\n      ");
        for (String keyword : allKeywords) {
            builder.append(" | tk=\"").append(keyword).append("\"");
        }
        builder.append(" )\n    { return tk!=null ? tk.image : result; }\n}");
    }

    public static TreeSet<String> getAllKeywords(File file) throws Exception {
        return ParserKeywordsUtils.getAllKeywordsUsingRegex(file);
    }

    private static void replaceInFile(File file, Pattern pattern, String replacement) throws IOException {
        Path path = file.toPath();
        Charset charset = Charset.defaultCharset();
        String content = new String(Files.readAllBytes(path), charset);
        content = pattern.matcher(content).replaceAll(replacement);
        Files.write(file.toPath(), content.getBytes(charset), new OpenOption[0]);
    }

    public static String rightPadding(String input, char ch, int length) {
        return String.format("%" + -length + "s", input).replace(' ', ch);
    }

    public static void writeKeywordsDocumentationFile(File file) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append("***********************\n");
        builder.append("Restricted Keywords\n");
        builder.append("***********************\n");
        builder.append("\n");
        builder.append("The following Keywords are **restricted** in JSQLParser-|JSQLPARSER_VERSION| and must not be used for **Naming Objects**: \n");
        builder.append("\n");
        builder.append("+----------------------+-------------+-----------+\n");
        builder.append("| **Keyword**          | JSQL Parser | SQL:2016  |\n");
        builder.append("+----------------------+-------------+-----------+\n");
        for (Object[] keywordDefinition : ALL_RESERVED_KEYWORDS) {
            builder.append("| ").append(ParserKeywordsUtils.rightPadding(keywordDefinition[0].toString(), ' ', 20)).append(" | ");
            int value = (Integer)keywordDefinition[1];
            int restriction = 255;
            String s = (value & restriction) == restriction || (restriction & value) == value ? "Yes" : "";
            builder.append(ParserKeywordsUtils.rightPadding(s, ' ', 11)).append(" | ");
            restriction = 64;
            s = (value & restriction) == restriction || (restriction & value) == value ? "Yes" : "";
            builder.append(ParserKeywordsUtils.rightPadding(s, ' ', 9)).append(" | ");
            builder.append("\n");
            builder.append("+----------------------+-------------+-----------+\n");
        }
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.append(builder);
            fileWriter.flush();
        }
    }
}

