package zeenea.connector.powerbi.v2.client.pbix;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import zeenea.connector.powerbi.v2.client.deserializer.ConfigurationDeserializer;

/**
 * Immutable implementation of {@link VisualContainer}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableVisualContainer.builder()}.
 */
@Generated(from = "VisualContainer", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableVisualContainer implements VisualContainer {
  private final @Nullable Configuration configuration;

  private ImmutableVisualContainer(
      @Nullable Configuration configuration) {
    this.configuration = configuration;
  }

  /**
   * @return The value of the {@code configuration} attribute
   */
  @JsonProperty("config")
  @JsonDeserialize(using = ConfigurationDeserializer.class)
  @Override
  public @Nullable Configuration getConfiguration() {
    return configuration;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VisualContainer#getConfiguration() configuration} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for configuration (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVisualContainer withConfiguration(@Nullable Configuration value) {
    if (this.configuration == value) return this;
    return new ImmutableVisualContainer(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableVisualContainer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableVisualContainer
        && equalTo(0, (ImmutableVisualContainer) another);
  }

  private boolean equalTo(int synthetic, ImmutableVisualContainer another) {
    return Objects.equals(configuration, another.configuration);
  }

  /**
   * Computes a hash code from attributes: {@code configuration}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(configuration);
    return h;
  }

  /**
   * Prints the immutable value {@code VisualContainer} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "VisualContainer{"
        + "configuration=" + configuration
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "VisualContainer", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements VisualContainer {
    @javax.annotation.Nullable Configuration configuration;
    @JsonProperty("config")
    @JsonDeserialize(using = ConfigurationDeserializer.class)
    public void setConfiguration(@Nullable Configuration configuration) {
      this.configuration = configuration;
    }
    @Override
    public Configuration getConfiguration() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableVisualContainer fromJson(Json json) {
    ImmutableVisualContainer.Builder builder = ImmutableVisualContainer.builder();
    if (json.configuration != null) {
      builder.configuration(json.configuration);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link VisualContainer} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable VisualContainer instance
   */
  public static ImmutableVisualContainer copyOf(VisualContainer instance) {
    if (instance instanceof ImmutableVisualContainer) {
      return (ImmutableVisualContainer) instance;
    }
    return ImmutableVisualContainer.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableVisualContainer ImmutableVisualContainer}.
   * <pre>
   * ImmutableVisualContainer.builder()
   *    .configuration(zeenea.connector.powerbi.v2.client.pbix.Configuration | null) // nullable {@link VisualContainer#getConfiguration() configuration}
   *    .build();
   * </pre>
   * @return A new ImmutableVisualContainer builder
   */
  public static ImmutableVisualContainer.Builder builder() {
    return new ImmutableVisualContainer.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableVisualContainer ImmutableVisualContainer}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "VisualContainer", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable Configuration configuration;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code VisualContainer} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(VisualContainer instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Configuration configurationValue = instance.getConfiguration();
      if (configurationValue != null) {
        configuration(configurationValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link VisualContainer#getConfiguration() configuration} attribute.
     * @param configuration The value for configuration (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("config")
    @JsonDeserialize(using = ConfigurationDeserializer.class)
    public final Builder configuration(@Nullable Configuration configuration) {
      this.configuration = configuration;
      return this;
    }

    /**
     * Builds a new {@link ImmutableVisualContainer ImmutableVisualContainer}.
     * @return An immutable instance of VisualContainer
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableVisualContainer build() {
      return new ImmutableVisualContainer(configuration);
    }
  }
}
