package zeenea.connector.powerbi.v2.client.pbix;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SourceRef}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSourceRef.builder()}.
 */
@Generated(from = "SourceRef", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableSourceRef implements SourceRef {
  private final String source;

  private ImmutableSourceRef(String source) {
    this.source = source;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @JsonProperty("Source")
  @Override
  public String getSource() {
    return source;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SourceRef#getSource() source} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSourceRef withSource(String value) {
    String newValue = Objects.requireNonNull(value, "source");
    if (this.source.equals(newValue)) return this;
    return new ImmutableSourceRef(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSourceRef} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSourceRef
        && equalTo(0, (ImmutableSourceRef) another);
  }

  private boolean equalTo(int synthetic, ImmutableSourceRef another) {
    return source.equals(another.source);
  }

  /**
   * Computes a hash code from attributes: {@code source}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + source.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SourceRef} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SourceRef{"
        + "source=" + source
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "SourceRef", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SourceRef {
    @Nullable String source;
    @JsonProperty("Source")
    public void setSource(String source) {
      this.source = source;
    }
    @Override
    public String getSource() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSourceRef fromJson(Json json) {
    ImmutableSourceRef.Builder builder = ImmutableSourceRef.builder();
    if (json.source != null) {
      builder.source(json.source);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SourceRef} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SourceRef instance
   */
  public static ImmutableSourceRef copyOf(SourceRef instance) {
    if (instance instanceof ImmutableSourceRef) {
      return (ImmutableSourceRef) instance;
    }
    return ImmutableSourceRef.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSourceRef ImmutableSourceRef}.
   * <pre>
   * ImmutableSourceRef.builder()
   *    .source(String) // required {@link SourceRef#getSource() source}
   *    .build();
   * </pre>
   * @return A new ImmutableSourceRef builder
   */
  public static ImmutableSourceRef.Builder builder() {
    return new ImmutableSourceRef.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSourceRef ImmutableSourceRef}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SourceRef", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_SOURCE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String source;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SourceRef} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SourceRef instance) {
      Objects.requireNonNull(instance, "instance");
      this.source(instance.getSource());
      return this;
    }

    /**
     * Initializes the value for the {@link SourceRef#getSource() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Source")
    public final Builder source(String source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSourceRef ImmutableSourceRef}.
     * @return An immutable instance of SourceRef
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSourceRef build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSourceRef(source);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SOURCE) != 0) attributes.add("source");
      return "Cannot build SourceRef, some of required attributes are not set " + attributes;
    }
  }
}
