package zeenea.connector.powerbi.v2.client.pbix;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Section}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSection.builder()}.
 */
@Generated(from = "Section", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableSection implements Section {
  private final String displayName;
  private final List<VisualContainer> visualContainers;

  private ImmutableSection(
      String displayName,
      List<VisualContainer> visualContainers) {
    this.displayName = displayName;
    this.visualContainers = visualContainers;
  }

  /**
   * @return The value of the {@code displayName} attribute
   */
  @JsonProperty("displayName")
  @Override
  public String getDisplayName() {
    return displayName;
  }

  /**
   * @return The value of the {@code visualContainers} attribute
   */
  @JsonProperty("visualContainers")
  @Override
  public List<VisualContainer> getVisualContainers() {
    return visualContainers;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Section#getDisplayName() displayName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for displayName
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSection withDisplayName(String value) {
    String newValue = Objects.requireNonNull(value, "displayName");
    if (this.displayName.equals(newValue)) return this;
    return new ImmutableSection(newValue, this.visualContainers);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Section#getVisualContainers() visualContainers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSection withVisualContainers(VisualContainer... elements) {
    List<VisualContainer> newValue = List.of(elements);
    return new ImmutableSection(this.displayName, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Section#getVisualContainers() visualContainers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of visualContainers elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSection withVisualContainers(Iterable<? extends VisualContainer> elements) {
    if (this.visualContainers == elements) return this;
    List<VisualContainer> newValue = elements instanceof Collection<?>
        ? List.copyOf((Collection<? extends VisualContainer>) elements)
        : StreamSupport.stream(elements.spliterator(), false)
            .collect(Collectors.toUnmodifiableList());
    return new ImmutableSection(this.displayName, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSection} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSection
        && equalTo(0, (ImmutableSection) another);
  }

  private boolean equalTo(int synthetic, ImmutableSection another) {
    return displayName.equals(another.displayName)
        && visualContainers.equals(another.visualContainers);
  }

  /**
   * Computes a hash code from attributes: {@code displayName}, {@code visualContainers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + displayName.hashCode();
    h += (h << 5) + visualContainers.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Section} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Section{"
        + "displayName=" + displayName
        + ", visualContainers=" + visualContainers
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Section", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Section {
    @Nullable String displayName;
    @Nullable List<VisualContainer> visualContainers = List.of();
    @JsonProperty("displayName")
    public void setDisplayName(String displayName) {
      this.displayName = displayName;
    }
    @JsonProperty("visualContainers")
    public void setVisualContainers(List<VisualContainer> visualContainers) {
      this.visualContainers = visualContainers;
    }
    @Override
    public String getDisplayName() { throw new UnsupportedOperationException(); }
    @Override
    public List<VisualContainer> getVisualContainers() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSection fromJson(Json json) {
    ImmutableSection.Builder builder = ImmutableSection.builder();
    if (json.displayName != null) {
      builder.displayName(json.displayName);
    }
    if (json.visualContainers != null) {
      builder.addAllVisualContainers(json.visualContainers);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Section} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Section instance
   */
  public static ImmutableSection copyOf(Section instance) {
    if (instance instanceof ImmutableSection) {
      return (ImmutableSection) instance;
    }
    return ImmutableSection.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSection ImmutableSection}.
   * <pre>
   * ImmutableSection.builder()
   *    .displayName(String) // required {@link Section#getDisplayName() displayName}
   *    .addVisualContainers|addAllVisualContainers(zeenea.connector.powerbi.v2.client.pbix.VisualContainer) // {@link Section#getVisualContainers() visualContainers} elements
   *    .build();
   * </pre>
   * @return A new ImmutableSection builder
   */
  public static ImmutableSection.Builder builder() {
    return new ImmutableSection.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSection ImmutableSection}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Section", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DISPLAY_NAME = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String displayName;
    private List<VisualContainer> visualContainers = new ArrayList<VisualContainer>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Section} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Section instance) {
      Objects.requireNonNull(instance, "instance");
      this.displayName(instance.getDisplayName());
      addAllVisualContainers(instance.getVisualContainers());
      return this;
    }

    /**
     * Initializes the value for the {@link Section#getDisplayName() displayName} attribute.
     * @param displayName The value for displayName 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("displayName")
    public final Builder displayName(String displayName) {
      this.displayName = Objects.requireNonNull(displayName, "displayName");
      initBits &= ~INIT_BIT_DISPLAY_NAME;
      return this;
    }

    /**
     * Adds one element to {@link Section#getVisualContainers() visualContainers} list.
     * @param element A visualContainers element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addVisualContainers(VisualContainer element) {
      this.visualContainers.add(Objects.requireNonNull(element, "visualContainers element"));
      return this;
    }

    /**
     * Adds elements to {@link Section#getVisualContainers() visualContainers} list.
     * @param elements An array of visualContainers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addVisualContainers(VisualContainer... elements) {
      for (VisualContainer element : elements) {
        this.visualContainers.add(Objects.requireNonNull(element, "visualContainers element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Section#getVisualContainers() visualContainers} list.
     * @param elements An iterable of visualContainers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("visualContainers")
    public final Builder visualContainers(Iterable<? extends VisualContainer> elements) {
      this.visualContainers.clear();
      return addAllVisualContainers(elements);
    }

    /**
     * Adds elements to {@link Section#getVisualContainers() visualContainers} list.
     * @param elements An iterable of visualContainers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllVisualContainers(Iterable<? extends VisualContainer> elements) {
      for (VisualContainer element : elements) {
        this.visualContainers.add(Objects.requireNonNull(element, "visualContainers element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableSection ImmutableSection}.
     * @return An immutable instance of Section
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSection build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSection(displayName, List.copyOf(visualContainers));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DISPLAY_NAME) != 0) attributes.add("displayName");
      return "Cannot build Section, some of required attributes are not set " + attributes;
    }
  }
}
