package zeenea.connector.powerbi.v2.client.pbix;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Expression}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableExpression.builder()}.
 */
@Generated(from = "Expression", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableExpression implements Expression {
  private final @Nullable Column column;
  private final @Nullable SourceRef sourceRef;

  private ImmutableExpression(
      @Nullable Column column,
      @Nullable SourceRef sourceRef) {
    this.column = column;
    this.sourceRef = sourceRef;
  }

  /**
   * @return The value of the {@code column} attribute
   */
  @JsonProperty("Column")
  @Override
  public @Nullable Column getColumn() {
    return column;
  }

  /**
   * @return The value of the {@code sourceRef} attribute
   */
  @JsonProperty("SourceRef")
  @Override
  public @Nullable SourceRef getSourceRef() {
    return sourceRef;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Expression#getColumn() column} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for column (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExpression withColumn(@Nullable Column value) {
    if (this.column == value) return this;
    return new ImmutableExpression(value, this.sourceRef);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Expression#getSourceRef() sourceRef} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sourceRef (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableExpression withSourceRef(@Nullable SourceRef value) {
    if (this.sourceRef == value) return this;
    return new ImmutableExpression(this.column, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableExpression} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableExpression
        && equalTo(0, (ImmutableExpression) another);
  }

  private boolean equalTo(int synthetic, ImmutableExpression another) {
    return Objects.equals(column, another.column)
        && Objects.equals(sourceRef, another.sourceRef);
  }

  /**
   * Computes a hash code from attributes: {@code column}, {@code sourceRef}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(column);
    h += (h << 5) + Objects.hashCode(sourceRef);
    return h;
  }

  /**
   * Prints the immutable value {@code Expression} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Expression{"
        + "column=" + column
        + ", sourceRef=" + sourceRef
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Expression", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Expression {
    @javax.annotation.Nullable Column column;
    @javax.annotation.Nullable SourceRef sourceRef;
    @JsonProperty("Column")
    public void setColumn(@Nullable Column column) {
      this.column = column;
    }
    @JsonProperty("SourceRef")
    public void setSourceRef(@Nullable SourceRef sourceRef) {
      this.sourceRef = sourceRef;
    }
    @Override
    public Column getColumn() { throw new UnsupportedOperationException(); }
    @Override
    public SourceRef getSourceRef() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableExpression fromJson(Json json) {
    ImmutableExpression.Builder builder = ImmutableExpression.builder();
    if (json.column != null) {
      builder.column(json.column);
    }
    if (json.sourceRef != null) {
      builder.sourceRef(json.sourceRef);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Expression} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Expression instance
   */
  public static ImmutableExpression copyOf(Expression instance) {
    if (instance instanceof ImmutableExpression) {
      return (ImmutableExpression) instance;
    }
    return ImmutableExpression.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableExpression ImmutableExpression}.
   * <pre>
   * ImmutableExpression.builder()
   *    .column(zeenea.connector.powerbi.v2.client.pbix.Column | null) // nullable {@link Expression#getColumn() column}
   *    .sourceRef(zeenea.connector.powerbi.v2.client.pbix.SourceRef | null) // nullable {@link Expression#getSourceRef() sourceRef}
   *    .build();
   * </pre>
   * @return A new ImmutableExpression builder
   */
  public static ImmutableExpression.Builder builder() {
    return new ImmutableExpression.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableExpression ImmutableExpression}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Expression", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable Column column;
    private @javax.annotation.Nullable SourceRef sourceRef;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Expression} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Expression instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Column columnValue = instance.getColumn();
      if (columnValue != null) {
        column(columnValue);
      }
      @Nullable SourceRef sourceRefValue = instance.getSourceRef();
      if (sourceRefValue != null) {
        sourceRef(sourceRefValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Expression#getColumn() column} attribute.
     * @param column The value for column (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Column")
    public final Builder column(@Nullable Column column) {
      this.column = column;
      return this;
    }

    /**
     * Initializes the value for the {@link Expression#getSourceRef() sourceRef} attribute.
     * @param sourceRef The value for sourceRef (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("SourceRef")
    public final Builder sourceRef(@Nullable SourceRef sourceRef) {
      this.sourceRef = sourceRef;
      return this;
    }

    /**
     * Builds a new {@link ImmutableExpression ImmutableExpression}.
     * @return An immutable instance of Expression
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableExpression build() {
      return new ImmutableExpression(column, sourceRef);
    }
  }
}
