package zeenea.connector.powerbi.v2.client.pbix;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;

/**
 * Immutable implementation of {@link Configuration}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableConfiguration.builder()}.
 */
@Generated(from = "Configuration", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableConfiguration implements Configuration {
  private final @Nullable SingleVisual singleVisual;

  private ImmutableConfiguration(
      @Nullable SingleVisual singleVisual) {
    this.singleVisual = singleVisual;
  }

  /**
   * @return The value of the {@code singleVisual} attribute
   */
  @JsonProperty("singleVisual")
  @Override
  public @Nullable SingleVisual getSingleVisual() {
    return singleVisual;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Configuration#getSingleVisual() singleVisual} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for singleVisual (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConfiguration withSingleVisual(@Nullable SingleVisual value) {
    if (this.singleVisual == value) return this;
    return new ImmutableConfiguration(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@javax.annotation.Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConfiguration
        && equalTo(0, (ImmutableConfiguration) another);
  }

  private boolean equalTo(int synthetic, ImmutableConfiguration another) {
    return Objects.equals(singleVisual, another.singleVisual);
  }

  /**
   * Computes a hash code from attributes: {@code singleVisual}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(singleVisual);
    return h;
  }

  /**
   * Prints the immutable value {@code Configuration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Configuration{"
        + "singleVisual=" + singleVisual
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Configuration", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Configuration {
    @javax.annotation.Nullable SingleVisual singleVisual;
    @JsonProperty("singleVisual")
    public void setSingleVisual(@Nullable SingleVisual singleVisual) {
      this.singleVisual = singleVisual;
    }
    @Override
    public SingleVisual getSingleVisual() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableConfiguration fromJson(Json json) {
    ImmutableConfiguration.Builder builder = ImmutableConfiguration.builder();
    if (json.singleVisual != null) {
      builder.singleVisual(json.singleVisual);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Configuration} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Configuration instance
   */
  public static ImmutableConfiguration copyOf(Configuration instance) {
    if (instance instanceof ImmutableConfiguration) {
      return (ImmutableConfiguration) instance;
    }
    return ImmutableConfiguration.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableConfiguration ImmutableConfiguration}.
   * <pre>
   * ImmutableConfiguration.builder()
   *    .singleVisual(zeenea.connector.powerbi.v2.client.pbix.SingleVisual | null) // nullable {@link Configuration#getSingleVisual() singleVisual}
   *    .build();
   * </pre>
   * @return A new ImmutableConfiguration builder
   */
  public static ImmutableConfiguration.Builder builder() {
    return new ImmutableConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableConfiguration ImmutableConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Configuration", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @javax.annotation.Nullable SingleVisual singleVisual;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Configuration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Configuration instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable SingleVisual singleVisualValue = instance.getSingleVisual();
      if (singleVisualValue != null) {
        singleVisual(singleVisualValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Configuration#getSingleVisual() singleVisual} attribute.
     * @param singleVisual The value for singleVisual (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("singleVisual")
    public final Builder singleVisual(@Nullable SingleVisual singleVisual) {
      this.singleVisual = singleVisual;
      return this;
    }

    /**
     * Builds a new {@link ImmutableConfiguration ImmutableConfiguration}.
     * @return An immutable instance of Configuration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableConfiguration build() {
      return new ImmutableConfiguration(singleVisual);
    }
  }
}
