package zeenea.connector.powerbi.v2.client.pbix;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Aggregation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAggregation.builder()}.
 */
@Generated(from = "Aggregation", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableAggregation implements Aggregation {
  private final Expression expression;

  private ImmutableAggregation(Expression expression) {
    this.expression = expression;
  }

  /**
   * @return The value of the {@code expression} attribute
   */
  @JsonProperty("Expression")
  @Override
  public Expression getExpression() {
    return expression;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Aggregation#getExpression() expression} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expression
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAggregation withExpression(Expression value) {
    if (this.expression == value) return this;
    Expression newValue = Objects.requireNonNull(value, "expression");
    return new ImmutableAggregation(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAggregation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAggregation
        && equalTo(0, (ImmutableAggregation) another);
  }

  private boolean equalTo(int synthetic, ImmutableAggregation another) {
    return expression.equals(another.expression);
  }

  /**
   * Computes a hash code from attributes: {@code expression}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + expression.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Aggregation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Aggregation{"
        + "expression=" + expression
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Aggregation", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Aggregation {
    @Nullable Expression expression;
    @JsonProperty("Expression")
    public void setExpression(Expression expression) {
      this.expression = expression;
    }
    @Override
    public Expression getExpression() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAggregation fromJson(Json json) {
    ImmutableAggregation.Builder builder = ImmutableAggregation.builder();
    if (json.expression != null) {
      builder.expression(json.expression);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Aggregation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Aggregation instance
   */
  public static ImmutableAggregation copyOf(Aggregation instance) {
    if (instance instanceof ImmutableAggregation) {
      return (ImmutableAggregation) instance;
    }
    return ImmutableAggregation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAggregation ImmutableAggregation}.
   * <pre>
   * ImmutableAggregation.builder()
   *    .expression(zeenea.connector.powerbi.v2.client.pbix.Expression) // required {@link Aggregation#getExpression() expression}
   *    .build();
   * </pre>
   * @return A new ImmutableAggregation builder
   */
  public static ImmutableAggregation.Builder builder() {
    return new ImmutableAggregation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAggregation ImmutableAggregation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Aggregation", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_EXPRESSION = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Expression expression;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Aggregation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Aggregation instance) {
      Objects.requireNonNull(instance, "instance");
      this.expression(instance.getExpression());
      return this;
    }

    /**
     * Initializes the value for the {@link Aggregation#getExpression() expression} attribute.
     * @param expression The value for expression 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Expression")
    public final Builder expression(Expression expression) {
      this.expression = Objects.requireNonNull(expression, "expression");
      initBits &= ~INIT_BIT_EXPRESSION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableAggregation ImmutableAggregation}.
     * @return An immutable instance of Aggregation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAggregation build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAggregation(expression);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EXPRESSION) != 0) attributes.add("expression");
      return "Cannot build Aggregation, some of required attributes are not set " + attributes;
    }
  }
}
